/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.google.common.collect.Lists;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaEntity;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.json.JsonSchemaUtils;
import io.confluent.kafka.schemaregistry.json.diff.Difference;
import io.confluent.kafka.schemaregistry.json.diff.SchemaDiff;
import io.confluent.kafka.schemaregistry.json.jackson.Jackson;
import io.confluent.kafka.schemaregistry.rules.FieldTransform;
import io.confluent.kafka.schemaregistry.rules.RuleContext;
import io.confluent.kafka.schemaregistry.rules.RuleException;
import io.confluent.kafka.schemaregistry.utils.BoundedConcurrentHashMap;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.ConditionalSchema;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.FalseSchema;
import org.everit.json.schema.NotSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.SpecificationVersion;
import org.everit.json.schema.loader.internal.ReferenceResolver;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchema
implements ParsedSchema {
    private static final Logger log = LoggerFactory.getLogger(JsonSchema.class);
    public static final String TYPE = "JSON";
    public static final String TAGS = "confluent:tags";
    private static final String SCHEMA_KEYWORD = "$schema";
    private static final String PROPERTIES_KEYWORD = "properties";
    private static final Object NONE_MARKER = new Object();
    private final JsonNode jsonNode;
    private transient Schema schemaObj;
    private final Integer version;
    private final List<SchemaReference> references;
    private final Map<String, String> resolvedReferences;
    private final Metadata metadata;
    private final RuleSet ruleSet;
    private transient String canonicalString;
    private transient int hashCode = Integer.MIN_VALUE;
    private static final int NO_HASHCODE = Integer.MIN_VALUE;
    private static final int DEFAULT_CACHE_CAPACITY = 1000;
    private static final ObjectMapper objectMapper = Jackson.newObjectMapper();
    private static final ObjectMapper objectMapperWithOrderedProps = Jackson.newObjectMapper(true);
    private static final Map<String, Map<String, BeanPropertyWriter>> beanGetters = new BoundedConcurrentHashMap(1000);
    private static final Map<String, Map<String, SettableBeanProperty>> beanSetters = new BoundedConcurrentHashMap(1000);

    public JsonSchema(JsonNode jsonNode) {
        this(jsonNode, Collections.emptyList(), Collections.emptyMap(), null);
    }

    public JsonSchema(String schemaString) {
        this(schemaString, Collections.emptyList(), Collections.emptyMap(), null);
    }

    public JsonSchema(JsonNode jsonNode, List<SchemaReference> references, Map<String, String> resolvedReferences, Integer version) {
        this.jsonNode = jsonNode;
        this.version = version;
        this.references = Collections.unmodifiableList(references);
        this.resolvedReferences = Collections.unmodifiableMap(resolvedReferences);
        this.metadata = null;
        this.ruleSet = null;
    }

    public JsonSchema(String schemaString, List<SchemaReference> references, Map<String, String> resolvedReferences, Integer version) {
        this(schemaString, references, resolvedReferences, null, null, version);
    }

    public JsonSchema(String schemaString, List<SchemaReference> references, Map<String, String> resolvedReferences, Metadata metadata, RuleSet ruleSet, Integer version) {
        try {
            this.jsonNode = schemaString != null ? objectMapper.readTree(schemaString) : null;
            this.version = version;
            this.references = Collections.unmodifiableList(references);
            this.resolvedReferences = Collections.unmodifiableMap(resolvedReferences);
            this.metadata = metadata;
            this.ruleSet = ruleSet;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid JSON " + schemaString, e);
        }
    }

    public JsonSchema(Schema schemaObj) {
        this(schemaObj, null);
    }

    public JsonSchema(Schema schemaObj, Integer version) {
        try {
            this.jsonNode = schemaObj != null ? objectMapper.readTree(schemaObj.toString()) : null;
            this.schemaObj = schemaObj;
            this.version = version;
            this.references = Collections.emptyList();
            this.resolvedReferences = Collections.emptyMap();
            this.metadata = null;
            this.ruleSet = null;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid JSON " + schemaObj, e);
        }
    }

    private JsonSchema(JsonNode jsonNode, Schema schemaObj, Integer version, List<SchemaReference> references, Map<String, String> resolvedReferences, Metadata metadata, RuleSet ruleSet, String canonicalString) {
        this.jsonNode = jsonNode;
        this.schemaObj = schemaObj;
        this.version = version;
        this.references = references;
        this.resolvedReferences = resolvedReferences;
        this.metadata = metadata;
        this.ruleSet = ruleSet;
        this.canonicalString = canonicalString;
    }

    public JsonSchema copy() {
        return new JsonSchema(this.jsonNode, this.schemaObj, this.version, this.references, this.resolvedReferences, this.metadata, this.ruleSet, this.canonicalString);
    }

    public JsonSchema copy(Integer version) {
        return new JsonSchema(this.jsonNode, this.schemaObj, version, this.references, this.resolvedReferences, this.metadata, this.ruleSet, this.canonicalString);
    }

    public JsonSchema copy(Metadata metadata, RuleSet ruleSet) {
        return new JsonSchema(this.jsonNode, this.schemaObj, this.version, this.references, this.resolvedReferences, metadata, ruleSet, this.canonicalString);
    }

    public ParsedSchema copy(Map<SchemaEntity, Set<String>> tagsToAdd, Map<SchemaEntity, Set<String>> tagsToRemove) {
        JsonSchema schemaCopy = this.copy();
        JsonNode original = schemaCopy.toJsonNode().deepCopy();
        this.modifySchemaTags(original, tagsToAdd, tagsToRemove);
        return new JsonSchema(original.toString(), schemaCopy.references(), schemaCopy.resolvedReferences(), schemaCopy.metadata(), schemaCopy.ruleSet(), schemaCopy.version());
    }

    public JsonNode toJsonNode() {
        return this.jsonNode;
    }

    public Schema rawSchema() {
        if (this.jsonNode == null) {
            return null;
        }
        if (this.schemaObj == null) {
            try {
                String id;
                String schema;
                SpecificationVersion spec = SpecificationVersion.DRAFT_7;
                if (this.jsonNode.has(SCHEMA_KEYWORD) && (schema = this.jsonNode.get(SCHEMA_KEYWORD).asText()) != null) {
                    spec = SpecificationVersion.lookupByMetaSchemaUrl((String)schema).orElse(SpecificationVersion.DRAFT_7);
                }
                URI idUri = null;
                if (this.jsonNode.has(spec.idKeyword()) && (id = this.jsonNode.get(spec.idKeyword()).asText()) != null) {
                    idUri = ReferenceResolver.resolve((URI)null, (String)id);
                }
                SchemaLoader.SchemaLoaderBuilder builder = SchemaLoader.builder().useDefaults(true).draftV7Support();
                for (Map.Entry<String, String> dep : this.resolvedReferences.entrySet()) {
                    URI child = ReferenceResolver.resolve((URI)idUri, (String)dep.getKey());
                    builder.registerSchemaByURI(child, (Object)new JSONObject(dep.getValue()));
                }
                JSONObject jsonObject = (JSONObject)objectMapper.treeToValue((TreeNode)this.jsonNode, JSONObject.class);
                builder.schemaJson(jsonObject);
                SchemaLoader loader = builder.build();
                this.schemaObj = loader.load().build();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid JSON", e);
            }
        }
        return this.schemaObj;
    }

    public boolean hasTopLevelField(String field) {
        if (this.jsonNode != null) {
            JsonNode properties = this.jsonNode.get(PROPERTIES_KEYWORD);
            return properties instanceof ObjectNode && properties.has(field);
        }
        return false;
    }

    public String schemaType() {
        return TYPE;
    }

    public String name() {
        return this.getString("title");
    }

    public boolean has(String key) {
        return this.jsonNode.has(key);
    }

    public String getString(String key) {
        return this.jsonNode.has(key) ? this.jsonNode.get(key).asText() : null;
    }

    public String canonicalString() {
        if (this.jsonNode == null) {
            return null;
        }
        if (this.canonicalString == null) {
            try {
                this.canonicalString = objectMapper.writeValueAsString((Object)this.jsonNode);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid JSON", e);
            }
        }
        return this.canonicalString;
    }

    public Integer version() {
        return this.version;
    }

    public List<SchemaReference> references() {
        return this.references;
    }

    public Map<String, String> resolvedReferences() {
        return this.resolvedReferences;
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public RuleSet ruleSet() {
        return this.ruleSet;
    }

    public JsonSchema normalize() {
        String canonical = this.canonicalString();
        if (canonical == null) {
            return this;
        }
        try {
            JsonNode jsonNode = objectMapperWithOrderedProps.readTree(canonical);
            return new JsonSchema(jsonNode, this.references.stream().sorted().distinct().collect(Collectors.toList()), this.resolvedReferences, this.version);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid JSON", e);
        }
    }

    public void validate(boolean strict) {
        ObjectSchema schema;
        Optional<String> restrictedField;
        Schema rawSchema = this.rawSchema();
        if (strict && rawSchema instanceof ObjectSchema && (restrictedField = (schema = (ObjectSchema)rawSchema).getPropertySchemas().keySet().stream().filter(field -> field.startsWith("$$")).findAny()).isPresent()) {
            throw new ValidationException((Schema)schema, "Field names cannot start with $$ prefix", PROPERTIES_KEYWORD, String.format("#/properties/%s", restrictedField.get()));
        }
    }

    public void validate(Object value) throws JsonProcessingException, ValidationException {
        JsonSchema.validate(this.rawSchema(), value);
    }

    public static void validate(Schema schema, Object value) throws JsonProcessingException, ValidationException {
        Object primitiveValue = NONE_MARKER;
        if (JsonSchema.isPrimitive(value)) {
            primitiveValue = value;
        } else if (value instanceof BinaryNode) {
            primitiveValue = ((BinaryNode)value).asText();
        } else if (value instanceof BooleanNode) {
            primitiveValue = ((BooleanNode)value).asBoolean();
        } else if (value instanceof NullNode) {
            primitiveValue = null;
        } else if (value instanceof NumericNode) {
            primitiveValue = ((NumericNode)value).numberValue();
        } else if (value instanceof TextNode) {
            primitiveValue = ((TextNode)value).asText();
        }
        if (primitiveValue != NONE_MARKER) {
            schema.validate(primitiveValue);
        } else {
            Object jsonObject = value instanceof ArrayNode ? objectMapper.treeToValue((TreeNode)((ArrayNode)value), JSONArray.class) : (value instanceof JsonNode ? objectMapper.treeToValue((TreeNode)((JsonNode)value), JSONObject.class) : (value.getClass().isArray() ? objectMapper.convertValue(value, JSONArray.class) : objectMapper.convertValue(value, JSONObject.class)));
            schema.validate(jsonObject);
        }
    }

    private static boolean isPrimitive(Object value) {
        return value == null || value instanceof Boolean || value instanceof Number || value instanceof String;
    }

    public List<String> isBackwardCompatible(ParsedSchema previousSchema) {
        if (!this.schemaType().equals(previousSchema.schemaType())) {
            return Lists.newArrayList((Object[])new String[]{"Incompatible because of different schema type"});
        }
        List<Difference> differences = SchemaDiff.compare(((JsonSchema)previousSchema).rawSchema(), this.rawSchema());
        List incompatibleDiffs = differences.stream().filter(diff -> !SchemaDiff.COMPATIBLE_CHANGES.contains((Object)diff.getType())).collect(Collectors.toList());
        boolean isCompatible = incompatibleDiffs.isEmpty();
        if (!isCompatible) {
            ArrayList<String> errorMessages = new ArrayList<String>();
            for (Difference incompatibleDiff : incompatibleDiffs) {
                errorMessages.add(incompatibleDiff.toString());
            }
            return errorMessages;
        }
        return new ArrayList<String>();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonSchema that = (JsonSchema)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.references, that.references) && Objects.equals(this.canonicalString(), that.canonicalString()) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.ruleSet, that.ruleSet);
    }

    public int hashCode() {
        if (this.hashCode == Integer.MIN_VALUE) {
            this.hashCode = Objects.hash(this.jsonNode, this.references, this.version, this.metadata, this.ruleSet);
        }
        return this.hashCode;
    }

    public String toString() {
        return this.canonicalString();
    }

    public Object fromJson(JsonNode json) {
        return json;
    }

    public JsonNode toJson(Object message) throws IOException {
        if (message instanceof JsonNode) {
            return (JsonNode)message;
        }
        return objectMapper.readTree(JsonSchemaUtils.toJson(message));
    }

    public Object copyMessage(Object message) throws IOException {
        if (message instanceof JsonNode) {
            return ((JsonNode)message).deepCopy();
        }
        return this.toJson(message);
    }

    public Object transformMessage(RuleContext ctx, FieldTransform transform, Object message) throws RuleException {
        try {
            return this.toTransformedMessage(ctx, this.rawSchema(), "$", message, transform);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RuleException) {
                throw (RuleException)e.getCause();
            }
            throw e;
        }
    }

    private Object toTransformedMessage(RuleContext ctx, Schema schema, String path, Object message, FieldTransform transform) {
        RuleContext.FieldContext fieldCtx = ctx.currentField();
        if (schema == null) {
            return message;
        }
        message = this.getValue(message);
        if (fieldCtx != null) {
            fieldCtx.setType(this.getType(schema));
        }
        if (schema instanceof CombinedSchema) {
            JsonNode jsonNode = (JsonNode)objectMapper.convertValue(message, JsonNode.class);
            for (Schema subschema : ((CombinedSchema)schema).getSubschemas()) {
                boolean valid = false;
                try {
                    JsonSchema.validate(subschema, jsonNode);
                    valid = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!valid) continue;
                return this.toTransformedMessage(ctx, subschema, path, message, transform);
            }
            return message;
        }
        if (schema instanceof ArraySchema) {
            if (!(message instanceof Iterable)) {
                log.warn("Object does not match an array schema");
                return message;
            }
            Schema subschema = ((ArraySchema)schema).getAllItemSchema();
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            for (Object o : (Iterable)message) {
                result.add(this.toTransformedMessage(ctx, subschema, path + "[" + i + "]", o, transform));
                ++i;
            }
            return result;
        }
        if (schema instanceof ObjectSchema) {
            if (message == null) {
                return null;
            }
            Map propertySchemas = ((ObjectSchema)schema).getPropertySchemas();
            for (Map.Entry entry : propertySchemas.entrySet()) {
                String propertyName = (String)entry.getKey();
                Schema propertySchema = (Schema)entry.getValue();
                String fullName = path + "." + propertyName;
                RuleContext.FieldContext ignored = ctx.enterField(ctx, message, fullName, propertyName, this.getType(propertySchema), this.getInlineTags(propertySchema));
                Throwable throwable = null;
                try {
                    PropertyAccessor propertyAccessor = JsonSchema.getPropertyAccessor(ctx, message, propertyName);
                    Object value = propertyAccessor.getPropertyValue();
                    Object newValue = this.toTransformedMessage(ctx, propertySchema, fullName, value, transform);
                    propertyAccessor.setPropertyValue(newValue);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored == null) continue;
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignored.close();
                }
            }
            return message;
        }
        if (schema instanceof ReferenceSchema) {
            if (message == null) {
                return null;
            }
            return this.toTransformedMessage(ctx, ((ReferenceSchema)schema).getReferredSchema(), path, message, transform);
        }
        if (schema instanceof ConditionalSchema || schema instanceof EmptySchema || schema instanceof FalseSchema || schema instanceof NotSchema) {
            return message;
        }
        if (fieldCtx != null) {
            try {
                SortedSet ruleTags = ctx.rule().getTags();
                if (ruleTags.isEmpty()) {
                    return transform.transform(ctx, fieldCtx, message);
                }
                if (!Collections.disjoint(fieldCtx.getTags(), ruleTags)) {
                    return transform.transform(ctx, fieldCtx, message);
                }
            }
            catch (RuleException e) {
                throw new RuntimeException(e);
            }
        }
        return message;
    }

    private Object getValue(Object message) {
        if (message instanceof TextNode) {
            return ((TextNode)message).asText();
        }
        if (message instanceof NumericNode) {
            return ((NumericNode)message).numberValue();
        }
        if (message instanceof BooleanNode) {
            return ((BooleanNode)message).asBoolean();
        }
        if (message instanceof NullNode) {
            return null;
        }
        return message;
    }

    private RuleContext.Type getType(Schema schema) {
        if (schema instanceof ObjectSchema) {
            return JsonSchema.isMap((ObjectSchema)schema) ? RuleContext.Type.MAP : RuleContext.Type.RECORD;
        }
        if (schema instanceof EnumSchema) {
            return RuleContext.Type.ENUM;
        }
        if (schema instanceof ArraySchema) {
            return RuleContext.Type.ARRAY;
        }
        if (schema instanceof CombinedSchema) {
            return RuleContext.Type.COMBINED;
        }
        if (schema instanceof StringSchema) {
            return RuleContext.Type.STRING;
        }
        if (schema instanceof NumberSchema) {
            NumberSchema numberSchema = (NumberSchema)schema;
            return numberSchema.requiresInteger() ? RuleContext.Type.INT : RuleContext.Type.DOUBLE;
        }
        if (schema instanceof BooleanSchema) {
            return RuleContext.Type.BOOLEAN;
        }
        return RuleContext.Type.NULL;
    }

    private static boolean isMap(ObjectSchema objectSchema) {
        return objectSchema.getPropertySchemas() == null || objectSchema.getPropertySchemas().isEmpty();
    }

    public Set<String> inlineTags() {
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        if (this.jsonNode == null) {
            return tags;
        }
        this.getInlineTagsRecursively(tags, this.jsonNode);
        return tags;
    }

    private void getInlineTagsRecursively(Set<String> tags, JsonNode node) {
        tags.addAll(this.getInlineTags(node));
        node.forEach(n -> this.getInlineTagsRecursively(tags, (JsonNode)n));
    }

    private Set<String> getInlineTags(Schema propertySchema) {
        Object prop = propertySchema.getUnprocessedProperties().get(TAGS);
        if (prop instanceof List) {
            return ((List)prop).stream().map(Object::toString).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private Set<String> getInlineTags(JsonNode tagNode) {
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        if (tagNode.has(TAGS)) {
            ArrayNode tagArray = (ArrayNode)tagNode.get(TAGS);
            tagArray.elements().forEachRemaining(tag -> tags.add(tag.asText()));
        }
        return tags;
    }

    private static PropertyAccessor getPropertyAccessor(RuleContext ctx, final Object message, final String propertyName) {
        if (message instanceof ObjectNode) {
            return new PropertyAccessor(){

                @Override
                public Object getPropertyValue() {
                    return ((ObjectNode)message).get(propertyName);
                }

                @Override
                public void setPropertyValue(Object value) {
                    ObjectNode objectNode = (ObjectNode)message;
                    if (value instanceof List) {
                        ArrayNode arrayNode = objectNode.putArray(propertyName);
                        ((List)value).forEach(v -> this.addArrayValue(arrayNode, v));
                    } else if (value instanceof JsonNode) {
                        objectNode.set(propertyName, (JsonNode)value);
                    } else if (value instanceof Boolean) {
                        objectNode.put(propertyName, (Boolean)value);
                    } else if (value instanceof BigDecimal) {
                        objectNode.put(propertyName, (BigDecimal)value);
                    } else if (value instanceof BigInteger) {
                        objectNode.put(propertyName, (BigInteger)value);
                    } else if (value instanceof Long) {
                        objectNode.put(propertyName, (Long)value);
                    } else if (value instanceof Double) {
                        objectNode.put(propertyName, (Double)value);
                    } else if (value instanceof Float) {
                        objectNode.put(propertyName, (Float)value);
                    } else if (value instanceof Integer) {
                        objectNode.put(propertyName, (Integer)value);
                    } else if (value instanceof Short) {
                        objectNode.put(propertyName, (Short)value);
                    } else if (value instanceof Byte) {
                        objectNode.put(propertyName, (short)((Byte)value).byteValue());
                    } else if (value instanceof byte[]) {
                        objectNode.put(propertyName, (byte[])value);
                    } else if (value == null) {
                        objectNode.putNull(propertyName);
                    } else {
                        objectNode.put(propertyName, value.toString());
                    }
                }

                private void addArrayValue(ArrayNode arrayNode, Object value) {
                    if (value instanceof JsonNode) {
                        arrayNode.add((JsonNode)value);
                    } else if (value instanceof Boolean) {
                        arrayNode.add((Boolean)value);
                    } else if (value instanceof BigDecimal) {
                        arrayNode.add((BigDecimal)value);
                    } else if (value instanceof BigInteger) {
                        arrayNode.add((BigInteger)value);
                    } else if (value instanceof Long) {
                        arrayNode.add((Long)value);
                    } else if (value instanceof Double) {
                        arrayNode.add((Double)value);
                    } else if (value instanceof Float) {
                        arrayNode.add((Float)value);
                    } else if (value instanceof Integer) {
                        arrayNode.add((Integer)value);
                    } else if (value instanceof Short) {
                        arrayNode.add((Short)value);
                    } else if (value instanceof Byte) {
                        arrayNode.add((short)((Byte)value).byteValue());
                    } else if (value instanceof byte[]) {
                        arrayNode.add((byte[])value);
                    } else {
                        arrayNode.add(value.toString());
                    }
                }
            };
        }
        final BeanPropertyWriter getter = JsonSchema.getBeanGetter(ctx, message, propertyName);
        final SettableBeanProperty setter = JsonSchema.getBeanSetter(ctx, message, propertyName);
        return new PropertyAccessor(){

            @Override
            public Object getPropertyValue() {
                try {
                    return getter.get(message);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not get property " + propertyName, e);
                }
            }

            @Override
            public void setPropertyValue(Object value) {
                try {
                    if (value instanceof Number) {
                        Number num = (Number)value;
                        Class cls = setter.getType().getRawClass();
                        if (cls == Byte.TYPE || cls == Byte.class) {
                            value = num.byteValue();
                        } else if (cls == Short.TYPE || cls == Short.class) {
                            value = num.shortValue();
                        } else if (cls == Integer.TYPE || cls == Integer.class) {
                            value = num.intValue();
                        } else if (cls == Long.TYPE || cls == Long.class) {
                            value = num.longValue();
                        } else if (cls == Float.TYPE || cls == Float.class) {
                            value = Float.valueOf(num.floatValue());
                        } else if (cls == Double.TYPE || cls == Double.class) {
                            value = num.doubleValue();
                        }
                    }
                    setter.set(message, value);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not set property " + propertyName, e);
                }
            }
        };
    }

    private static BeanPropertyWriter getBeanGetter(RuleContext ctx, Object message, String propertyName) {
        Map props = beanGetters.computeIfAbsent(message.getClass().getName(), k -> {
            try {
                HashMap<String, BeanPropertyWriter> m = new HashMap<String, BeanPropertyWriter>();
                JsonSerializer ser = objectMapper.getSerializerProviderInstance().findValueSerializer(message.getClass());
                Iterator propIter = ser.properties();
                while (propIter.hasNext()) {
                    PropertyWriter p = (PropertyWriter)propIter.next();
                    if (!(p instanceof BeanPropertyWriter)) continue;
                    m.put(p.getName(), (BeanPropertyWriter)p);
                }
                return m;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not find JSON serializer for " + message.getClass(), e);
            }
        });
        return (BeanPropertyWriter)props.get(propertyName);
    }

    private static SettableBeanProperty getBeanSetter(RuleContext ctx, Object message, String propertyName) {
        Map props = beanSetters.computeIfAbsent(message.getClass().getName(), k -> {
            try {
                HashMap<String, SettableBeanProperty> m = new HashMap<String, SettableBeanProperty>();
                JavaType type = objectMapper.constructType(message.getClass());
                DefaultDeserializationContext ctxt = ((DefaultDeserializationContext.Impl)objectMapper.getDeserializationContext()).createDummyInstance(objectMapper.getDeserializationConfig());
                JsonDeserializer deser = ctxt.findRootValueDeserializer(type);
                if (deser instanceof BeanDeserializer) {
                    Iterator propIter = ((BeanDeserializer)deser).properties();
                    while (propIter.hasNext()) {
                        SettableBeanProperty p = (SettableBeanProperty)propIter.next();
                        m.put(p.getName(), p);
                    }
                }
                return m;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not find JSON deserializer for " + message.getClass(), e);
            }
        });
        return (SettableBeanProperty)props.get(propertyName);
    }

    private void modifySchemaTags(JsonNode node, Map<SchemaEntity, Set<String>> tagsToAddMap, Map<SchemaEntity, Set<String>> tagsToRemoveMap) {
        LinkedHashSet<SchemaEntity> entityToModify = new LinkedHashSet<SchemaEntity>(tagsToAddMap.keySet());
        entityToModify.addAll(tagsToRemoveMap.keySet());
        for (SchemaEntity entity : entityToModify) {
            Set<String> tagsToRemove;
            JsonNode fieldNodePtr = JsonSchemaUtils.findMatchingEntity(node, entity);
            Set<String> allTags = this.getInlineTags(fieldNodePtr);
            Set<String> tagsToAdd = tagsToAddMap.get(entity);
            if (tagsToAdd != null && !tagsToAdd.isEmpty()) {
                allTags.addAll(tagsToAdd);
            }
            if ((tagsToRemove = tagsToRemoveMap.get(entity)) != null && !tagsToRemove.isEmpty()) {
                allTags.removeAll(tagsToRemove);
            }
            if (allTags.isEmpty()) {
                ((ObjectNode)fieldNodePtr).remove(TAGS);
                continue;
            }
            ((ObjectNode)fieldNodePtr).replace(TAGS, objectMapper.valueToTree(allTags));
        }
    }

    static interface PropertyAccessor {
        public Object getPropertyValue();

        public void setPropertyValue(Object var1);
    }
}

