/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json;

import io.confluent.kafka.schemaregistry.AbstractSchemaProvider;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaProvider
extends AbstractSchemaProvider {
    private static final Logger log = LoggerFactory.getLogger(JsonSchemaProvider.class);

    public String schemaType() {
        return "JSON";
    }

    public ParsedSchema parseSchemaOrElseThrow(Schema schema, boolean isNew, boolean normalize) {
        try {
            return new JsonSchema(schema.getSchema(), schema.getReferences(), this.resolveReferences(schema, isNew), schema.getMetadata(), schema.getRuleSet(), null);
        }
        catch (Exception e) {
            log.error("Could not parse JSON schema", (Throwable)e);
            throw new IllegalArgumentException("Invalid schema of type " + schema.getSchemaType() + ", details: " + e.getMessage(), e);
        }
    }
}

