/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.json;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.json.AbstractKafkaJsonSchemaDeserializer;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaDeserializerConfig;
import java.io.IOException;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;

public class KafkaJsonSchemaDeserializer<T>
extends AbstractKafkaJsonSchemaDeserializer<T>
implements Deserializer<T> {
    private boolean isKey;

    public KafkaJsonSchemaDeserializer() {
    }

    public KafkaJsonSchemaDeserializer(SchemaRegistryClient client) {
        this.schemaRegistry = client;
    }

    public KafkaJsonSchemaDeserializer(SchemaRegistryClient client, Map<String, ?> props) {
        this(client, props, null);
    }

    @VisibleForTesting
    public KafkaJsonSchemaDeserializer(SchemaRegistryClient client, Map<String, ?> props, Class<T> type) {
        this.schemaRegistry = client;
        this.configure(this.deserializerConfig(props), type);
    }

    public void configure(Map<String, ?> props, boolean isKey) {
        this.configure(new KafkaJsonSchemaDeserializerConfig(props), isKey);
    }

    protected void configure(KafkaJsonSchemaDeserializerConfig config, boolean isKey) {
        this.isKey = isKey;
        if (isKey) {
            this.configure(config, config.getClass("json.key.type"));
        } else {
            this.configure(config, config.getClass("json.value.type"));
        }
    }

    public T deserialize(String ignored, byte[] bytes) {
        return this.deserialize(bytes);
    }

    public void close() {
        try {
            super.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while closing deserializer", e);
        }
    }
}

