/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.formatter.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.formatter.SchemaMessageDeserializer;
import io.confluent.kafka.formatter.SchemaMessageFormatter;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.json.jackson.Jackson;
import io.confluent.kafka.serializers.json.AbstractKafkaJsonSchemaDeserializer;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class JsonSchemaMessageFormatter
extends SchemaMessageFormatter<JsonNode> {
    private static final ObjectMapper objectMapper = Jackson.newObjectMapper();

    public JsonSchemaMessageFormatter() {
    }

    JsonSchemaMessageFormatter(SchemaRegistryClient schemaRegistryClient, Deserializer keyDeserializer) {
        super(schemaRegistryClient, keyDeserializer);
    }

    protected SchemaMessageDeserializer<JsonNode> createDeserializer(SchemaRegistryClient schemaRegistryClient, Deserializer keyDeserializer) {
        return new JsonSchemaMessageDeserializer(schemaRegistryClient, keyDeserializer);
    }

    protected void writeTo(byte[] data, PrintStream output) throws IOException {
        JsonNode object = (JsonNode)this.deserializer.deserialize(data);
        output.print(objectMapper.writeValueAsString((Object)object));
    }

    protected SchemaProvider getProvider() {
        return new JsonSchemaProvider();
    }

    static class JsonSchemaMessageDeserializer
    extends AbstractKafkaJsonSchemaDeserializer<JsonNode>
    implements SchemaMessageDeserializer<JsonNode> {
        protected final Deserializer keyDeserializer;

        JsonSchemaMessageDeserializer(SchemaRegistryClient schemaRegistryClient, Deserializer keyDeserializer) {
            this.schemaRegistry = schemaRegistryClient;
            this.keyDeserializer = keyDeserializer;
            this.validate = true;
        }

        public Deserializer getKeyDeserializer() {
            return this.keyDeserializer;
        }

        public Object deserializeKey(String topic, byte[] payload) {
            return this.keyDeserializer.deserialize(topic, payload);
        }

        @Override
        public JsonNode deserialize(byte[] payload) throws SerializationException {
            return (JsonNode)super.deserialize(payload);
        }
    }
}

