/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.formatter.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.formatter.SchemaMessageDeserializer;
import io.confluent.kafka.formatter.SchemaMessageFormatter;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.json.jackson.Jackson;
import io.confluent.kafka.serializers.json.AbstractKafkaJsonSchemaDeserializer;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class JsonSchemaMessageFormatter
extends SchemaMessageFormatter<JsonNode> {
    private static final ObjectMapper objectMapper = Jackson.newObjectMapper();

    public JsonSchemaMessageFormatter() {
    }

    JsonSchemaMessageFormatter(String url, Deserializer keyDeserializer) {
        super(url, keyDeserializer);
    }

    protected SchemaMessageDeserializer<JsonNode> createDeserializer(Deserializer keyDeserializer) {
        return new JsonSchemaMessageDeserializer(keyDeserializer);
    }

    protected void writeTo(String topic, Headers headers, byte[] data, PrintStream output) throws IOException {
        JsonNode object = (JsonNode)this.deserializer.deserialize(topic, headers, data);
        output.print(objectMapper.writeValueAsString((Object)object));
    }

    protected SchemaProvider getProvider() {
        return new JsonSchemaProvider();
    }

    static class JsonSchemaMessageDeserializer
    extends AbstractKafkaJsonSchemaDeserializer<JsonNode>
    implements SchemaMessageDeserializer<JsonNode> {
        protected final Deserializer keyDeserializer;

        JsonSchemaMessageDeserializer(Deserializer keyDeserializer) {
            this.keyDeserializer = keyDeserializer;
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            if (!configs.containsKey("json.fail.invalid.schema")) {
                configs.put("json.fail.invalid.schema", "true");
            }
            this.configure(this.deserializerConfig(configs), null);
        }

        public Deserializer getKeyDeserializer() {
            return this.keyDeserializer;
        }

        public Object deserializeKey(String topic, Headers headers, byte[] payload) {
            return this.keyDeserializer.deserialize(topic, headers, payload);
        }

        public JsonNode deserialize(String topic, Headers headers, byte[] payload) throws SerializationException {
            return (JsonNode)super.deserialize(false, topic, this.isKey, headers, payload);
        }

        public SchemaRegistryClient getSchemaRegistryClient() {
            return this.schemaRegistry;
        }

        public void close() throws IOException {
            if (this.keyDeserializer != null) {
                this.keyDeserializer.close();
            }
            super.close();
        }
    }
}

