/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.mqtt;

import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;

public interface ProxyServer {
    public void start();

    public void stop();

    public void awaitStop();

    public static class ShutdownHook
    extends Thread {
        private final ProxyServer server;
        private final CountDownLatch startLatch;
        private final Logger log;

        public ShutdownHook(ProxyServer server, CountDownLatch startLatch, Logger log) {
            super("shutdown-thread");
            this.server = server;
            this.startLatch = startLatch;
            this.log = log;
        }

        @Override
        public void run() {
            try {
                this.startLatch.await();
                this.server.stop();
            }
            catch (InterruptedException e) {
                this.log.error("Interrupted in shutdown hook while waiting for {} startup to finish", (Object)"Kafka-MQTT");
            }
        }
    }
}

