/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.mqtt;

import io.confluent.mqtt.TopicMapper;
import io.confluent.mqtt.stream.StreamConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexListTopicMapper
implements TopicMapper {
    private static final Logger log = LoggerFactory.getLogger(RegexListTopicMapper.class);
    private final Map<TopicPartition, Pattern> mapper;

    public RegexListTopicMapper(StreamConfig config) {
        HashMap<TopicPartition, Pattern> mutableMapper = new HashMap<TopicPartition, Pattern>();
        Collection<String> topicRegexes = config.topicRegex();
        log.debug("Creating regex topic mapper for " + topicRegexes + "regular expressions");
        for (String entry : topicRegexes) {
            String[] pair = entry.split(":");
            String kafkaTopic = pair[0];
            String regex = pair[1];
            log.debug("Registering regex '{}' to Kafka topic '{}'", (Object)regex, (Object)kafkaTopic);
            mutableMapper.put(new TopicPartition(kafkaTopic, 0), Pattern.compile(regex));
        }
        this.mapper = Collections.unmodifiableMap(mutableMapper);
    }

    @Override
    public Optional<TopicPartition> map(String mqttTopic) {
        return this.mapper.entrySet().stream().filter(e -> ((Pattern)e.getValue()).matcher(mqttTopic).matches()).peek(e -> log.trace("MQTT topic '{}' maps to Kafka topic '{}' by regex '{}'", new Object[]{mqttTopic, ((TopicPartition)e.getKey()).topic(), e.getValue()})).findFirst().map(Map.Entry::getKey);
    }
}

