/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.mqtt.protocol;

import io.confluent.mqtt.BaseConfig;
import io.confluent.mqtt.protocol.security.ClientAuth;
import io.confluent.mqtt.protocol.security.PrefixedSecurityConfigs;
import io.confluent.mqtt.protocol.security.SecurityProtocol;
import io.confluent.mqtt.util.ConfigUtils;
import java.util.Locale;
import org.apache.kafka.common.config.ConfigDef;

public interface ProtocolConfig
extends BaseConfig {
    public static final String LISTENERS_PREFIX = "listeners.";
    public static final String LISTENERS_SECURITY_PROTOCOL = "listeners.security.protocol";
    public static final String LISTENERS_SECURITY_PROTOCOL_DOC = "Protocol used between MQTT clients and kafka-mqtt.";
    public static final String DEFAULT_LISTENERS_SECURITY_PROTOCOL = SecurityProtocol.PLAINTEXT.name();
    public static final String MQTT_MESSAGE_MAX_BYTES_CONFIG = "mqtt.message.max.bytes";
    public static final String MQTT_MESSAGE_MAX_BYTES_DOC = "Maximum allowed MQTT message size in bytes (excluding the fixed header).";
    public static final int MQTT_MESSAGE_MAX_BYTES_DEFAULT = 8092;
    public static final ConfigUtils.EnumRecommender SECURITY_PROTOCOL_RECOMMENDER = ConfigUtils.EnumRecommender.in(true, SecurityProtocol.values());

    public static ConfigDef mqttMessageMaxBytes(ConfigDef config, BaseConfig.GroupAndOrder group) {
        return config.define(MQTT_MESSAGE_MAX_BYTES_CONFIG, ConfigDef.Type.INT, (Object)8092, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MQTT_MESSAGE_MAX_BYTES_DOC, group.name, ++group.order, ConfigDef.Width.MEDIUM, "Maximum MQTT message size in bytes");
    }

    default public int mqttMessageMaxBytes() {
        return this.getInt(MQTT_MESSAGE_MAX_BYTES_CONFIG);
    }

    public static ConfigDef listenersSecurityProtocol(ConfigDef config, BaseConfig.GroupAndOrder group) {
        return config.define(LISTENERS_SECURITY_PROTOCOL, ConfigDef.Type.STRING, (Object)DEFAULT_LISTENERS_SECURITY_PROTOCOL, (ConfigDef.Validator)SECURITY_PROTOCOL_RECOMMENDER, ConfigDef.Importance.HIGH, LISTENERS_SECURITY_PROTOCOL_DOC, group.name, ++group.order, ConfigDef.Width.MEDIUM, "Listener's security protocol", (ConfigDef.Recommender)SECURITY_PROTOCOL_RECOMMENDER);
    }

    default public SecurityProtocol listenersSecurityProtocol() {
        return SecurityProtocol.valueOf(this.getString(LISTENERS_SECURITY_PROTOCOL).toUpperCase(Locale.ROOT));
    }

    public static ConfigDef prefixedSecurityConfigs(ConfigDef config, BaseConfig.GroupAndOrder group) {
        PrefixedSecurityConfigs.sslConfigDef(LISTENERS_PREFIX, config, group);
        PrefixedSecurityConfigs.sslServerConfigDef(LISTENERS_PREFIX, config, group);
        return config;
    }

    default public ConfigDef assembleProtocolConfig(ConfigDef configDef) {
        return ProtocolConfig.protocolConfig(configDef);
    }

    public static ConfigDef protocolConfig(ConfigDef configDef) {
        BaseConfig.GroupAndOrder group = new BaseConfig.GroupAndOrder("Protocol", 0);
        ConfigDef newConfig = configDef == null ? new ConfigDef() : configDef;
        newConfig = ProtocolConfig.mqttMessageMaxBytes(newConfig, group);
        newConfig = ProtocolConfig.listenersSecurityProtocol(newConfig, group);
        newConfig = ProtocolConfig.prefixedSecurityConfigs(newConfig, group);
        return newConfig;
    }

    default public String listenersSslClientAuthConfig() {
        String clientAuthStr = this.getString("listeners.ssl.client.auth");
        ClientAuth clientAuth = ClientAuth.valueOf(clientAuthStr.toUpperCase(Locale.ROOT));
        return clientAuth.value;
    }
}

