/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.diff;

import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.OneOfElement;
import io.confluent.kafka.schemaregistry.protobuf.diff.Context;
import io.confluent.kafka.schemaregistry.protobuf.diff.Difference;
import io.confluent.kafka.schemaregistry.protobuf.diff.FieldSchemaDiff;
import io.confluent.kafka.schemaregistry.protobuf.diff.OneOfDiff;
import io.confluent.kafka.schemaregistry.protobuf.diff.SchemaDiff;
import java.util.HashMap;
import java.util.HashSet;

public class MessageSchemaDiff {
    static void compare(Context ctx, MessageElement original, MessageElement update) {
        try (Context.SchemaScope schemaScope = ctx.enterSchema(original);){
            if (schemaScope != null) {
                HashMap<Integer, Object> originalByTag = new HashMap<Integer, Object>();
                for (Object field : original.getFields()) {
                    originalByTag.put(field.getTag(), field);
                }
                HashMap<Integer, FieldElement> updateByTag = new HashMap<Integer, FieldElement>();
                for (FieldElement field : update.getFields()) {
                    updateByTag.put(field.getTag(), field);
                }
                HashMap<String, OneOfElement> originalOneOfs = new HashMap<String, OneOfElement>();
                HashMap<String, OneOfElement> updateOneOfs = new HashMap<String, OneOfElement>();
                for (Object oneOf : original.getOneOfs()) {
                    originalOneOfs.put(oneOf.getName(), (OneOfElement)oneOf);
                }
                for (Object oneOf : update.getOneOfs()) {
                    updateOneOfs.put(oneOf.getName(), (OneOfElement)oneOf);
                }
                for (Object oneOf : update.getOneOfs()) {
                    Context.PathScope pathScope = ctx.enterPath(oneOf.getName());
                    Throwable throwable = null;
                    try {
                        int numMatchingOriginal = 0;
                        for (FieldElement oneOfField : oneOf.getFields()) {
                            FieldElement originalField = (FieldElement)originalByTag.remove(oneOfField.getTag());
                            if (originalField == null) continue;
                            ++numMatchingOriginal;
                        }
                        if (numMatchingOriginal <= true) continue;
                        ctx.addDifference(Difference.Type.MULTIPLE_FIELDS_MOVED_TO_ONEOF);
                    }
                    catch (Throwable numMatchingOriginal) {
                        throwable = numMatchingOriginal;
                        throw numMatchingOriginal;
                    }
                    finally {
                        if (pathScope == null) continue;
                        if (throwable != null) {
                            try {
                                pathScope.close();
                            }
                            catch (Throwable numMatchingOriginal) {
                                throwable.addSuppressed(numMatchingOriginal);
                            }
                            continue;
                        }
                        pathScope.close();
                    }
                }
                HashSet allOneOfs = new HashSet(originalOneOfs.keySet());
                allOneOfs.addAll(updateOneOfs.keySet());
                for (String oneOfName : allOneOfs) {
                    Context.PathScope pathScope = ctx.enterPath(oneOfName);
                    Throwable numMatchingOriginal = null;
                    try {
                        OneOfElement originalOneOf = (OneOfElement)originalOneOfs.get(oneOfName);
                        OneOfElement updateOneOf = (OneOfElement)updateOneOfs.get(oneOfName);
                        if (updateOneOf == null) {
                            ctx.addDifference(Difference.Type.ONEOF_REMOVED);
                            continue;
                        }
                        if (originalOneOf == null) {
                            ctx.addDifference(Difference.Type.ONEOF_ADDED);
                            continue;
                        }
                        OneOfDiff.compare(ctx, originalOneOf, updateOneOf);
                    }
                    catch (Throwable throwable) {
                        numMatchingOriginal = throwable;
                        throw throwable;
                    }
                    finally {
                        if (pathScope == null) continue;
                        if (numMatchingOriginal != null) {
                            try {
                                pathScope.close();
                            }
                            catch (Throwable throwable) {
                                numMatchingOriginal.addSuppressed(throwable);
                            }
                            continue;
                        }
                        pathScope.close();
                    }
                }
                HashSet allTags = new HashSet(originalByTag.keySet());
                allTags.addAll(updateByTag.keySet());
                for (Integer tag : allTags) {
                    Context.PathScope pathScope = ctx.enterPath(tag.toString());
                    Object object = null;
                    try {
                        FieldElement originalField = (FieldElement)originalByTag.get(tag);
                        FieldElement updateField = (FieldElement)updateByTag.get(tag);
                        if (updateField == null) {
                            if (originalField.getLabel() == Field.Label.REQUIRED) {
                                ctx.addDifference(Difference.Type.REQUIRED_FIELD_REMOVED);
                                continue;
                            }
                            ctx.addDifference(Difference.Type.FIELD_REMOVED);
                            continue;
                        }
                        if (originalField == null) {
                            if (updateField.getLabel() == Field.Label.REQUIRED) {
                                ctx.addDifference(Difference.Type.REQUIRED_FIELD_ADDED);
                                continue;
                            }
                            ctx.addDifference(Difference.Type.FIELD_ADDED);
                            continue;
                        }
                        FieldSchemaDiff.compare(ctx, originalField, updateField);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (pathScope == null) continue;
                        if (object != null) {
                            try {
                                pathScope.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            continue;
                        }
                        pathScope.close();
                    }
                }
            }
            SchemaDiff.compareTypeElements(ctx, original.getNestedTypes(), update.getNestedTypes());
        }
    }
}

