/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeGetResponse;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.client.security.SslFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import org.apache.avro.Schema;

public class CachedSchemaRegistryClient
implements SchemaRegistryClient {
    private final RestService restService;
    private final int identityMapCapacity;
    private final Map<String, Map<org.apache.avro.Schema, Integer>> schemaCache;
    private final Map<String, Map<Integer, org.apache.avro.Schema>> idCache;
    private final Map<String, Map<org.apache.avro.Schema, Integer>> versionCache;
    public static final Map<String, String> DEFAULT_REQUEST_PROPERTIES = Collections.singletonMap("Content-Type", "application/vnd.schemaregistry.v1+json");

    public CachedSchemaRegistryClient(String baseUrl, int identityMapCapacity) {
        this(new RestService(baseUrl), identityMapCapacity);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int identityMapCapacity) {
        this(new RestService(baseUrls), identityMapCapacity);
    }

    public CachedSchemaRegistryClient(RestService restService, int identityMapCapacity) {
        this(restService, identityMapCapacity, null);
    }

    public CachedSchemaRegistryClient(String baseUrl, int identityMapCapacity, Map<String, ?> originals) {
        this(baseUrl, identityMapCapacity, originals, null);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int identityMapCapacity, Map<String, ?> originals) {
        this(baseUrls, identityMapCapacity, originals, null);
    }

    public CachedSchemaRegistryClient(RestService restService, int identityMapCapacity, Map<String, ?> configs) {
        this(restService, identityMapCapacity, configs, null);
    }

    public CachedSchemaRegistryClient(String baseUrl, int identityMapCapacity, Map<String, ?> originals, Map<String, String> httpHeaders) {
        this(new RestService(baseUrl), identityMapCapacity, originals, httpHeaders);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int identityMapCapacity, Map<String, ?> originals, Map<String, String> httpHeaders) {
        this(new RestService(baseUrls), identityMapCapacity, originals, httpHeaders);
    }

    public CachedSchemaRegistryClient(RestService restService, int identityMapCapacity, Map<String, ?> configs, Map<String, String> httpHeaders) {
        this.identityMapCapacity = identityMapCapacity;
        this.schemaCache = new HashMap<String, Map<org.apache.avro.Schema, Integer>>();
        this.idCache = new HashMap<String, Map<Integer, org.apache.avro.Schema>>();
        this.versionCache = new HashMap<String, Map<org.apache.avro.Schema, Integer>>();
        this.restService = restService;
        this.idCache.put(null, new HashMap());
        if (httpHeaders != null) {
            restService.setHttpHeaders(httpHeaders);
        }
        if (configs != null && !configs.isEmpty()) {
            Map<String, Object> restConfigs = configs.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).startsWith("schema.registry.") ? ((String)e.getKey()).substring("schema.registry.".length()) : (String)e.getKey(), Map.Entry::getValue, (existing, replacement) -> replacement));
            restService.configure(restConfigs);
            Map<String, Object> sslConfigs = configs.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("schema.registry.")).collect(Collectors.toMap(e -> ((String)e.getKey()).substring("schema.registry.".length()), Map.Entry::getValue));
            SslFactory sslFactory = new SslFactory(sslConfigs);
            if (sslFactory != null && sslFactory.sslContext() != null) {
                restService.setSslSocketFactory(sslFactory.sslContext().getSocketFactory());
                restService.setHostnameVerifier(this.getHostnameVerifier(sslConfigs));
            }
        }
    }

    private HostnameVerifier getHostnameVerifier(Map<String, Object> config) {
        String sslEndpointIdentificationAlgo = (String)config.get("ssl.endpoint.identification.algorithm");
        if (sslEndpointIdentificationAlgo == null || sslEndpointIdentificationAlgo.equals("none") || sslEndpointIdentificationAlgo.isEmpty()) {
            return (hostname, session) -> true;
        }
        return null;
    }

    private int registerAndGetId(String subject, org.apache.avro.Schema schema) throws IOException, RestClientException {
        return this.restService.registerSchema(schema.toString(), subject);
    }

    private int registerAndGetId(String subject, org.apache.avro.Schema schema, int version, int id) throws IOException, RestClientException {
        return this.restService.registerSchema(schema.toString(), subject, version, id);
    }

    private org.apache.avro.Schema getSchemaByIdFromRegistry(int id) throws IOException, RestClientException {
        SchemaString restSchema = this.restService.getId(id);
        Schema.Parser parser = new Schema.Parser();
        parser.setValidateDefaults(false);
        return parser.parse(restSchema.getSchemaString());
    }

    private int getVersionFromRegistry(String subject, org.apache.avro.Schema schema) throws IOException, RestClientException {
        Schema response = this.restService.lookUpSubjectVersion(schema.toString(), subject, true);
        return response.getVersion();
    }

    private int getIdFromRegistry(String subject, org.apache.avro.Schema schema) throws IOException, RestClientException {
        Schema response = this.restService.lookUpSubjectVersion(schema.toString(), subject, false);
        return response.getId();
    }

    @Override
    public synchronized int register(String subject, org.apache.avro.Schema schema) throws IOException, RestClientException {
        return this.register(subject, schema, 0, -1);
    }

    @Override
    public synchronized int register(String subject, org.apache.avro.Schema schema, int version, int id) throws IOException, RestClientException {
        Map schemaIdMap = this.schemaCache.computeIfAbsent(subject, k -> new HashMap());
        Integer cachedId = (Integer)schemaIdMap.get(schema);
        if (cachedId != null) {
            if (id >= 0 && id != cachedId) {
                throw new IllegalStateException("Schema already registered with id " + cachedId + " instead of input id " + id);
            }
            return cachedId;
        }
        if (schemaIdMap.size() >= this.identityMapCapacity) {
            throw new IllegalStateException("Too many schema objects created for " + subject + "!");
        }
        int retrievedId = id >= 0 ? this.registerAndGetId(subject, schema, version, id) : this.registerAndGetId(subject, schema);
        schemaIdMap.put(schema, retrievedId);
        this.idCache.get(null).put(retrievedId, schema);
        return retrievedId;
    }

    @Override
    public org.apache.avro.Schema getByID(int id) throws IOException, RestClientException {
        return this.getById(id);
    }

    @Override
    public synchronized org.apache.avro.Schema getById(int id) throws IOException, RestClientException {
        return this.getBySubjectAndId(null, id);
    }

    @Override
    public org.apache.avro.Schema getBySubjectAndID(String subject, int id) throws IOException, RestClientException {
        return this.getBySubjectAndId(subject, id);
    }

    @Override
    public synchronized org.apache.avro.Schema getBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        Map idSchemaMap = this.idCache.computeIfAbsent(subject, k -> new HashMap());
        org.apache.avro.Schema cachedSchema = (org.apache.avro.Schema)idSchemaMap.get(id);
        if (cachedSchema != null) {
            return cachedSchema;
        }
        org.apache.avro.Schema retrievedSchema = this.getSchemaByIdFromRegistry(id);
        idSchemaMap.put(id, retrievedSchema);
        return retrievedSchema;
    }

    @Override
    public Collection<String> getAllSubjectsById(int id) throws IOException, RestClientException {
        return this.restService.getAllSubjectsById(id);
    }

    @Override
    public SchemaMetadata getSchemaMetadata(String subject, int version) throws IOException, RestClientException {
        Schema response = this.restService.getVersion(subject, version);
        int id = response.getId();
        String schema = response.getSchema();
        return new SchemaMetadata(id, version, schema);
    }

    @Override
    public synchronized SchemaMetadata getLatestSchemaMetadata(String subject) throws IOException, RestClientException {
        Schema response = this.restService.getLatestVersion(subject);
        int id = response.getId();
        int version = response.getVersion();
        String schema = response.getSchema();
        return new SchemaMetadata(id, version, schema);
    }

    @Override
    public synchronized int getVersion(String subject, org.apache.avro.Schema schema) throws IOException, RestClientException {
        Map schemaVersionMap = this.versionCache.computeIfAbsent(subject, k -> new HashMap());
        Integer cachedVersion = (Integer)schemaVersionMap.get(schema);
        if (cachedVersion != null) {
            return cachedVersion;
        }
        if (schemaVersionMap.size() >= this.identityMapCapacity) {
            throw new IllegalStateException("Too many schema objects created for " + subject + "!");
        }
        int retrievedVersion = this.getVersionFromRegistry(subject, schema);
        schemaVersionMap.put(schema, retrievedVersion);
        return retrievedVersion;
    }

    @Override
    public List<Integer> getAllVersions(String subject) throws IOException, RestClientException {
        return this.restService.getAllVersions(subject);
    }

    @Override
    public synchronized int getId(String subject, org.apache.avro.Schema schema) throws IOException, RestClientException {
        Map schemaIdMap = this.schemaCache.computeIfAbsent(subject, k -> new HashMap());
        Integer cachedId = (Integer)schemaIdMap.get(schema);
        if (cachedId != null) {
            return cachedId;
        }
        if (schemaIdMap.size() >= this.identityMapCapacity) {
            throw new IllegalStateException("Too many schema objects created for " + subject + "!");
        }
        int retrievedId = this.getIdFromRegistry(subject, schema);
        schemaIdMap.put(schema, retrievedId);
        this.idCache.get(null).put(retrievedId, schema);
        return retrievedId;
    }

    @Override
    public List<Integer> deleteSubject(String subject) throws IOException, RestClientException {
        return this.deleteSubject(DEFAULT_REQUEST_PROPERTIES, subject);
    }

    @Override
    public synchronized List<Integer> deleteSubject(Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        Objects.requireNonNull(subject, "subject");
        this.versionCache.remove(subject);
        this.idCache.remove(subject);
        this.schemaCache.remove(subject);
        return this.restService.deleteSubject(requestProperties, subject);
    }

    @Override
    public Integer deleteSchemaVersion(String subject, String version) throws IOException, RestClientException {
        return this.deleteSchemaVersion(DEFAULT_REQUEST_PROPERTIES, subject, version);
    }

    @Override
    public synchronized Integer deleteSchemaVersion(Map<String, String> requestProperties, String subject, String version) throws IOException, RestClientException {
        this.versionCache.getOrDefault(subject, Collections.emptyMap()).values().remove(Integer.valueOf(version));
        return this.restService.deleteSchemaVersion(requestProperties, subject, version);
    }

    @Override
    public boolean testCompatibility(String subject, org.apache.avro.Schema schema) throws IOException, RestClientException {
        return this.restService.testCompatibility(schema.toString(), subject, "latest");
    }

    @Override
    public String updateCompatibility(String subject, String compatibility) throws IOException, RestClientException {
        ConfigUpdateRequest response = this.restService.updateCompatibility(compatibility, subject);
        return response.getCompatibilityLevel();
    }

    @Override
    public String getCompatibility(String subject) throws IOException, RestClientException {
        Config response = this.restService.getConfig(subject);
        return response.getCompatibilityLevel();
    }

    @Override
    public String setMode(String mode) throws IOException, RestClientException {
        ModeUpdateRequest response = this.restService.setMode(mode);
        return response.getMode();
    }

    @Override
    public String setMode(String mode, String subject) throws IOException, RestClientException {
        ModeUpdateRequest response = this.restService.setMode(mode, subject);
        return response.getMode();
    }

    @Override
    public String getMode() throws IOException, RestClientException {
        ModeGetResponse response = this.restService.getMode();
        return response.getMode();
    }

    @Override
    public String getMode(String subject) throws IOException, RestClientException {
        ModeGetResponse response = this.restService.getMode(subject);
        return response.getMode();
    }

    @Override
    public Collection<String> getAllSubjects() throws IOException, RestClientException {
        return this.restService.getAllSubjects();
    }

    @Override
    public synchronized void reset() {
        this.schemaCache.clear();
        this.idCache.clear();
        this.versionCache.clear();
        this.idCache.put(null, new HashMap());
    }
}

