/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.testutil;

import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MockSchemaRegistry {
    private static final Map<String, SchemaRegistryClient> SCOPED_CLIENTS = new HashMap<String, SchemaRegistryClient>();

    private MockSchemaRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchemaRegistryClient getClientForScope(String scope) {
        Map<String, SchemaRegistryClient> map = SCOPED_CLIENTS;
        synchronized (map) {
            if (!SCOPED_CLIENTS.containsKey(scope)) {
                SCOPED_CLIENTS.put(scope, new MockSchemaRegistryClient());
            }
        }
        return SCOPED_CLIENTS.get(scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchemaRegistryClient getClientForScope(String scope, List<SchemaProvider> providers) {
        Map<String, SchemaRegistryClient> map = SCOPED_CLIENTS;
        synchronized (map) {
            if (!SCOPED_CLIENTS.containsKey(scope)) {
                SCOPED_CLIENTS.put(scope, new MockSchemaRegistryClient(providers));
            }
        }
        return SCOPED_CLIENTS.get(scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropScope(String scope) {
        Map<String, SchemaRegistryClient> map = SCOPED_CLIENTS;
        synchronized (map) {
            SCOPED_CLIENTS.remove(scope);
        }
    }
}

