/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaValidationStrategy;
import io.confluent.kafka.schemaregistry.SchemaValidator;
import java.util.Iterator;

public final class SchemaValidatorBuilder {
    private SchemaValidationStrategy strategy;

    public SchemaValidatorBuilder canReadStrategy() {
        this.strategy = (toValidate, existing) -> toValidate.isBackwardCompatible(existing);
        return this;
    }

    public SchemaValidatorBuilder canBeReadStrategy() {
        this.strategy = (toValidate, existing) -> existing.isBackwardCompatible(toValidate);
        return this;
    }

    public SchemaValidatorBuilder mutualReadStrategy() {
        this.strategy = (toValidate, existing) -> existing.isBackwardCompatible(toValidate) && toValidate.isBackwardCompatible(existing);
        return this;
    }

    public SchemaValidator validateLatest() {
        this.valid();
        return (toValidate, schemasInOrder) -> {
            Iterator schemas = schemasInOrder.iterator();
            if (schemas.hasNext()) {
                ParsedSchema existing = (ParsedSchema)schemas.next();
                return this.strategy.validate(toValidate, existing);
            }
            return true;
        };
    }

    public SchemaValidator validateAll() {
        this.valid();
        return (toValidate, schemasInOrder) -> {
            for (ParsedSchema existing : schemasInOrder) {
                if (this.strategy.validate(toValidate, existing)) continue;
                return false;
            }
            return true;
        };
    }

    private void valid() {
        if (null == this.strategy) {
            throw new RuntimeException("SchemaValidationStrategy not specified in builder");
        }
    }
}

