/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.avro;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.apache.avro.Schemas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchema
implements ParsedSchema {
    private static final Logger log = LoggerFactory.getLogger(AvroSchema.class);
    public static final String TYPE = "AVRO";
    private final Schema schemaObj;
    private String canonicalString;
    private final Integer version;
    private final List<SchemaReference> references;
    private final Map<String, String> resolvedReferences;

    public AvroSchema(String schemaString) {
        this(schemaString, Collections.emptyList(), Collections.emptyMap(), null);
    }

    public AvroSchema(String schemaString, List<SchemaReference> references, Map<String, String> resolvedReferences, Integer version) {
        Schema.Parser parser = this.getParser();
        for (String schema : resolvedReferences.values()) {
            parser.parse(schema);
        }
        this.schemaObj = parser.parse(schemaString);
        this.references = Collections.unmodifiableList(references);
        this.resolvedReferences = Collections.unmodifiableMap(resolvedReferences);
        this.version = version;
    }

    public AvroSchema(Schema schemaObj) {
        this(schemaObj, null);
    }

    public AvroSchema(Schema schemaObj, Integer version) {
        this.schemaObj = schemaObj;
        this.references = Collections.emptyList();
        this.resolvedReferences = Collections.emptyMap();
        this.version = version;
    }

    private AvroSchema(Schema schemaObj, String canonicalString, List<SchemaReference> references, Map<String, String> resolvedReferences, Integer version) {
        this.schemaObj = schemaObj;
        this.canonicalString = canonicalString;
        this.references = references;
        this.resolvedReferences = resolvedReferences;
        this.version = version;
    }

    public AvroSchema copy() {
        return new AvroSchema(this.schemaObj, this.canonicalString, this.references, this.resolvedReferences, this.version);
    }

    protected Schema.Parser getParser() {
        Schema.Parser parser = new Schema.Parser();
        parser.setValidateDefaults(false);
        return parser;
    }

    public Schema rawSchema() {
        return this.schemaObj;
    }

    @Override
    public String schemaType() {
        return TYPE;
    }

    @Override
    public String name() {
        if (this.schemaObj != null && this.schemaObj.getType() == Schema.Type.RECORD) {
            return this.schemaObj.getFullName();
        }
        return null;
    }

    @Override
    public String canonicalString() {
        if (this.schemaObj == null) {
            return null;
        }
        if (this.canonicalString == null) {
            Schema.Parser parser = this.getParser();
            ArrayList<Schema> schemaRefs = new ArrayList<Schema>();
            for (String schema : this.resolvedReferences.values()) {
                Schema schemaRef = parser.parse(schema);
                schemaRefs.add(schemaRef);
            }
            this.canonicalString = Schemas.toString(this.schemaObj, schemaRefs);
        }
        return this.canonicalString;
    }

    public Integer version() {
        return this.version;
    }

    @Override
    public List<SchemaReference> references() {
        return this.references;
    }

    public Map<String, String> resolvedReferences() {
        return this.resolvedReferences;
    }

    @Override
    public boolean isBackwardCompatible(ParsedSchema previousSchema) {
        if (!this.schemaType().equals(previousSchema.schemaType())) {
            return false;
        }
        try {
            SchemaCompatibility.SchemaPairCompatibility result = SchemaCompatibility.checkReaderWriterCompatibility((Schema)this.schemaObj, (Schema)((AvroSchema)previousSchema).schemaObj);
            return result.getResult().getCompatibility() == SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE;
        }
        catch (Exception e) {
            log.error("Unexpected exception during compatibility check", (Throwable)e);
            return false;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvroSchema that = (AvroSchema)o;
        return Objects.equals(this.schemaObj, that.schemaObj) && this.metaEqual(this.schemaObj, that.schemaObj) && Objects.equals(this.references, that.references) && Objects.equals(this.version, that.version);
    }

    private boolean metaEqual(Schema schema1, Schema schema2) {
        Schema.Type type2;
        if (schema1 == null) {
            return schema2 == null;
        }
        Schema.Type type1 = schema1.getType();
        if (type1 != (type2 = schema2.getType())) {
            return false;
        }
        switch (type1) {
            case RECORD: {
                return Objects.equals(schema1.getAliases(), schema2.getAliases()) && Objects.equals(schema1.getDoc(), schema2.getDoc()) && this.fieldMetaEqual(schema1.getFields(), schema2.getFields());
            }
            case ENUM: 
            case FIXED: {
                return Objects.equals(schema1.getAliases(), schema2.getAliases()) && Objects.equals(schema1.getDoc(), schema2.getDoc());
            }
        }
        return true;
    }

    private boolean fieldMetaEqual(List<Schema.Field> fields1, List<Schema.Field> fields2) {
        if (fields1.size() != fields2.size()) {
            return false;
        }
        for (int i = 0; i < fields1.size(); ++i) {
            Schema.Field field1 = fields1.get(i);
            Schema.Field field2 = fields2.get(i);
            if (!Objects.equals(field1.aliases(), field2.aliases()) || !Objects.equals(field1.doc(), field2.doc())) {
                return false;
            }
            boolean fieldSchemaMetaEqual = this.metaEqual(field1.schema(), field2.schema());
            if (fieldSchemaMetaEqual) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.schemaObj, this.references, this.version);
    }

    public String toString() {
        return this.canonicalString();
    }
}

