/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import com.google.common.collect.Lists;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.ParsedSchemaHolder;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.SimpleParsedSchemaHolder;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockSchemaRegistryClient
implements SchemaRegistryClient {
    private static final Logger log = LoggerFactory.getLogger(MockSchemaRegistryClient.class);
    private static final String WILDCARD = "*";
    private Config defaultConfig = new Config("BACKWARD");
    private final Map<String, Map<ParsedSchema, Integer>> schemaToIdCache = new ConcurrentHashMap<String, Map<ParsedSchema, Integer>>();
    private final Map<String, Map<ParsedSchema, Integer>> registeredSchemaCache = new ConcurrentHashMap<String, Map<ParsedSchema, Integer>>();
    private final Map<String, Map<Integer, ParsedSchema>> idToSchemaCache = new ConcurrentHashMap<String, Map<Integer, ParsedSchema>>();
    private final Map<String, Map<ParsedSchema, Integer>> schemaToVersionCache = new ConcurrentHashMap<String, Map<ParsedSchema, Integer>>();
    private final Map<String, Config> configCache = new ConcurrentHashMap<String, Config>();
    private final Map<String, String> modes = new ConcurrentHashMap<String, String>();
    private final Map<String, AtomicInteger> ids = new ConcurrentHashMap<String, AtomicInteger>();
    private final Map<String, SchemaProvider> providers;
    private static final String NO_SUBJECT = "";

    public MockSchemaRegistryClient() {
        this(null);
    }

    public MockSchemaRegistryClient(List<SchemaProvider> providers) {
        this.providers = providers != null && !providers.isEmpty() ? providers.stream().collect(Collectors.toMap(SchemaProvider::schemaType, p -> p)) : Collections.singletonMap("AVRO", new AvroSchemaProvider());
        HashMap<String, MockSchemaRegistryClient> schemaProviderConfigs = new HashMap<String, MockSchemaRegistryClient>();
        schemaProviderConfigs.put("schemaVersionFetcher", this);
        for (SchemaProvider provider : this.providers.values()) {
            provider.configure(schemaProviderConfigs);
        }
    }

    @Override
    public Optional<ParsedSchema> parseSchema(String schemaType, String schemaString, List<SchemaReference> references) {
        SchemaProvider schemaProvider;
        if (schemaType == null) {
            schemaType = "AVRO";
        }
        if ((schemaProvider = this.providers.get(schemaType)) == null) {
            log.error("No provider found for schema type {}", (Object)schemaType);
            return Optional.empty();
        }
        return schemaProvider.parseSchema(schemaString, references);
    }

    @Override
    public Optional<ParsedSchema> parseSchema(Schema schema) {
        SchemaProvider schemaProvider;
        String schemaType = schema.getSchemaType();
        if (schemaType == null) {
            schemaType = "AVRO";
        }
        if ((schemaProvider = this.providers.get(schemaType)) == null) {
            log.error("Invalid schema type {}", (Object)schemaType);
            return Optional.empty();
        }
        return schemaProvider.parseSchema(schema, false, false);
    }

    private int getIdFromRegistry(String subject, ParsedSchema schema, boolean registerRequest, int id) throws RestClientException {
        Map idSchemaMap = this.idToSchemaCache.computeIfAbsent(subject, k -> new ConcurrentHashMap());
        if (!idSchemaMap.isEmpty()) {
            for (Map.Entry entry : idSchemaMap.entrySet()) {
                if (!this.schemasEqual((ParsedSchema)entry.getValue(), schema)) continue;
                if (registerRequest) {
                    if (id >= 0 && id != (Integer)entry.getKey()) continue;
                    this.generateVersion(subject, schema);
                }
                return (Integer)entry.getKey();
            }
        } else if (!registerRequest) {
            throw new RestClientException("Subject Not Found", 404, 40401);
        }
        if (registerRequest) {
            int schemaId;
            String context = MockSchemaRegistryClient.toQualifiedContext(subject);
            Map schemaIdMap = this.registeredSchemaCache.computeIfAbsent(context, k -> new ConcurrentHashMap());
            if (id >= 0) {
                schemaId = id;
                schemaIdMap.put(schema, schemaId);
            } else {
                schemaId = schemaIdMap.computeIfAbsent(schema, k -> this.ids.computeIfAbsent(context, c -> new AtomicInteger(0)).incrementAndGet());
            }
            this.generateVersion(subject, schema);
            idSchemaMap.put(schemaId, schema);
            return schemaId;
        }
        throw new RestClientException("Schema Not Found", 404, 40403);
    }

    private boolean schemasEqual(ParsedSchema schema1, ParsedSchema schema2) {
        return schema1.canonicalString().equals(schema2.canonicalString()) || schema1.deepEquals(schema2);
    }

    private void generateVersion(String subject, ParsedSchema schema) {
        List<Integer> versions = this.allVersions(subject);
        int currentVersion = versions.isEmpty() ? 1 : versions.get(versions.size() - 1) + 1;
        Map schemaVersionMap = this.schemaToVersionCache.computeIfAbsent(subject, k -> new ConcurrentHashMap());
        schemaVersionMap.put(schema, currentVersion);
    }

    private ParsedSchema getSchemaBySubjectAndIdFromRegistry(String subject, int id) throws RestClientException {
        ParsedSchema schema;
        ParsedSchema schema2;
        Map<Integer, ParsedSchema> idSchemaMap = this.idToSchemaCache.get(subject);
        if (idSchemaMap != null && (schema2 = idSchemaMap.get(id)) != null) {
            return schema2;
        }
        String context = MockSchemaRegistryClient.toQualifiedContext(subject);
        if (!context.equals(subject) && (idSchemaMap = this.idToSchemaCache.get(context)) != null && (schema = idSchemaMap.get(id)) != null) {
            return schema;
        }
        throw new RestClientException("Subject Not Found", 404, 40401);
    }

    @Override
    public int register(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.register(subject, schema, 0, -1);
    }

    @Override
    public int register(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        return this.registerWithResponse(subject, schema, 0, -1, normalize).getId();
    }

    @Override
    public int register(String subject, ParsedSchema schema, int version, int id) throws IOException, RestClientException {
        return this.registerWithResponse(subject, schema, version, id, false).getId();
    }

    @Override
    public RegisterSchemaResponse registerWithResponse(String subject, ParsedSchema schema, boolean normalize) throws RestClientException {
        return this.registerWithResponse(subject, schema, 0, -1, normalize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegisterSchemaResponse registerWithResponse(String subject, ParsedSchema schema, int version, int id, boolean normalize) throws RestClientException {
        Map schemaIdMap;
        Integer schemaId;
        if (normalize) {
            schema = schema.normalize();
        }
        if ((schemaId = (Integer)(schemaIdMap = this.schemaToIdCache.computeIfAbsent(subject, k -> new ConcurrentHashMap())).get(schema)) != null && (id < 0 || id == schemaId)) {
            return new RegisterSchemaResponse(schemaId);
        }
        MockSchemaRegistryClient mockSchemaRegistryClient = this;
        synchronized (mockSchemaRegistryClient) {
            schemaId = (Integer)schemaIdMap.get(schema);
            if (schemaId != null && (id < 0 || id == schemaId)) {
                return new RegisterSchemaResponse(schemaId);
            }
            int retrievedId = this.getIdFromRegistry(subject, schema, true, id);
            schemaIdMap.put(schema, retrievedId);
            String context = MockSchemaRegistryClient.toQualifiedContext(subject);
            Map idSchemaMap = this.idToSchemaCache.computeIfAbsent(context, k -> new ConcurrentHashMap());
            idSchemaMap.put(retrievedId, schema);
            return new RegisterSchemaResponse(retrievedId);
        }
    }

    @Override
    public ParsedSchema getSchemaById(int id) throws IOException, RestClientException {
        return this.getSchemaBySubjectAndId(NO_SUBJECT, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParsedSchema getSchemaBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        Map idSchemaMap;
        ParsedSchema schema;
        if (subject == null) {
            subject = NO_SUBJECT;
        }
        if ((schema = (ParsedSchema)(idSchemaMap = this.idToSchemaCache.computeIfAbsent(subject, k -> new ConcurrentHashMap())).get(id)) != null) {
            return schema;
        }
        MockSchemaRegistryClient mockSchemaRegistryClient = this;
        synchronized (mockSchemaRegistryClient) {
            schema = (ParsedSchema)idSchemaMap.get(id);
            if (schema != null) {
                return schema;
            }
            ParsedSchema retrievedSchema = this.getSchemaBySubjectAndIdFromRegistry(subject, id);
            idSchemaMap.put(id, retrievedSchema);
            return retrievedSchema;
        }
    }

    private Stream<ParsedSchema> getSchemasForSubject(String subject, boolean latestOnly) {
        try {
            List<Integer> versions = this.getAllVersions(subject);
            if (latestOnly) {
                int length = versions.size();
                versions = versions.subList(length - 1, length);
            }
            LinkedList<SchemaMetadata> schemaMetadata = new LinkedList<SchemaMetadata>();
            for (Integer version : versions) {
                schemaMetadata.add(this.getSchemaMetadata(subject, version));
            }
            LinkedList<ParsedSchema> schemas = new LinkedList<ParsedSchema>();
            for (SchemaMetadata metadata : schemaMetadata) {
                schemas.add(this.getSchemaBySubjectAndId(subject, metadata.getId()));
            }
            return schemas.stream();
        }
        catch (RestClientException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ParsedSchema> getSchemas(String subjectPrefix, boolean lookupDeletedSchema, boolean latestOnly) throws IOException, RestClientException {
        Stream<String> validSubjects = this.getAllSubjects().stream().filter(subject -> subject.startsWith(subjectPrefix));
        return validSubjects.flatMap(subject -> this.getSchemasForSubject((String)subject, latestOnly)).collect(Collectors.toList());
    }

    @Override
    public Collection<String> getAllSubjectsById(int id) {
        return this.idToSchemaCache.entrySet().stream().filter(entry -> ((Map)entry.getValue()).containsKey(id)).map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Collection<SubjectVersion> getAllVersionsById(int id) {
        return this.idToSchemaCache.entrySet().stream().filter(entry -> ((Map)entry.getValue()).containsKey(id)).flatMap(e -> {
            ParsedSchema schema = (ParsedSchema)((Map)e.getValue()).get(id);
            Map<ParsedSchema, Integer> schemaVersionMap = this.schemaToVersionCache.get(e.getKey());
            if (schemaVersionMap != null) {
                int version = schemaVersionMap.get(schema);
                return Stream.of(new SubjectVersion((String)e.getKey(), version));
            }
            return Stream.empty();
        }).distinct().collect(Collectors.toList());
    }

    private int getLatestVersion(String subject) throws IOException, RestClientException {
        List<Integer> versions = this.getAllVersions(subject);
        if (versions.isEmpty()) {
            throw new IOException("No schema registered under subject!");
        }
        return versions.get(versions.size() - 1);
    }

    @Override
    public Schema getByVersion(String subject, int version, boolean lookupDeletedSchema) {
        ParsedSchema schema = null;
        Map<ParsedSchema, Integer> schemaVersionMap = this.schemaToVersionCache.get(subject);
        if (schemaVersionMap == null) {
            throw new RuntimeException(new RestClientException("Subject Not Found", 404, 40401));
        }
        int maxVersion = -1;
        for (Map.Entry<ParsedSchema, Integer> entry : schemaVersionMap.entrySet()) {
            if (version == -1) {
                if (entry.getValue() <= maxVersion) continue;
                schema = entry.getKey();
                maxVersion = entry.getValue();
                continue;
            }
            if (entry.getValue() != version) continue;
            schema = entry.getKey();
        }
        if (schema == null) {
            throw new RuntimeException(new RestClientException("Subject Not Found", 404, 40401));
        }
        if (maxVersion != -1) {
            version = maxVersion;
        }
        int id = -1;
        Map<Integer, ParsedSchema> idSchemaMap = this.idToSchemaCache.get(subject);
        for (Map.Entry<Integer, ParsedSchema> entry : idSchemaMap.entrySet()) {
            if (!this.schemasEqual(entry.getValue(), schema)) continue;
            id = entry.getKey();
        }
        return new Schema(subject, (Integer)version, (Integer)id, schema);
    }

    @Override
    public SchemaMetadata getSchemaMetadata(String subject, int version) throws IOException, RestClientException {
        return this.getSchemaMetadata(subject, version, false);
    }

    @Override
    public SchemaMetadata getSchemaMetadata(String subject, int version, boolean lookupDeletedSchema) throws RestClientException {
        ParsedSchema schema = null;
        Map<ParsedSchema, Integer> schemaVersionMap = this.schemaToVersionCache.get(subject);
        if (schemaVersionMap == null) {
            throw new RestClientException("Subject Not Found", 404, 40401);
        }
        for (Map.Entry<ParsedSchema, Integer> entry : schemaVersionMap.entrySet()) {
            if (entry.getValue() != version) continue;
            schema = entry.getKey();
        }
        if (schema == null) {
            throw new RestClientException("Subject Not Found", 404, 40401);
        }
        int id = -1;
        Map<Integer, ParsedSchema> idSchemaMap = this.idToSchemaCache.get(subject);
        for (Map.Entry<Integer, ParsedSchema> entry : idSchemaMap.entrySet()) {
            if (!this.schemasEqual(entry.getValue(), schema)) continue;
            id = entry.getKey();
        }
        return new SchemaMetadata(new Schema(subject, (Integer)version, (Integer)id, schema));
    }

    @Override
    public SchemaMetadata getLatestSchemaMetadata(String subject) throws IOException, RestClientException {
        int version = this.getLatestVersion(subject);
        return this.getSchemaMetadata(subject, version);
    }

    @Override
    public SchemaMetadata getLatestWithMetadata(String subject, Map<String, String> metadata, boolean lookupDeletedSchema) throws IOException, RestClientException {
        Map<ParsedSchema, Integer> versions = this.schemaToVersionCache.get(subject);
        TreeMap reverseMap = new TreeMap(Collections.reverseOrder());
        for (Map.Entry<ParsedSchema, Integer> entry : versions.entrySet()) {
            reverseMap.put(entry.getValue(), entry.getKey());
        }
        for (Map.Entry<ParsedSchema, Integer> entry : reverseMap.entrySet()) {
            SortedMap<String, String> props;
            Integer version = (Integer)((Object)entry.getKey());
            ParsedSchema schema = (ParsedSchema)((Object)entry.getValue());
            Metadata schemaMetadata = schema.metadata();
            if (schemaMetadata == null || (props = schemaMetadata.getProperties()) == null || !props.entrySet().containsAll(metadata.entrySet())) continue;
            int id = -1;
            Map<Integer, ParsedSchema> idSchemaMap = this.idToSchemaCache.get(subject);
            for (Map.Entry<Integer, ParsedSchema> e : idSchemaMap.entrySet()) {
                if (!this.schemasEqual(e.getValue(), schema)) continue;
                id = e.getKey();
            }
            return new SchemaMetadata(new Schema(subject, version, (Integer)id, schema));
        }
        throw new RestClientException("Schema Not Found", 404, 40403);
    }

    @Override
    public int getVersion(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.getVersion(subject, schema, false);
    }

    @Override
    public int getVersion(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        Map<ParsedSchema, Integer> versions;
        if (normalize) {
            schema = schema.normalize();
        }
        if ((versions = this.schemaToVersionCache.get(subject)) != null) {
            return versions.get(schema);
        }
        throw new RestClientException("Subject Not Found", 404, 40401);
    }

    @Override
    public List<Integer> getAllVersions(String subject) throws IOException, RestClientException {
        List<Integer> allVersions = this.allVersions(subject);
        if (!allVersions.isEmpty()) {
            return allVersions;
        }
        throw new RestClientException("Subject Not Found", 404, 40401);
    }

    private List<Integer> allVersions(String subject) {
        ArrayList<Integer> allVersions = new ArrayList<Integer>();
        Map<ParsedSchema, Integer> versions = this.schemaToVersionCache.get(subject);
        if (versions != null) {
            allVersions.addAll(versions.values());
            Collections.sort(allVersions);
        }
        return allVersions;
    }

    @Override
    public boolean testCompatibility(String subject, ParsedSchema newSchema) throws IOException, RestClientException {
        CompatibilityLevel compatibilityLevel;
        Config config = this.configCache.get(subject);
        if (config == null) {
            config = this.defaultConfig;
        }
        if ((compatibilityLevel = CompatibilityLevel.forName(config.getCompatibilityLevel())) == null) {
            return false;
        }
        ArrayList<ParsedSchemaHolder> schemaHistory = new ArrayList<ParsedSchemaHolder>();
        for (int version : this.allVersions(subject)) {
            SchemaMetadata schemaMetadata = this.getSchemaMetadata(subject, version);
            schemaHistory.add(new SimpleParsedSchemaHolder(this.getSchemaBySubjectAndIdFromRegistry(subject, schemaMetadata.getId())));
        }
        return newSchema.isCompatible(compatibilityLevel, schemaHistory).isEmpty();
    }

    @Override
    public int getId(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.getId(subject, schema, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getId(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        Map schemaIdMap;
        Integer schemaId;
        if (normalize) {
            schema = schema.normalize();
        }
        if ((schemaId = (Integer)(schemaIdMap = this.schemaToIdCache.computeIfAbsent(subject, k -> new ConcurrentHashMap())).get(schema)) != null) {
            return schemaId;
        }
        MockSchemaRegistryClient mockSchemaRegistryClient = this;
        synchronized (mockSchemaRegistryClient) {
            schemaId = (Integer)schemaIdMap.get(schema);
            if (schemaId != null) {
                return schemaId;
            }
            int retrievedId = this.getIdFromRegistry(subject, schema, false, -1);
            schemaIdMap.put(schema, retrievedId);
            String context = MockSchemaRegistryClient.toQualifiedContext(subject);
            Map idSchemaMap = this.idToSchemaCache.computeIfAbsent(context, k -> new ConcurrentHashMap());
            idSchemaMap.put(retrievedId, schema);
            return retrievedId;
        }
    }

    @Override
    public List<Integer> deleteSubject(String subject, boolean isPermanent) throws IOException, RestClientException {
        return this.deleteSubject(null, subject, isPermanent);
    }

    @Override
    public synchronized List<Integer> deleteSubject(Map<String, String> requestProperties, String subject, boolean isPermanent) throws IOException, RestClientException {
        this.schemaToIdCache.remove(subject);
        this.idToSchemaCache.remove(subject);
        Map<ParsedSchema, Integer> versions = this.schemaToVersionCache.remove(subject);
        this.configCache.remove(subject);
        return versions != null ? versions.values().stream().sorted().collect(Collectors.toList()) : Collections.emptyList();
    }

    @Override
    public Integer deleteSchemaVersion(String subject, String version, boolean isPermanent) throws IOException, RestClientException {
        return this.deleteSchemaVersion(null, subject, version, isPermanent);
    }

    @Override
    public synchronized Integer deleteSchemaVersion(Map<String, String> requestProperties, String subject, String version, boolean isPermanent) throws IOException, RestClientException {
        Map<ParsedSchema, Integer> schemaVersionMap = this.schemaToVersionCache.get(subject);
        if (schemaVersionMap != null) {
            for (Map.Entry<ParsedSchema, Integer> entry : schemaVersionMap.entrySet()) {
                if (!entry.getValue().equals(Integer.valueOf(version))) continue;
                schemaVersionMap.values().remove(entry.getValue());
                if (isPermanent) {
                    this.idToSchemaCache.get(subject).remove(entry.getValue());
                    this.schemaToIdCache.get(subject).remove(entry.getKey());
                }
                return Integer.valueOf(version);
            }
        }
        return -1;
    }

    @Override
    public List<String> testCompatibilityVerbose(String subject, ParsedSchema newSchema) throws IOException, RestClientException {
        CompatibilityLevel compatibilityLevel;
        Config config = this.configCache.get(subject);
        if (config == null) {
            config = this.defaultConfig;
        }
        if ((compatibilityLevel = CompatibilityLevel.forName(config.getCompatibilityLevel())) == null) {
            return Lists.newArrayList((Object[])new String[]{"Compatibility level not specified."});
        }
        ArrayList<ParsedSchemaHolder> schemaHistory = new ArrayList<ParsedSchemaHolder>();
        for (int version : this.allVersions(subject)) {
            SchemaMetadata schemaMetadata = this.getSchemaMetadata(subject, version);
            schemaHistory.add(new SimpleParsedSchemaHolder(this.getSchemaBySubjectAndIdFromRegistry(subject, schemaMetadata.getId())));
        }
        return newSchema.isCompatible(compatibilityLevel, schemaHistory);
    }

    @Override
    public Config updateConfig(String subject, Config config) throws IOException, RestClientException {
        if (subject == null) {
            this.defaultConfig = config;
            return config;
        }
        this.configCache.put(subject, config);
        return config;
    }

    @Override
    public Config getConfig(String subject) throws IOException, RestClientException {
        if (subject == null) {
            return this.defaultConfig;
        }
        Config config = this.configCache.get(subject);
        if (config == null) {
            throw new RestClientException("Subject Not Found", 404, 40401);
        }
        return config;
    }

    @Override
    public String setMode(String mode) throws IOException, RestClientException {
        this.modes.put(WILDCARD, mode);
        return mode;
    }

    @Override
    public String setMode(String mode, String subject) throws IOException, RestClientException {
        this.modes.put(subject, mode);
        return mode;
    }

    @Override
    public String setMode(String mode, String subject, boolean force) throws IOException, RestClientException {
        this.modes.put(subject, mode);
        return mode;
    }

    @Override
    public String getMode() throws IOException, RestClientException {
        return this.modes.getOrDefault(WILDCARD, "READWRITE");
    }

    @Override
    public String getMode(String subject) throws IOException, RestClientException {
        String mode = this.modes.get(subject);
        if (mode == null) {
            throw new RestClientException("Subject Not Found", 404, 40401);
        }
        return mode;
    }

    @Override
    public Collection<String> getAllContexts() throws IOException, RestClientException {
        List<String> results = new ArrayList<String>(this.schemaToIdCache.keySet()).stream().map(s -> QualifiedSubject.create("default", s).getContext()).sorted().distinct().collect(Collectors.toList());
        return results;
    }

    @Override
    public Collection<String> getAllSubjects() throws IOException, RestClientException {
        ArrayList<String> results = new ArrayList<String>(this.schemaToIdCache.keySet());
        Collections.sort(results);
        return results;
    }

    @Override
    public Collection<String> getAllSubjectsByPrefix(String subjectPrefix) throws IOException, RestClientException {
        Stream<String> validSubjects = this.getAllSubjects().stream().filter(subject -> subjectPrefix == null || subject.startsWith(subjectPrefix));
        return validSubjects.collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public synchronized void reset() {
        this.schemaToIdCache.clear();
        this.registeredSchemaCache.clear();
        this.idToSchemaCache.clear();
        this.schemaToVersionCache.clear();
        this.configCache.clear();
        this.modes.clear();
        this.ids.clear();
    }

    private static String toQualifiedContext(String subject) {
        QualifiedSubject qualifiedSubject = QualifiedSubject.create("default", subject);
        return qualifiedSubject != null ? qualifiedSubject.toQualifiedContext() : NO_SUBJECT;
    }
}

