/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest;

import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.time.Duration;
import java.util.Random;
import java.util.concurrent.Callable;

public class RetryExecutor {
    static int RETRIES_ATTEMPTED_CEILING = (int)Math.floor(Math.log(2.147483647E9) / Math.log(2.0));
    private final int maxRetries;
    private final Duration initialWaitMs;
    private final Duration maxWaitMs;
    private final Random random;

    public RetryExecutor(int maxRetries, int initialWaitMs, int maxWaitMs) {
        this(maxRetries, initialWaitMs, maxWaitMs, new Random());
    }

    public RetryExecutor(int maxRetries, int initialWaitMs, int maxWaitMs, Random random) {
        this.maxRetries = maxRetries;
        this.initialWaitMs = Duration.ofMillis(initialWaitMs);
        this.maxWaitMs = Duration.ofMillis(maxWaitMs);
        this.random = random;
    }

    public <T> T retry(Callable<T> callable) throws RestClientException, IOException {
        for (int i = 0; i < this.maxRetries + 1; ++i) {
            try {
                return callable.call();
            }
            catch (RestClientException e) {
                if (i >= this.maxRetries || !RestService.isRetriable(e)) {
                    throw e;
                }
            }
            catch (IOException e) {
                if (i >= this.maxRetries) {
                    throw e;
                }
            }
            catch (Exception e) {
                throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            }
            this.sleepBeforeRetry(i);
        }
        return null;
    }

    private void sleepBeforeRetry(int attempt) {
        long delayMs = this.computeDelayBeforeNextRetry(attempt).toMillis();
        if (delayMs > 0L) {
            try {
                Thread.sleep(delayMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected Duration computeDelayBeforeNextRetry(int retriesAttempted) {
        int ceil = this.calculateExponentialDelay(retriesAttempted);
        return ceil == 0 ? Duration.ofMillis(0L) : Duration.ofMillis((long)this.random.nextInt(ceil) + 1L);
    }

    protected int calculateExponentialDelay(int retriesAttempted) {
        int cappedRetries = Math.min(retriesAttempted, RETRIES_ATTEMPTED_CEILING);
        return (int)Math.min(this.initialWaitMs.multipliedBy(1L << cappedRetries).toMillis(), this.maxWaitMs.toMillis());
    }
}

