/*
 * Copyright 2025 Confluent Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.confluent.kafka.schemaregistry;

public enum CompatibilityPolicy {
  STRICT,
  LENIENT;

  public final String name;

  private CompatibilityPolicy() {
    this.name = name();
  }

  public static CompatibilityPolicy forName(String name) {
    if (name == null) {
      return null;
    }

    name = name.toUpperCase();
    if (STRICT.name.equals(name)) {
      return STRICT;
    } else if (LENIENT.name.equals(name)) {
      return LENIENT;
    } else {
      return null;
    }
  }
}
