/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.maven.UploadSchemaRegistryMojo;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="test-compatibility", configurator="custom-basic")
public class TestCompatibilitySchemaRegistryMojo
extends UploadSchemaRegistryMojo {
    Map<String, Boolean> schemaCompatibility = new HashMap<String, Boolean>();

    @Override
    protected boolean processSchema(String subject, File schemaPath, ParsedSchema schema, Map<String, Integer> schemaVersions) throws IOException, RestClientException {
        boolean compatible;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format("Calling testCompatibility('%s', '%s')", subject, schema));
        }
        if (compatible = this.client().testCompatibility(subject, schema)) {
            this.getLog().info((CharSequence)String.format("Schema %s is compatible with subject(%s)", schemaPath, subject));
        } else {
            this.getLog().error((CharSequence)String.format("Schema %s is not compatible with subject(%s)", schemaPath, subject));
        }
        this.schemaCompatibility.put(subject, compatible);
        return compatible;
    }

    @Override
    protected String failureMessage() {
        return "One or more schemas found to be incompatible with the current version.";
    }
}

