/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven.derive.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.maven.derive.schema.DeriveSchema;
import io.confluent.kafka.schemaregistry.maven.derive.schema.DeriveSchemaUtils;
import java.util.List;
import java.util.Map;

public class DeriveJsonSchema
extends DeriveSchema {
    public static final String NUMBER = "number";
    public static final String STRING = "string";
    public static final String BOOLEAN = "boolean";
    public static final String NULL = "null";

    public DeriveJsonSchema() {
        this.classToDataType.put(DoubleNode.class.getName(), NUMBER);
        this.classToDataType.put(TextNode.class.getName(), STRING);
        this.classToDataType.put(BigIntegerNode.class.getName(), NUMBER);
        this.classToDataType.put(IntNode.class.getName(), NUMBER);
        this.classToDataType.put(LongNode.class.getName(), NUMBER);
        this.classToDataType.put(BooleanNode.class.getName(), BOOLEAN);
        this.classToDataType.put(NullNode.class.getName(), NULL);
        this.classToDataType.put(MissingNode.class.getName(), NULL);
    }

    @Override
    protected ObjectNode mergeMultipleDataTypes(ObjectNode mergedArray, List<JsonNode> primitives, List<JsonNode> records, List<JsonNode> arrays, boolean check2dArray) {
        ArrayNode items = mapper.createArrayNode().addAll(primitives);
        if (records.size() > 0) {
            items.add((JsonNode)this.mergeRecords(records));
        }
        if (arrays.size() > 0) {
            items.add((JsonNode)this.mergeArrays(arrays, true, false));
        }
        if (items.size() > 1) {
            ObjectNode oneOfDataType = (ObjectNode)mapper.createObjectNode().set("oneOf", (JsonNode)DeriveSchemaUtils.sortJsonArrayList(items));
            mergedArray.set("items", (JsonNode)oneOfDataType);
        } else if (items.size() == 1) {
            mergedArray.set("items", items.get(0));
        } else {
            mergedArray.set("items", (JsonNode)mapper.createObjectNode());
        }
        return mergedArray;
    }

    @Override
    public ArrayNode mergeMultipleMessages(List<JsonNode> uniqueSchemas, Map<JsonNode, ArrayNode> schemaToIndex) {
        ObjectNode schema = this.mergeRecords(uniqueSchemas);
        ArrayNode messagesMatched = mapper.createArrayNode();
        int totalSize = 0;
        for (Map.Entry<JsonNode, ArrayNode> entry : schemaToIndex.entrySet()) {
            totalSize += entry.getValue().size();
        }
        for (int i = 0; i < totalSize; ++i) {
            messagesMatched.add(i);
        }
        ArrayNode schemaInfoList = mapper.createArrayNode();
        this.updateSchemaInformation((JsonNode)schema, messagesMatched, schemaInfoList);
        return schemaInfoList;
    }

    @Override
    protected JsonNode convertToFormat(JsonNode schema, String name) {
        JsonSchema jsonSchema = new JsonSchema(schema);
        jsonSchema.validate(false);
        return schema;
    }
}

