/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.maven.UploadSchemaRegistryMojo;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="register", configurator="custom-basic")
public class RegisterSchemaRegistryMojo
extends UploadSchemaRegistryMojo {
    @Parameter(required=false)
    boolean normalizeSchemas = false;
    @Parameter(required=false)
    boolean propagateSchemaTags = false;

    @Override
    protected boolean processSchema(String subject, File schemaPath, ParsedSchema schema, Map<String, Integer> schemaVersions) throws IOException, RestClientException {
        Optional optSchema;
        RegisterSchemaResponse response;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format("Calling register('%s', '%s')", subject, schema));
        }
        if ((response = this.client().registerWithResponse(subject, schema, this.normalizeSchemas, this.propagateSchemaTags)).getSchema() != null && (optSchema = this.client().parseSchema(new Schema(subject, response))).isPresent()) {
            schema = (ParsedSchema)optSchema.get();
            schema = schema.copy(response.getVersion());
        }
        Integer id = response.getId();
        Integer version = this.client().getVersion(subject, schema, this.normalizeSchemas);
        this.getLog().info((CharSequence)String.format("Registered subject(%s) with id %s version %s", subject, id, version));
        schemaVersions.put(subject, version);
        return true;
    }
}

