/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import io.confluent.kafka.schemaregistry.CompatibilityChecker;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.CompatibilityPolicy;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.maven.MojoUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="test-local-compatibility", configurator="custom-basic")
public class TestLocalCompatibilityMojo
extends AbstractMojo {
    @Parameter(required=true)
    Map<String, File> schemas = new HashMap<String, File>();
    @Parameter(required=false)
    Map<String, String> schemaTypes = new HashMap<String, String>();
    @Parameter(required=true)
    Map<String, File> previousSchemaPaths = new HashMap<String, File>();
    @Parameter(required=true)
    Map<String, CompatibilityLevel> compatibilityLevels = new HashMap<String, CompatibilityLevel>();
    @Parameter(required=false)
    Map<String, CompatibilityPolicy> compatibilityPolicies = new HashMap<String, CompatibilityPolicy>();

    protected Optional<ParsedSchema> parseSchema(String schemaType, String schemaString, List<SchemaReference> references, Map<String, SchemaProvider> providers) throws MojoExecutionException {
        SchemaProvider schemaProvider = providers.get(schemaType.toUpperCase());
        if (schemaProvider == null) {
            throw new MojoExecutionException(String.format("Invalid schema type %s", schemaType));
        }
        return schemaProvider.parseSchema(schemaString, references);
    }

    protected ParsedSchema loadSchema(File path, String schemaType, Map<String, SchemaProvider> schemaProviders) throws MojoExecutionException {
        String schemaString;
        try {
            schemaString = MojoUtils.readFile(path, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("File cannot be found at: %s", path));
        }
        ArrayList<SchemaReference> references = new ArrayList<SchemaReference>();
        Optional<ParsedSchema> schema = this.parseSchema(schemaType, schemaString, references, schemaProviders);
        if (schema.isPresent()) {
            return schema.get();
        }
        throw new MojoExecutionException(String.format("Unable to parse schema from %s with schema type as %s", path, schemaType));
    }

    protected ArrayList<File> getFiles(File previousSchemaPath) {
        ArrayList<File> previousSchemaFiles = new ArrayList<File>();
        this.getLog().debug((CharSequence)String.format("Loading File %s", previousSchemaPath));
        if (previousSchemaPath.isDirectory()) {
            File[] fileList = previousSchemaPath.listFiles();
            if (fileList == null) {
                return previousSchemaFiles;
            }
            for (File f : fileList) {
                if (f.isDirectory()) continue;
                previousSchemaFiles.add(f);
            }
        } else {
            previousSchemaFiles.add(previousSchemaPath);
        }
        return previousSchemaFiles;
    }

    protected void testSchema(String key, Map<String, SchemaProvider> schemaProviders) throws MojoExecutionException {
        File schemaPath = this.schemas.get(key);
        if (!this.previousSchemaPaths.containsKey(key)) {
            throw new MojoExecutionException(String.format("Previous schemas not found for %s", key));
        }
        File previousSchemaPath = this.previousSchemaPaths.get(key);
        String schemaType = this.schemaTypes.getOrDefault(key, "AVRO");
        if (!this.compatibilityLevels.containsKey(key)) {
            throw new MojoExecutionException(String.format("Compatibility Level not found for %s", key));
        }
        CompatibilityLevel compatibilityLevel = this.compatibilityLevels.get(key);
        ArrayList<File> previousSchemaFiles = this.getFiles(previousSchemaPath);
        if (previousSchemaFiles.size() > 1 && (compatibilityLevel == CompatibilityLevel.BACKWARD || compatibilityLevel == CompatibilityLevel.FORWARD || compatibilityLevel == CompatibilityLevel.FULL)) {
            throw new MojoExecutionException(String.format("Provide exactly one file for %s check for schema %s", compatibilityLevel.name.toLowerCase(), schemaPath));
        }
        ParsedSchema schema = this.loadSchema(schemaPath, schemaType, schemaProviders);
        ArrayList<ParsedSchema> previousSchemas = new ArrayList<ParsedSchema>();
        for (File previousSchemaFile : previousSchemaFiles) {
            previousSchemas.add(this.loadSchema(previousSchemaFile, schemaType, schemaProviders));
        }
        CompatibilityPolicy compatibilityPolicy = this.compatibilityPolicies.getOrDefault(key, CompatibilityPolicy.STRICT);
        CompatibilityChecker checker = CompatibilityChecker.checker((CompatibilityLevel)compatibilityLevel);
        List errorMessages = checker.isCompatible(compatibilityPolicy, schema, previousSchemas);
        boolean success = errorMessages.isEmpty();
        if (!success) {
            String errorLog = String.format("Schema is not %s compatible with previous schemas. ", compatibilityLevel.name.toLowerCase()) + (String)errorMessages.get(0);
            throw new MojoExecutionException(errorLog);
        }
        this.getLog().info((CharSequence)String.format("Schema is %s compatible with previous schemas", compatibilityLevel.name.toLowerCase()));
    }

    public void execute() throws MojoExecutionException {
        List<SchemaProvider> providers = MojoUtils.defaultSchemaProviders();
        Map<String, SchemaProvider> schemaProviders = providers.stream().collect(Collectors.toMap(SchemaProvider::schemaType, p -> p));
        Set<String> keys = this.schemas.keySet();
        for (String key : keys) {
            this.testSchema(key, schemaProviders);
        }
    }
}

