/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaTypeConverter;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaReference;
import io.confluent.kafka.schemaregistry.storage.SubjectValue;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SchemaValue
extends SubjectValue
implements Comparable<SchemaValue> {
    @Min(value=1L)
    private @Min(value=1L) Integer version;
    @Min(value=0L)
    private @Min(value=0L) Integer id;
    @NotEmpty
    private String schema;
    private String schemaType = "AVRO";
    private List<SchemaReference> references = Collections.emptyList();
    @NotEmpty
    private boolean deleted;

    @VisibleForTesting
    public SchemaValue(@JsonProperty(value="subject") String subject, @JsonProperty(value="version") Integer version, @JsonProperty(value="id") Integer id, @JsonProperty(value="schema") String schema, @JsonProperty(value="deleted") boolean deleted) {
        super(subject);
        this.version = version;
        this.id = id;
        this.schema = schema;
        this.deleted = deleted;
    }

    @JsonCreator
    public SchemaValue(@JsonProperty(value="subject") String subject, @JsonProperty(value="version") Integer version, @JsonProperty(value="id") Integer id, @JsonProperty(value="schemaType") String schemaType, @JsonProperty(value="references") List<SchemaReference> references, @JsonProperty(value="schema") String schema, @JsonProperty(value="deleted") boolean deleted) {
        super(subject);
        this.version = version;
        this.id = id;
        this.schemaType = schemaType != null ? schemaType : "AVRO";
        this.references = references != null ? references : Collections.emptyList();
        this.schema = schema;
        this.deleted = deleted;
    }

    public SchemaValue(Schema schemaEntity) {
        super(schemaEntity.getSubject());
        this.version = schemaEntity.getVersion();
        this.id = schemaEntity.getId();
        this.schemaType = schemaEntity.getSchemaType();
        List refs = schemaEntity.getReferences();
        this.references = refs == null ? null : refs.stream().map(ref -> new SchemaReference(ref.getName(), ref.getSubject(), ref.getVersion())).collect(Collectors.toList());
        this.schema = schemaEntity.getSchema();
        this.deleted = false;
    }

    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    @JsonProperty(value="schemaType")
    @JsonSerialize(converter=SchemaTypeConverter.class)
    public String getSchemaType() {
        return this.schemaType;
    }

    @JsonProperty(value="schemaType")
    public void setSchemaType(String schemaType) {
        this.schemaType = schemaType != null ? schemaType : "AVRO";
    }

    @JsonProperty(value="references")
    public List<SchemaReference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="references")
    public void setReferences(List<SchemaReference> references) {
        this.references = references;
    }

    @JsonProperty(value="schema")
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    public void setSchema(String schema) {
        this.schema = schema;
    }

    @JsonProperty(value="deleted")
    public boolean isDeleted() {
        return this.deleted;
    }

    @JsonProperty(value="deleted")
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SchemaValue that = (SchemaValue)o;
        if (!this.version.equals(that.version)) {
            return false;
        }
        if (!this.id.equals(that.getId())) {
            return false;
        }
        if (this.schemaType != null ? !this.schemaType.equals(that.schemaType) : that.schemaType != null) {
            return false;
        }
        if (!this.references.equals(that.getReferences())) {
            return false;
        }
        if (!this.schema.equals(that.schema)) {
            return false;
        }
        return this.deleted == that.deleted;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.version;
        result = 31 * result + this.id;
        result = 31 * result + (this.schemaType != null ? this.schemaType.hashCode() : 0);
        result = 31 * result + this.schema.hashCode();
        result = 31 * result + this.references.hashCode();
        result = 31 * result + (this.deleted ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{subject=" + this.getSubject() + ",");
        sb.append("version=" + this.version + ",");
        sb.append("id=" + this.id + ",");
        sb.append("schemaType=" + this.schemaType + ",");
        sb.append("references=" + this.references + ",");
        sb.append("schema=" + this.schema + ",");
        sb.append("deleted=" + this.deleted + "}");
        return sb.toString();
    }

    @Override
    public int compareTo(SchemaValue that) {
        int result = this.getSubject().compareTo(that.getSubject());
        if (result != 0) {
            return result;
        }
        result = this.version - that.version;
        return result;
    }

    @Override
    public SchemaKey toKey() {
        return new SchemaKey(this.getSubject(), this.getVersion());
    }
}

