/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.storage.ConfigKey;
import io.confluent.kafka.schemaregistry.storage.Metadata;
import io.confluent.kafka.schemaregistry.storage.RuleSet;
import io.confluent.kafka.schemaregistry.storage.RuleSetHandler;
import io.confluent.kafka.schemaregistry.storage.SubjectValue;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ConfigValue
extends SubjectValue {
    private CompatibilityLevel compatibilityLevel;
    private String compatibilityGroup;
    private Metadata defaultMetadata;
    private Metadata overrideMetadata;
    private RuleSet defaultRuleSet;
    private RuleSet overrideRuleSet;

    public ConfigValue(@JsonProperty(value="subject") String subject, @JsonProperty(value="compatibilityLevel") CompatibilityLevel compatibilityLevel, @JsonProperty(value="compatibilityGroup") String compatibilityGroup, @JsonProperty(value="defaultMetadata") Metadata defaultMetadata, @JsonProperty(value="overrideMetadata") Metadata overrideMetadata, @JsonProperty(value="defaultRuleSet") RuleSet defaultRuleSet, @JsonProperty(value="overrideRuleSet") RuleSet overrideRuleSet) {
        super(subject);
        this.compatibilityLevel = compatibilityLevel;
        this.compatibilityGroup = compatibilityGroup;
        this.defaultMetadata = defaultMetadata;
        this.overrideMetadata = overrideMetadata;
        this.defaultRuleSet = defaultRuleSet;
        this.overrideRuleSet = overrideRuleSet;
    }

    public ConfigValue(String subject, Config configEntity) {
        super(subject);
        this.compatibilityLevel = CompatibilityLevel.forName((String)configEntity.getCompatibilityLevel());
        this.compatibilityGroup = configEntity.getCompatibilityGroup();
        io.confluent.kafka.schemaregistry.client.rest.entities.Metadata defaultMetadata = configEntity.getDefaultMetadata();
        this.defaultMetadata = defaultMetadata != null ? new Metadata(defaultMetadata) : null;
        io.confluent.kafka.schemaregistry.client.rest.entities.Metadata overrideMetadata = configEntity.getOverrideMetadata();
        this.overrideMetadata = overrideMetadata != null ? new Metadata(overrideMetadata) : null;
        io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet defaultRuleSet = configEntity.getDefaultRuleSet();
        this.defaultRuleSet = defaultRuleSet != null ? new RuleSet(defaultRuleSet) : null;
        io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet overrideRuleSet = configEntity.getOverrideRuleSet();
        this.overrideRuleSet = overrideRuleSet != null ? new RuleSet(overrideRuleSet) : null;
    }

    public ConfigValue(String subject, Config configEntity, RuleSetHandler ruleSetHandler) {
        super(subject);
        this.compatibilityLevel = CompatibilityLevel.forName((String)configEntity.getCompatibilityLevel());
        this.compatibilityGroup = configEntity.getCompatibilityGroup();
        io.confluent.kafka.schemaregistry.client.rest.entities.Metadata defaultMetadata = configEntity.getDefaultMetadata();
        this.defaultMetadata = defaultMetadata != null ? new Metadata(defaultMetadata) : null;
        io.confluent.kafka.schemaregistry.client.rest.entities.Metadata overrideMetadata = configEntity.getOverrideMetadata();
        this.overrideMetadata = overrideMetadata != null ? new Metadata(overrideMetadata) : null;
        this.defaultRuleSet = ruleSetHandler.transform(configEntity.getDefaultRuleSet());
        this.overrideRuleSet = ruleSetHandler.transform(configEntity.getOverrideRuleSet());
    }

    public ConfigValue(String subject, CompatibilityLevel compatibilityLevel) {
        super(subject);
        this.compatibilityLevel = compatibilityLevel;
    }

    @JsonProperty(value="compatibilityLevel")
    public CompatibilityLevel getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    @JsonProperty(value="compatibilityLevel")
    public void setCompatibilityLevel(CompatibilityLevel compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
    }

    @JsonProperty(value="compatibilityGroup")
    public String getCompatibilityGroup() {
        return this.compatibilityGroup;
    }

    @JsonProperty(value="compatibilityGroup")
    public void setCompatibilityGroup(String compatibilityGroup) {
        this.compatibilityGroup = compatibilityGroup;
    }

    @JsonProperty(value="defaultMetadata")
    public Metadata getDefaultMetadata() {
        return this.defaultMetadata;
    }

    @JsonProperty(value="defaultMetadata")
    public void setDefaultMetadata(Metadata defaultMetadata) {
        this.defaultMetadata = defaultMetadata;
    }

    @JsonProperty(value="overrideMetadata")
    public Metadata getOverrideMetadata() {
        return this.overrideMetadata;
    }

    @JsonProperty(value="overrideMetadata")
    public void setOverrideMetadata(Metadata overrideMetadata) {
        this.overrideMetadata = overrideMetadata;
    }

    @JsonProperty(value="defaultRuleSet")
    public RuleSet getDefaultRuleSet() {
        return this.defaultRuleSet;
    }

    @JsonProperty(value="defaultRuleSet")
    public void setDefaultRuleSet(RuleSet defaultRuleSet) {
        this.defaultRuleSet = defaultRuleSet;
    }

    @JsonProperty(value="overrideRuleSet")
    public RuleSet getOverrideRuleSet() {
        return this.overrideRuleSet;
    }

    @JsonProperty(value="overrideRuleSet")
    public void setOverrideRuleSet(RuleSet overrideRuleSet) {
        this.overrideRuleSet = overrideRuleSet;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigValue that = (ConfigValue)o;
        return this.compatibilityLevel == that.compatibilityLevel && Objects.equals(this.compatibilityGroup, that.compatibilityGroup) && Objects.equals(this.defaultMetadata, that.defaultMetadata) && Objects.equals(this.overrideMetadata, that.overrideMetadata) && Objects.equals(this.defaultRuleSet, that.defaultRuleSet) && Objects.equals(this.overrideRuleSet, that.overrideRuleSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.compatibilityLevel, this.compatibilityGroup, this.defaultMetadata, this.overrideMetadata, this.defaultRuleSet, this.overrideRuleSet);
    }

    public String toString() {
        return "ConfigValue{compatibilityLevel=" + this.compatibilityLevel + ", compatibilityGroup='" + this.compatibilityGroup + '\'' + ", defaultMetadata=" + this.defaultMetadata + ", overrideMetadata=" + this.overrideMetadata + ", defaultRuleSet=" + this.defaultRuleSet + ", overrideRuleSet=" + this.overrideRuleSet + '}';
    }

    @Override
    public ConfigKey toKey() {
        return new ConfigKey(this.getSubject());
    }

    public Config toConfigEntity() {
        return new Config(this.compatibilityLevel != null ? this.compatibilityLevel.name : null, this.compatibilityGroup, this.defaultMetadata != null ? this.defaultMetadata.toMetadataEntity() : null, this.overrideMetadata != null ? this.overrideMetadata.toMetadataEntity() : null, this.defaultRuleSet != null ? this.defaultRuleSet.toRuleSetEntity() : null, this.overrideRuleSet != null ? this.overrideRuleSet.toRuleSetEntity() : null);
    }

    public static ConfigValue update(ConfigValue oldConfig, ConfigValue newConfig) {
        if (oldConfig == null) {
            return newConfig;
        }
        if (newConfig == null) {
            return oldConfig;
        }
        return new ConfigValue(newConfig.getSubject() != null ? newConfig.getSubject() : oldConfig.getSubject(), newConfig.getCompatibilityLevel() != null ? newConfig.getCompatibilityLevel() : oldConfig.getCompatibilityLevel(), newConfig.getCompatibilityGroup() != null ? newConfig.getCompatibilityGroup() : oldConfig.getCompatibilityGroup(), newConfig.getDefaultMetadata() != null ? newConfig.getDefaultMetadata() : oldConfig.getDefaultMetadata(), newConfig.getOverrideMetadata() != null ? newConfig.getOverrideMetadata() : oldConfig.getOverrideMetadata(), newConfig.getDefaultRuleSet() != null ? newConfig.getDefaultRuleSet() : oldConfig.getDefaultRuleSet(), newConfig.getOverrideRuleSet() != null ? newConfig.getOverrideRuleSet() : oldConfig.getOverrideRuleSet());
    }
}

