/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.rest.MutableHttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MutableHttpServletRequestTest {
    MutableHttpServletRequest mutableRequest;
    @Mock
    HttpServletRequest httpServletRequest;

    @Before
    public void setup() {
        Mockito.reset((Object[])new HttpServletRequest[]{this.httpServletRequest});
        this.mutableRequest = new MutableHttpServletRequest(this.httpServletRequest);
    }

    @Test
    public void testGetWithNoInitialHeaders() {
        Mockito.when((Object)this.httpServletRequest.getHeader("header-key-0")).thenReturn(null);
        Mockito.when((Object)this.httpServletRequest.getHeaders("header-key-0")).thenReturn(Collections.emptyEnumeration());
        Mockito.when((Object)this.httpServletRequest.getHeaderNames()).thenReturn(Collections.emptyEnumeration());
        String headerValue = this.mutableRequest.getHeader("header-key-0");
        Assert.assertNull((Object)headerValue);
        Enumeration headerValues = this.mutableRequest.getHeaders("header-key-0");
        Assert.assertFalse((boolean)headerValues.hasMoreElements());
        Enumeration headerNames = this.mutableRequest.getHeaderNames();
        Assert.assertFalse((boolean)headerNames.hasMoreElements());
    }

    @Test
    public void testGetAndPutWithNoInitialHeaders() {
        Mockito.when((Object)this.httpServletRequest.getHeader("header-key-0")).thenReturn(null);
        Mockito.when((Object)this.httpServletRequest.getHeaders("header-key-0")).thenReturn(Collections.emptyEnumeration());
        Mockito.when((Object)this.httpServletRequest.getHeaderNames()).thenReturn(Collections.emptyEnumeration());
        this.mutableRequest.putHeader("header-key-0", "new-header-value-98");
        Assert.assertEquals((Object)"new-header-value-98", (Object)this.mutableRequest.getHeader("header-Key-0"));
        Assert.assertEquals((Object)"new-header-value-98", (Object)this.mutableRequest.getHeader("header-key-0"));
        Assert.assertEquals((Object)"new-header-value-98", (Object)this.mutableRequest.getHeader("HEADER-KEY-0"));
        ArrayList headerValuesList = Collections.list(this.mutableRequest.getHeaders("header-key-0"));
        Assert.assertEquals((long)1L, (long)headerValuesList.size());
        Assert.assertEquals((Object)"new-header-value-98", headerValuesList.get(0));
        headerValuesList = Collections.list(this.mutableRequest.getHeaders("header-KEY-0"));
        Assert.assertEquals((long)1L, (long)headerValuesList.size());
        Assert.assertEquals((Object)"new-header-value-98", headerValuesList.get(0));
        Enumeration headerNames = this.mutableRequest.getHeaderNames();
        ArrayList headerNamesList = Collections.list(headerNames);
        Assert.assertEquals((long)1L, (long)headerNamesList.size());
        Assert.assertTrue((boolean)headerNamesList.contains("header-key-0"));
        this.mutableRequest.putHeader("header-Key-0", "new-header-value-75");
        Assert.assertEquals((Object)"new-header-value-75", (Object)this.mutableRequest.getHeader("header-Key-0"));
        Assert.assertEquals((Object)"new-header-value-75", (Object)this.mutableRequest.getHeader("header-key-0"));
        Assert.assertEquals((Object)"new-header-value-75", (Object)this.mutableRequest.getHeader("HEADER-KEY-0"));
        headerValuesList = Collections.list(this.mutableRequest.getHeaders("header-key-0"));
        Assert.assertEquals((long)1L, (long)headerValuesList.size());
        Assert.assertEquals((Object)"new-header-value-75", headerValuesList.get(0));
        headerValuesList = Collections.list(this.mutableRequest.getHeaders("header-KEY-0"));
        Assert.assertEquals((long)1L, (long)headerValuesList.size());
        Assert.assertEquals((Object)"new-header-value-75", headerValuesList.get(0));
        headerNames = this.mutableRequest.getHeaderNames();
        headerNamesList = Collections.list(headerNames);
        Assert.assertEquals((long)1L, (long)headerNamesList.size());
        Assert.assertTrue((boolean)headerNamesList.contains("header-key-0"));
    }

    @Test
    public void testGetAndPutWithInitialHeaders() {
        Mockito.when((Object)this.httpServletRequest.getHeader("header-key-0")).thenReturn((Object)"header-value-78.1");
        Mockito.when((Object)this.httpServletRequest.getHeaders("header-key-0")).thenReturn(Collections.enumeration(Arrays.asList("header-value-78.1", "header-value-78.2")));
        Mockito.when((Object)this.httpServletRequest.getHeader("header-key-2")).thenReturn((Object)"header-value-62.1");
        Mockito.when((Object)this.httpServletRequest.getHeaders("header-key-2")).thenReturn(Collections.enumeration(Arrays.asList("header-value-62.1", "header-value-62.2")));
        Mockito.when((Object)this.httpServletRequest.getHeaderNames()).thenReturn(Collections.enumeration(Arrays.asList("header-key-0", "header-KEY-0", "header-key-2")));
        Assert.assertEquals((Object)"header-value-78.1", (Object)this.mutableRequest.getHeader("header-key-0"));
        Enumeration headerValues = this.mutableRequest.getHeaders("header-key-0");
        ArrayList headerValuesList = Collections.list(headerValues);
        Assert.assertEquals((long)2L, (long)headerValuesList.size());
        Assert.assertTrue((boolean)headerValuesList.contains("header-value-78.1"));
        Assert.assertTrue((boolean)headerValuesList.contains("header-value-78.2"));
        Assert.assertEquals((Object)"header-value-62.1", (Object)this.mutableRequest.getHeader("header-key-2"));
        headerValues = this.mutableRequest.getHeaders("header-key-2");
        headerValuesList = Collections.list(headerValues);
        Assert.assertEquals((long)2L, (long)headerValuesList.size());
        Assert.assertTrue((boolean)headerValuesList.contains("header-value-62.1"));
        Assert.assertTrue((boolean)headerValuesList.contains("header-value-62.2"));
        this.mutableRequest.putHeader("header-key-0", "new-header-value-98");
        Assert.assertEquals((Object)"new-header-value-98", (Object)this.mutableRequest.getHeader("header-key-0"));
        Assert.assertEquals((Object)"new-header-value-98", (Object)this.mutableRequest.getHeader("header-KEY-0"));
        this.mutableRequest.putHeader("header-key-0", "new-header-value-100");
        Assert.assertEquals((Object)"new-header-value-100", (Object)this.mutableRequest.getHeader("header-key-0"));
        Assert.assertEquals((Object)"new-header-value-100", (Object)this.mutableRequest.getHeader("Header-Key-0"));
        this.mutableRequest.putHeader("HEADER-KEY-0", "new-header-value-999");
        Assert.assertEquals((Object)"new-header-value-999", (Object)this.mutableRequest.getHeader("header-key-0"));
        Assert.assertEquals((Object)"new-header-value-999", (Object)this.mutableRequest.getHeader("Header-Key-0"));
        this.mutableRequest.putHeader("header-key-1", "new-header-value-54");
        Assert.assertEquals((Object)"new-header-value-54", (Object)this.mutableRequest.getHeader("header-key-1"));
        Assert.assertEquals((Object)"new-header-value-54", (Object)this.mutableRequest.getHeader("HEADER-key-1"));
        headerValues = this.mutableRequest.getHeaders("header-key-0");
        headerValuesList = Collections.list(headerValues);
        Assert.assertEquals((long)1L, (long)headerValuesList.size());
        Assert.assertEquals((Object)"new-header-value-999", headerValuesList.get(0));
        headerValues = this.mutableRequest.getHeaders("Header-Key-0");
        headerValuesList = Collections.list(headerValues);
        Assert.assertEquals((long)1L, (long)headerValuesList.size());
        Assert.assertEquals((Object)"new-header-value-999", headerValuesList.get(0));
        headerValues = this.mutableRequest.getHeaders("header-key-1");
        headerValuesList = Collections.list(headerValues);
        Assert.assertEquals((long)1L, (long)headerValuesList.size());
        Assert.assertEquals((Object)"new-header-value-54", headerValuesList.get(0));
        headerValues = this.mutableRequest.getHeaders("HEADER-key-1");
        headerValuesList = Collections.list(headerValues);
        Assert.assertEquals((long)1L, (long)headerValuesList.size());
        Assert.assertEquals((Object)"new-header-value-54", headerValuesList.get(0));
        Enumeration headerNames = this.mutableRequest.getHeaderNames();
        ArrayList headerNamesList = Collections.list(headerNames);
        Assert.assertEquals((long)3L, (long)headerNamesList.size());
        Assert.assertTrue((boolean)headerNamesList.contains("header-key-0"));
        Assert.assertTrue((boolean)headerNamesList.contains("header-key-1"));
        Assert.assertTrue((boolean)headerNamesList.contains("header-key-2"));
    }
}

