/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.schemaregistry.rest.resources.RequestHeaderBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class RequestHeaderBuilderTest {
    @Test
    public void testHeaderProperties() {
        HttpHeaders httpHeaders = this.mockHttpHeaders((Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json", (Object)"Accept", (Object)"application/json", (Object)"Authorization", (Object)"test", (Object)"X-Request-ID", (Object)"24b9afef-3cc7-4e32-944d-f89253c1b64b"));
        RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();
        Map requestProps = requestHeaderBuilder.buildRequestHeaders(httpHeaders, Collections.EMPTY_LIST);
        Assert.assertNotNull((Object)requestProps);
        Assert.assertEquals((Object)"application/json", requestProps.get("Content-Type"));
        Assert.assertEquals((Object)"application/json", requestProps.get("Accept"));
        Assert.assertEquals((Object)"test", requestProps.get("Authorization"));
        Assert.assertEquals((Object)"24b9afef-3cc7-4e32-944d-f89253c1b64b", requestProps.get("X-Request-ID"));
    }

    private HttpHeaders mockHttpHeaders(Map<String, String> headers) {
        HttpHeaders httpHeaders = (HttpHeaders)EasyMock.createMock(HttpHeaders.class);
        headers.forEach((headerName, headerValue) -> EasyMock.expect((Object)httpHeaders.getHeaderString(headerName)).andReturn(headerValue));
        EasyMock.replay((Object[])new Object[]{httpHeaders});
        return httpHeaders;
    }

    @Test
    public void testEmptyProperty() {
        HttpHeaders httpHeaders = this.mockHttpHeaders((Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json", (Object)"Accept", (Object)"application/json", (Object)"Authorization", (Object)"", (Object)"X-Request-ID", (Object)"24b9afef-3cc7-4e32-944d-f89253c1b64b"));
        RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();
        Map requestProps = requestHeaderBuilder.buildRequestHeaders(httpHeaders, Collections.EMPTY_LIST);
        Assert.assertNotNull((Object)requestProps);
        Assert.assertEquals((Object)"application/json", requestProps.get("Content-Type"));
        Assert.assertEquals((Object)"application/json", requestProps.get("Accept"));
        Assert.assertEquals((Object)"24b9afef-3cc7-4e32-944d-f89253c1b64b", requestProps.get("X-Request-ID"));
        Assert.assertNull(requestProps.get("Authorization"));
    }

    @Test
    public void testMissingProperty() {
        HttpHeaders httpHeaders = this.mockHttpHeaders((Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json", (Object)"Accept", (Object)"application/json", (Object)"Authorization", (Object)"", (Object)"X-Request-ID", (Object)"24b9afef-3cc7-4e32-944d-f89253c1b64b"));
        RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();
        Map requestProps = requestHeaderBuilder.buildRequestHeaders(httpHeaders, Collections.EMPTY_LIST);
        Assert.assertNotNull((Object)requestProps);
        Assert.assertEquals((Object)"application/json", requestProps.get("Content-Type"));
        Assert.assertEquals((Object)"application/json", requestProps.get("Accept"));
        Assert.assertNull(requestProps.get("Authorization"));
        Assert.assertEquals((Object)"24b9afef-3cc7-4e32-944d-f89253c1b64b", requestProps.get("X-Request-ID"));
    }

    @Test
    public void testForwardOneHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "");
        headers.put("Accept", "");
        headers.put("Authorization", "");
        headers.put("target-sr-cluster", "sr-xyz");
        headers.put("some-other-header", "abc");
        headers.put("X-Request-ID", "24b9afef-3cc7-4e32-944d-f89253c1b64b");
        HttpHeaders httpHeaders = this.mockHttpHeaders(headers);
        RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();
        Map requestProps = requestHeaderBuilder.buildRequestHeaders(httpHeaders, Collections.singletonList("target-sr-cluster"));
        Assert.assertNotNull((Object)requestProps);
        Assert.assertEquals((Object)"sr-xyz", requestProps.get("target-sr-cluster"));
        Assert.assertNull(requestProps.get("some-other-header"));
        Assert.assertEquals((Object)"24b9afef-3cc7-4e32-944d-f89253c1b64b", requestProps.get("X-Request-ID"));
    }

    @Test
    public void testForwardMultipleHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "");
        headers.put("Accept", "");
        headers.put("Authorization", "");
        headers.put("target-sr-cluster", "sr-xyz");
        headers.put("some-other-header", "abc");
        headers.put("X-Request-ID", "24b9afef-3cc7-4e32-944d-f89253c1b64b");
        HttpHeaders httpHeaders = this.mockHttpHeaders(headers);
        ImmutableList headersForward = ImmutableList.of((Object)"target-sr-cluster", (Object)"some-other-header");
        RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();
        Map requestProps = requestHeaderBuilder.buildRequestHeaders(httpHeaders, (List)headersForward);
        Assert.assertNotNull((Object)requestProps);
        Assert.assertEquals((Object)"sr-xyz", requestProps.get("target-sr-cluster"));
        Assert.assertEquals((Object)"abc", requestProps.get("some-other-header"));
        Assert.assertEquals((Object)"24b9afef-3cc7-4e32-944d-f89253c1b64b", requestProps.get("X-Request-ID"));
    }

    @Test
    public void testDoNotForwardHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "");
        headers.put("Accept", "");
        headers.put("Authorization", "");
        headers.put("target-sr-cluster", "sr-xyz");
        headers.put("some-other-header", "abc");
        headers.put("X-Request-ID", "24b9afef-3cc7-4e32-944d-f89253c1b64b");
        HttpHeaders httpHeaders = this.mockHttpHeaders(headers);
        RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();
        Map requestProps = requestHeaderBuilder.buildRequestHeaders(httpHeaders, Collections.EMPTY_LIST);
        Assert.assertNotNull((Object)requestProps);
        Assert.assertNull(requestProps.get("target-sr-cluster"));
        Assert.assertNull(requestProps.get("some-other-header"));
        Assert.assertEquals((Object)"24b9afef-3cc7-4e32-944d-f89253c1b64b", requestProps.get("X-Request-ID"));
    }

    @Test
    public void testNullWhitelist() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        headers.put("Authorization", "test");
        headers.put("target-sr-cluster", "sr-xyz");
        headers.put("some-other-header", "abc");
        headers.put("X-Request-ID", "24b9afef-3cc7-4e32-944d-f89253c1b64b");
        HttpHeaders httpHeaders = this.mockHttpHeaders(headers);
        RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();
        Map requestProps = requestHeaderBuilder.buildRequestHeaders(httpHeaders, null);
        Assert.assertNotNull((Object)requestProps);
        Assert.assertEquals((Object)"application/json", requestProps.get("Content-Type"));
        Assert.assertEquals((Object)"application/json", requestProps.get("Accept"));
        Assert.assertEquals((Object)"test", requestProps.get("Authorization"));
        Assert.assertNull(requestProps.get("target-sr-cluster"));
        Assert.assertNull(requestProps.get("some-other-header"));
        Assert.assertEquals((Object)"24b9afef-3cc7-4e32-944d-f89253c1b64b", requestProps.get("X-Request-ID"));
    }
}

