/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.filters;

import io.confluent.kafka.schemaregistry.rest.filters.ContextFilter;
import java.net.URI;
import java.util.Collections;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.junit.Assert;
import org.junit.Test;

public class ContextFilterTest {
    ContextFilter contextFilter = new ContextFilter();

    @Test
    public void testContextsRoot() {
        String path = "/contexts/";
        Assert.assertEquals((String)"URI most not change", (Object)"/contexts/", (Object)this.contextFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testSubjectPartOfUri() {
        String path = "/contexts/.test-ctx/subjects/test-subject/versions";
        Assert.assertEquals((String)"Subject must be prefixed", (Object)"/subjects/:.test-ctx:test-subject/versions/", (Object)this.contextFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testSubjectPartOfUriDefaultContext() {
        String path = "/contexts/:.:/subjects/test-subject/versions";
        Assert.assertEquals((String)"Subject must be prefixed", (Object)"/subjects/test-subject/versions/", (Object)this.contextFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testNoSubjectDefaultContext() {
        String path = "/contexts/:.:/subjects";
        Assert.assertEquals((String)"Subject must be prefixed", (Object)"/subjects/", (Object)this.contextFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testMissingLeadingDotInContext() {
        String path = "/contexts/test-ctx/subjects/test-subject/versions";
        Assert.assertEquals((String)"Subject must be prefixed", (Object)"/subjects/:.test-ctx:test-subject/versions/", (Object)this.contextFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testUriEndsWithSubject() {
        String path = "/contexts/.test-ctx/subjects/test-subject/";
        Assert.assertEquals((String)"Subject must be prefixed", (Object)"/subjects/:.test-ctx:test-subject/", (Object)this.contextFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testUriWithIds() {
        String path = "/contexts/.test-ctx/schemas/ids/1/";
        URI uri = this.contextFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap());
        Assert.assertEquals((String)"URI must not change", (Object)"/schemas/ids/1/", (Object)uri.getPath());
        Assert.assertEquals((String)"Query param must change", (Object)"subject=:.test-ctx:", (Object)uri.getQuery());
    }

    @Test
    public void testWildcardContextUnmodified() {
        String path = "/contexts/:.:/schemas/";
        UriBuilder uriBuilder = UriBuilder.fromPath((String)path);
        uriBuilder.queryParam("subjectPrefix", new Object[]{":*:"});
        MultivaluedHashMap queryParams = new MultivaluedHashMap();
        queryParams.put((Object)"subjectPrefix", Collections.singletonList(":*:"));
        URI uri = this.contextFilter.modifyUri(uriBuilder, path, (MultivaluedMap)queryParams);
        Assert.assertEquals((String)"URI must not change", (Object)"/schemas/", (Object)uri.getPath());
        Assert.assertEquals((String)"Query param must not change", (Object)"subjectPrefix=:*:", (Object)uri.getQuery());
    }

    @Test
    public void testUriWithEncodedSlash() {
        String path = "/contexts/.test-ctx/subjects/slash%2Fin%2Fmiddle/";
        Assert.assertEquals((String)"Subject must be prefixed", (Object)"/subjects/:.test-ctx:slash%2Fin%2Fmiddle/", (Object)this.contextFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getRawPath());
    }

    @Test
    public void testConfigUriWithSubject() {
        String path = "/contexts/.test-ctx/config/test-subject";
        Assert.assertEquals((String)"Subject must be prefixed", (Object)"/config/:.test-ctx:test-subject/", (Object)this.contextFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testConfigUriWithoutSubject() {
        String path = "/contexts/.test-ctx/config";
        Assert.assertEquals((String)"Wildcard must be prefixed", (Object)"/config/:.test-ctx:/", (Object)this.contextFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testUriWithoutModification() {
        String path = "/chc/live";
        Assert.assertEquals((String)"URI must not change", (Object)"/chc/live/", (Object)this.contextFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testModeUriWithSubject() {
        String path = "/contexts/.test-ctx/mode/test-subject";
        Assert.assertEquals((String)"Subject must be prefixed", (Object)"/mode/:.test-ctx:test-subject/", (Object)this.contextFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testModeUriWithoutSubject() {
        String path = "/contexts/.test-ctx/mode";
        Assert.assertEquals((String)"Mode must be prefixed", (Object)"/mode/:.test-ctx:/", (Object)this.contextFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testModeUriWithoutSubjectDefaultContext() {
        String path = "/contexts/:.:/mode";
        Assert.assertEquals((String)"Mode must not be prefixed", (Object)"/mode/", (Object)this.contextFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testKekPartOfUri() {
        String path = "/contexts/.test-ctx/dek-registry/v1/keks/test-kek";
        Assert.assertEquals((String)"Dek must be prefixed", (Object)"/dek-registry/v1/keks/:.test-ctx:test-kek/", (Object)this.contextFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testDekPartOfUri() {
        String path = "/contexts/.test-ctx/dek-registry/v1/keks/test-kek/deks/test-subject";
        Assert.assertEquals((String)"Dek must be prefixed", (Object)"/dek-registry/v1/keks/:.test-ctx:test-kek/deks/:.test-ctx:test-subject/", (Object)this.contextFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testConfigNotRoot() {
        String path = "/other/config/test";
        Assert.assertEquals((String)"Non-root config must be unmodified", (Object)"/other/config/test/", (Object)this.contextFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testInvalidContext() {
        String path = "/contexts/foo:bar/subjects";
        Assert.assertThrows((String)"Invalid context must be rejected", IllegalArgumentException.class, () -> this.contextFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }
}

