/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage.encoder;

import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.Metadata;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.encoder.MetadataEncoderService;
import io.kcache.Cache;
import io.kcache.utils.InMemoryCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class MetadataEncoderServiceTest {
    @Test
    public void testEncoding() throws Exception {
        KafkaSchemaRegistry schemaRegistry = (KafkaSchemaRegistry)Mockito.mock(KafkaSchemaRegistry.class);
        Properties props = new Properties();
        props.setProperty("metadata.encoder.secret", "mysecret");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        Mockito.when((Object)schemaRegistry.config()).thenReturn((Object)config);
        InMemoryCache encoders = new InMemoryCache();
        MetadataEncoderService encoderService = new MetadataEncoderService((SchemaRegistry)schemaRegistry, (Cache)encoders);
        encoderService.init();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("nonsensitive", "foo");
        properties.put("sensitive", "foo");
        io.confluent.kafka.schemaregistry.client.rest.entities.Metadata metadata = new io.confluent.kafka.schemaregistry.client.rest.entities.Metadata(null, properties, Collections.singleton("sensitive"));
        SchemaValue schema = new SchemaValue("mysubject", null, null, null, null, null, new Metadata(metadata), null, "true", false);
        encoderService.encodeMetadata(schema);
        Assert.assertEquals(schema.getMetadata().getProperties().get("nonsensitive"), (Object)"foo");
        Assert.assertNotEquals(schema.getMetadata().getProperties().get("sensitive"), (Object)"foo");
        Assert.assertNotNull(schema.getMetadata().getProperties().get("__enc__"));
        encoderService.decodeMetadata(schema);
        Assert.assertEquals(schema.getMetadata().getProperties().get("nonsensitive"), (Object)"foo");
        Assert.assertEquals(schema.getMetadata().getProperties().get("sensitive"), (Object)"foo");
        Assert.assertNull(schema.getMetadata().getProperties().get("__enc__"));
    }
}

