/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.storage.Rule;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RuleSet {
    private final List<Rule> migrationRules;
    private final List<Rule> domainRules;

    @JsonCreator
    public RuleSet(@JsonProperty(value="migrationRules") List<Rule> migrationRules, @JsonProperty(value="domainRules") List<Rule> domainRules) {
        this.migrationRules = migrationRules != null ? Collections.unmodifiableList(migrationRules) : Collections.emptyList();
        this.domainRules = domainRules != null ? Collections.unmodifiableList(domainRules) : Collections.emptyList();
    }

    public RuleSet(io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet ruleSet) {
        this.migrationRules = ruleSet.getMigrationRules().stream().map(Rule::new).collect(Collectors.toList());
        this.domainRules = ruleSet.getDomainRules().stream().map(Rule::new).collect(Collectors.toList());
    }

    public List<Rule> getMigrationRules() {
        return this.migrationRules;
    }

    public List<Rule> getDomainRules() {
        return this.domainRules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleSet ruleSet = (RuleSet)o;
        return Objects.equals(this.migrationRules, ruleSet.migrationRules) && Objects.equals(this.domainRules, ruleSet.domainRules);
    }

    public int hashCode() {
        return Objects.hash(this.migrationRules, this.domainRules);
    }

    public String toString() {
        return "Rules{migrationRules=" + this.migrationRules + ", domainRules=" + this.domainRules + '}';
    }

    public io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet toRuleSetEntity() {
        return new io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet(this.getMigrationRules().stream().map(Rule::toRuleEntity).collect(Collectors.toList()), this.getDomainRules().stream().map(Rule::toRuleEntity).collect(Collectors.toList()));
    }
}

