/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.metrics;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.utils.TestUtils;
import java.lang.management.ManagementFactory;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MetricsTest
extends ClusterTestHarness {
    public MetricsTest() {
        super(1, true);
    }

    @Test
    public void testLeaderFollowerMetric() throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName leaderFollowerMetricName = new ObjectName("kafka.schema.registry:type=master-slave-role");
        Assertions.assertEquals((Object)1.0, (Object)mBeanServer.getAttribute(leaderFollowerMetricName, "master-slave-role"));
    }

    @Test
    public void testSchemaCreatedCount() throws Exception {
        int i;
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName schemasCreated = new ObjectName("kafka.schema.registry:type=registered-count");
        ObjectName avroCreated = new ObjectName("kafka.schema.registry:type=avro-schemas-created");
        ObjectName schemasDeleted = new ObjectName("kafka.schema.registry:type=deleted-count");
        ObjectName avroDeleted = new ObjectName("kafka.schema.registry:type=avro-schemas-deleted");
        RestService service = this.restApp.restClient;
        String subject = "testTopic1";
        int schemaCount = 3;
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(schemaCount);
        int schemaIdCounter = 1;
        for (i = 0; i < schemaCount; ++i) {
            String schema = schemas.get(i);
            TestUtils.registerAndVerifySchema(service, schema, schemaIdCounter++, subject);
        }
        for (i = 0; i < schemaCount; ++i) {
            String schemaString = schemas.get(i);
            service.registerSchema(schemaString, subject);
        }
        Integer i2 = 1;
        while (i2 < schemaIdCounter) {
            Assertions.assertEquals((Integer)i2, (Integer)service.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, i2.toString()));
            Integer n = i2;
            i2 = i2 + 1;
        }
        Assertions.assertEquals((Object)schemaCount, (Object)mBeanServer.getAttribute(schemasCreated, "registered-count"));
        Assertions.assertEquals((Object)schemaCount, (Object)mBeanServer.getAttribute(avroCreated, "avro-schemas-created"));
        Assertions.assertEquals((Object)schemaCount, (Object)mBeanServer.getAttribute(schemasDeleted, "deleted-count"));
        Assertions.assertEquals((Object)schemaCount, (Object)mBeanServer.getAttribute(avroDeleted, "avro-schemas-deleted"));
    }

    @Test
    public void testApiCallMetrics() throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName apiSuccess = new ObjectName("kafka.schema.registry:type=api-success-count");
        ObjectName apiFailure = new ObjectName("kafka.schema.registry:type=api-failure-count");
        String subject = "testTopic1";
        int schemaCount = 3;
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(schemaCount);
        int schemaIdCounter = 1;
        for (int i = 0; i < schemaCount; ++i) {
            String schema = schemas.get(i);
            TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter++, subject);
        }
        Assertions.assertEquals((Object)((double)schemaCount * 2.0), (Object)mBeanServer.getAttribute(apiSuccess, "api-success-count"));
        Assertions.assertEquals((Object)0.0, (Object)mBeanServer.getAttribute(apiFailure, "api-failure-count"));
        try {
            this.restApp.restClient.getId(100);
            Assertions.fail((String)"Schema lookup with missing ID expected to fail");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((Object)1.0, (Object)mBeanServer.getAttribute(apiFailure, "api-failure-count"));
        }
    }
}

