/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Mode;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RestApiModeTest
extends ClusterTestHarness {
    private static String SCHEMA_STRING = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
    private static String SCHEMA2_STRING = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"int\",\"name\":\"f1\"}]}").canonicalString();
    private static String SCHEMA_WITH_DECIMAL = AvroUtils.parseSchema((String)"{\n    \"type\": \"record\",\n    \"name\": \"MyRecord\",\n    \"fields\": [\n        {\n            \"name\": \"field1\",\n            \"type\": [\n                \"null\",\n                {\n                    \"type\": \"bytes\",\n                    \"scale\": 4,\n                    \"precision\": 17,\n                    \"logicalType\": \"decimal\"\n                }\n            ],\n            \"default\": null\n        }\n    ]\n}").canonicalString();
    private static String SCHEMA_WITH_DECIMAL2 = AvroUtils.parseSchema((String)"{\n    \"type\": \"record\",\n    \"name\": \"MyRecord\",\n    \"fields\": [\n        {\n            \"name\": \"field1\",\n            \"type\": [\n                \"null\",\n                {\n                    \"type\": \"bytes\",\n                    \"logicalType\": \"decimal\",\n                    \"precision\": 17,\n                    \"scale\": 4\n                }\n            ],\n            \"default\": null\n        }\n    ]\n}").canonicalString();

    public RestApiModeTest() {
        super(1, true, CompatibilityLevel.BACKWARD.name);
    }

    @Test
    public void testReadOnlyMode() throws Exception {
        String subject = "testSubject";
        String mode = "READONLY";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        try {
            this.restApp.restClient.registerSchema(SCHEMA_STRING, subject);
            Assertions.fail((String)"Registering during read-only mode should fail");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)422, (int)e.getStatus(), (String)"Should get a constraint violation");
        }
    }

    @Test
    public void testReadWriteMode() throws Exception {
        String subject = "testSubject";
        String mode = "READWRITE";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        try {
            this.restApp.restClient.registerSchema(SCHEMA_STRING, subject, 1, 1);
            Assertions.fail((String)"Registering an incompatible schema should fail");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)422, (int)e.getStatus(), (String)"Should get a constraint violation");
        }
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject), (String)"Registering without id should succeed");
    }

    @Test
    public void testImportMode() throws Exception {
        String subject = "testSubject";
        String mode = "IMPORT";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject, 1, expectedIdSchema1), (String)"Registering with id should succeed");
    }

    @Test
    public void testImportModeWithoutId() throws Exception {
        String subject = "testSubject";
        String mode = "IMPORT";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        try {
            this.restApp.restClient.registerSchema(SCHEMA_STRING, subject);
            Assertions.fail((String)"Registering a schema without ID should fail");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)422, (int)e.getStatus(), (String)"Should get a constraint violation");
        }
    }

    @Test
    public void testClearMode() throws Exception {
        String mode = "READONLY";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        Assertions.assertEquals(null, (Object)this.restApp.restClient.setMode(null).getMode());
        Assertions.assertEquals((Object)"READWRITE", (Object)this.restApp.restClient.getMode().getMode());
    }

    @Test
    public void testInvalidImportMode() throws Exception {
        String subject = "testSubject";
        String mode = "IMPORT";
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject), (String)"Registering without id should succeed");
        try {
            this.restApp.restClient.setMode(mode).getMode();
            Assertions.fail((String)"Setting import mode should fail");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)422, (int)e.getStatus(), (String)"Should get a constraint violation");
        }
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode, subject, true).getMode());
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode, null, true).getMode());
    }

    @Test
    public void testRegisterSchemaWithNoIdAfterImport() throws Exception {
        String subject = "testSubject";
        String mode = "READWRITE";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        mode = "IMPORT";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject, 1, expectedIdSchema1), (String)"Registering with id should succeed");
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject), (String)"Registering without id should succeed");
    }

    @Test
    public void testRegisterSchemaWithDifferentIdAfterImport() throws Exception {
        String subject = "testSubject";
        String mode = "READWRITE";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject), (String)"Registering without id should succeed");
        this.restApp.restClient.deleteSubject(Collections.emptyMap(), subject);
        mode = "IMPORT";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        expectedIdSchema1 = 2;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject, 1, expectedIdSchema1), (String)"Registering with id should succeed");
    }

    @Test
    public void testRegisterSchemaWithSameIdAfterImport() throws Exception {
        String subject = "testSubject";
        String mode = "READWRITE";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject), (String)"Registering without id should succeed");
        this.restApp.restClient.deleteSubject(Collections.emptyMap(), subject);
        mode = "IMPORT";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject, 1, expectedIdSchema1), (String)"Registering with id should succeed");
        this.restApp.restClient.deleteSubject(Collections.emptyMap(), subject);
        expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject, 1, expectedIdSchema1), (String)"Registering with id should succeed");
        Assertions.assertEquals((Object)SCHEMA_STRING, (Object)this.restApp.restClient.getVersion(subject, 1).getSchema(), (String)"Getting schema by id should succeed");
    }

    @Test
    public void testRegisterSchemaWithSameIdButWithMetadataAfterImport() throws Exception {
        String subject = "testSubject";
        String mode = "READWRITE";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject), (String)"Registering without id should succeed");
        this.restApp.restClient.deleteSubject(Collections.emptyMap(), subject);
        mode = "IMPORT";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        expectedIdSchema1 = 1;
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(SCHEMA_STRING);
        request.setMetadata(new Metadata(null, (Map)ImmutableMap.of((Object)"foo", (Object)"bar"), null));
        request.setVersion(Integer.valueOf(1));
        request.setId(Integer.valueOf(expectedIdSchema1));
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(request, subject, false).getId(), (String)"Registering with id should succeed");
        Assertions.assertEquals((Object)SCHEMA_STRING, (Object)this.restApp.restClient.getVersion(subject, 1).getSchema(), (String)"Getting schema by id should succeed");
        this.restApp.restClient.deleteSubject(Collections.emptyMap(), subject);
        expectedIdSchema1 = 1;
        request = new RegisterSchemaRequest();
        request.setSchema(SCHEMA_STRING);
        request.setMetadata(new Metadata(null, (Map)ImmutableMap.of((Object)"foo", (Object)"bar"), null));
        request.setVersion(Integer.valueOf(1));
        request.setId(Integer.valueOf(expectedIdSchema1));
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(request, subject, false).getId(), (String)"Registering with id should succeed");
        Assertions.assertEquals((Object)SCHEMA_STRING, (Object)this.restApp.restClient.getVersion(subject, 1).getSchema(), (String)"Getting schema by id should succeed");
    }

    @Test
    public void testImportModeWithEquivalentSchemaDifferentId() throws Exception {
        String subject = "testSubject";
        String mode = "IMPORT";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        int expectedIdSchema1 = 100;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_WITH_DECIMAL, subject, 1, expectedIdSchema1), (String)"Registering with id should succeed");
        Assertions.assertEquals((Object)SCHEMA_WITH_DECIMAL, (Object)this.restApp.restClient.getVersion(subject, 1).getSchema(), (String)"Getting schema by id should succeed");
        expectedIdSchema1 = 200;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_WITH_DECIMAL2, subject, 2, expectedIdSchema1), (String)"Registering with id should succeed");
        Assertions.assertEquals((Object)SCHEMA_WITH_DECIMAL2, (Object)this.restApp.restClient.getVersion(subject, 2).getSchema(), (String)"Getting schema by id should succeed");
    }

    @Test
    public void testImportModeWithSameSchemaDifferentId() throws Exception {
        String subject = "testSubject";
        String mode = "IMPORT";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        int expectedIdSchema1 = 100;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_WITH_DECIMAL, subject, 1, expectedIdSchema1), (String)"Registering with id should succeed");
        Assertions.assertEquals((Object)SCHEMA_WITH_DECIMAL, (Object)this.restApp.restClient.getVersion(subject, 1).getSchema(), (String)"Getting schema by id should succeed");
        expectedIdSchema1 = 200;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_WITH_DECIMAL, subject, 2, expectedIdSchema1), (String)"Registering with id should succeed");
        Assertions.assertEquals((Object)SCHEMA_WITH_DECIMAL, (Object)this.restApp.restClient.getVersion(subject, 2).getSchema(), (String)"Getting schema by id should succeed");
    }

    @Test
    public void testImportModeWithSameSchemaDifferentIdAndSubject() throws Exception {
        String subject = "testSubject";
        String subject2 = "testSubject2";
        String mode = "IMPORT";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        int expectedIdSchema1 = 100;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_WITH_DECIMAL, subject, 1, expectedIdSchema1));
        Assertions.assertEquals((Object)SCHEMA_WITH_DECIMAL, (Object)this.restApp.restClient.getVersion(subject, 1).getSchema());
        int versionOfRegisteredSubject1 = this.restApp.restClient.lookUpSubjectVersion(SCHEMA_WITH_DECIMAL, subject).getVersion();
        Assertions.assertEquals((int)1, (int)versionOfRegisteredSubject1);
        expectedIdSchema1 = 200;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_WITH_DECIMAL, subject2, 1, expectedIdSchema1));
        Assertions.assertEquals((Object)SCHEMA_WITH_DECIMAL, (Object)this.restApp.restClient.getVersion(subject2, 1).getSchema());
        versionOfRegisteredSubject1 = this.restApp.restClient.lookUpSubjectVersion(SCHEMA_WITH_DECIMAL, subject).getVersion();
        Assertions.assertEquals((int)1, (int)versionOfRegisteredSubject1);
        int versionOfRegisteredSubject2 = this.restApp.restClient.lookUpSubjectVersion(SCHEMA_WITH_DECIMAL, subject2).getVersion();
        Assertions.assertEquals((int)1, (int)versionOfRegisteredSubject2);
    }

    @Test
    public void testRegisterIncompatibleSchemaDuringImport() throws Exception {
        String subject = "testSubject";
        String mode = "READWRITE";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject), (String)"Registering without id should succeed");
        this.restApp.restClient.deleteSubject(Collections.emptyMap(), subject);
        mode = "IMPORT";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject, 1, expectedIdSchema1), (String)"Registering with id should succeed");
        expectedIdSchema1 = 2;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(SCHEMA2_STRING, subject, 2, expectedIdSchema1), (String)"Registering with id should succeed");
        Assertions.assertEquals((Object)SCHEMA2_STRING, (Object)this.restApp.restClient.getVersion(subject, 2).getSchema(), (String)"Getting schema by id should succeed");
    }

    @Test
    public void testGlobalContextWithReadOnlyMode() throws Exception {
        String subject = "testSubject";
        String mode = "READONLY";
        Assertions.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode, ":.__GLOBAL:").getMode());
        Mode mode1 = this.restApp.restClient.getMode(null, true);
        Assertions.assertEquals((Object)"readonly", (Object)mode1.getMode().toLowerCase());
        try {
            this.restApp.restClient.registerSchema(SCHEMA_STRING, subject);
            Assertions.fail((String)"Registering during read-only mode should fail");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)422, (int)e.getStatus(), (String)"Should get a constraint violation");
        }
    }
}

