/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.rest.exceptions.RestIncompatibleSchemaException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RestApiTransitiveCompatibilityTest
extends ClusterTestHarness {
    String baseSchema = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
    String baseSchemaWithColumnWithDefault = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}]}").canonicalString();
    String baseSchemaWithColumnNoDefault = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}").canonicalString();

    public RestApiTransitiveCompatibilityTest() {
        super(1, true, CompatibilityLevel.BACKWARD_TRANSITIVE.name);
    }

    @Test
    public void testCompatibility() throws Exception {
        String subject = "testSubject";
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(this.baseSchema, subject), (String)"Registering should succeed");
        int expectedIdSchema2 = 2;
        Assertions.assertEquals((int)expectedIdSchema2, (int)this.restApp.restClient.registerSchema(this.baseSchemaWithColumnWithDefault, subject), (String)"Registering a compatible schema should succeed");
        String incompatibleSchemaString = this.baseSchemaWithColumnNoDefault;
        try {
            this.restApp.restClient.registerSchema(incompatibleSchemaString, subject);
            Assertions.fail((String)"Registering an incompatible schema should fail");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)RestIncompatibleSchemaException.DEFAULT_ERROR_CODE, (int)e.getStatus(), (String)"Should get a conflict status");
        }
    }

    @Test
    public void validateTransitiveEffect() throws Exception {
        String subject = "testSubject";
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(this.baseSchemaWithColumnWithDefault, subject), (String)"Registering should succeed");
        int expectedIdSchema2 = 2;
        Assertions.assertEquals((int)expectedIdSchema2, (int)this.restApp.restClient.registerSchema(this.baseSchemaWithColumnNoDefault, subject), (String)"Registering a compatible schema should succeed");
    }
}

