/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.utils;

import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaRegistryDeployment;
import io.confluent.kafka.schemaregistry.utils.Props;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class PropsTest {
    @Test
    public void testGetSchemaRegistryDeploymentWithNullProperty() {
        HashMap props = new HashMap();
        SchemaRegistryDeployment result = Props.getSchemaRegistryDeployment(props);
        Assert.assertNotNull((String)"Should return default SchemaRegistryDeployment when property is not present", (Object)result);
        Assert.assertEquals((String)"Should contain empty list as default", (long)0L, (long)result.getAttributes().size());
    }

    @Test
    public void testGetSchemaRegistryDeploymentWithExplicitNullProperty() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("schema.registry.metadata.deployment.attributes", null);
        SchemaRegistryDeployment result = Props.getSchemaRegistryDeployment(props);
        Assert.assertNotNull((String)"Should return default SchemaRegistryDeployment when property is explicitly null", (Object)result);
        Assert.assertEquals((String)"Should contain empty list as default", (long)0L, (long)result.getAttributes().size());
    }

    @Test
    public void testGetSchemaRegistryDeploymentWithValidStringList() {
        HashMap<String, List<String>> props = new HashMap<String, List<String>>();
        List<String> attributes = Arrays.asList("confluent", "enterprise");
        props.put("schema.registry.metadata.deployment.attributes", attributes);
        SchemaRegistryDeployment result = Props.getSchemaRegistryDeployment(props);
        Assert.assertNotNull((String)"Should return SchemaRegistryDeployment for valid string list", (Object)result);
        Assert.assertEquals((String)"Should contain the same attributes", attributes, (Object)result.getAttributes());
    }

    @Test
    public void testGetSchemaRegistryDeploymentWithSingleStringInList() {
        HashMap<String, List<String>> props = new HashMap<String, List<String>>();
        List<String> attributes = Arrays.asList("opensource");
        props.put("schema.registry.metadata.deployment.attributes", attributes);
        SchemaRegistryDeployment result = Props.getSchemaRegistryDeployment(props);
        Assert.assertNotNull((String)"Should return SchemaRegistryDeployment for single string list", (Object)result);
        Assert.assertEquals((String)"Should contain the single attribute", attributes, (Object)result.getAttributes());
    }

    @Test
    public void testGetSchemaRegistryDeploymentWithEmptyList() {
        HashMap props = new HashMap();
        ArrayList attributes = new ArrayList();
        props.put("schema.registry.metadata.deployment.attributes", attributes);
        SchemaRegistryDeployment result = Props.getSchemaRegistryDeployment(props);
        Assert.assertNotNull((String)"Should return SchemaRegistryDeployment for empty list", (Object)result);
        Assert.assertEquals((String)"Should contain empty list", attributes, (Object)result.getAttributes());
    }

    @Test
    public void testGetSchemaRegistryDeploymentWithListContainingNulls() {
        HashMap<String, List<Object>> props = new HashMap<String, List<Object>>();
        List<Object> attributes = Arrays.asList("confluent", null, "enterprise");
        props.put("schema.registry.metadata.deployment.attributes", attributes);
        Assert.assertThrows((String)"Should throw NullPointerException when list contains null", NullPointerException.class, () -> Props.getSchemaRegistryDeployment((Map)props));
    }

    @Test
    public void testGetSchemaRegistryDeploymentWithIntegerInList() {
        HashMap<String, List<Object>> props = new HashMap<String, List<Object>>();
        List<Object> attributes = Arrays.asList("confluent", 123, "enterprise");
        props.put("schema.registry.metadata.deployment.attributes", attributes);
        SchemaRegistryDeployment result = Props.getSchemaRegistryDeployment(props);
        Assert.assertNotNull((String)"Should return SchemaRegistryDeployment for list with integer", (Object)result);
        List<String> expected = Arrays.asList("confluent", "123", "enterprise");
        Assert.assertEquals((String)"Should convert integer to string", expected, (Object)result.getAttributes());
    }

    @Test
    public void testGetSchemaRegistryDeploymentWithBooleanInList() {
        HashMap<String, List<Object>> props = new HashMap<String, List<Object>>();
        List<Object> attributes = Arrays.asList("confluent", true, "enterprise");
        props.put("schema.registry.metadata.deployment.attributes", attributes);
        SchemaRegistryDeployment result = Props.getSchemaRegistryDeployment(props);
        Assert.assertNotNull((String)"Should return SchemaRegistryDeployment for list with boolean", (Object)result);
        List<String> expected = Arrays.asList("confluent", "true", "enterprise");
        Assert.assertEquals((String)"Should convert boolean to string", expected, (Object)result.getAttributes());
    }

    @Test
    public void testGetSchemaRegistryDeploymentWithNonListProperty() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("schema.registry.metadata.deployment.attributes", "not-a-list");
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows((String)"Should throw IllegalArgumentException for non-list property", IllegalArgumentException.class, () -> Props.getSchemaRegistryDeployment((Map)props));
        Assert.assertEquals((String)"Should have proper error message", (Object)"Invalid schema registry deployment: not-a-list", (Object)exception.getMessage());
    }

    @Test
    public void testGetSchemaRegistryDeploymentWithIntegerProperty() {
        HashMap<String, Integer> props = new HashMap<String, Integer>();
        props.put("schema.registry.metadata.deployment.attributes", 42);
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows((String)"Should throw IllegalArgumentException for integer property", IllegalArgumentException.class, () -> Props.getSchemaRegistryDeployment((Map)props));
        Assert.assertEquals((String)"Should have proper error message", (Object)"Invalid schema registry deployment: 42", (Object)exception.getMessage());
    }

    @Test
    public void testGetSchemaRegistryDeploymentWithBooleanProperty() {
        HashMap<String, Boolean> props = new HashMap<String, Boolean>();
        props.put("schema.registry.metadata.deployment.attributes", false);
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows((String)"Should throw IllegalArgumentException for boolean property", IllegalArgumentException.class, () -> Props.getSchemaRegistryDeployment((Map)props));
        Assert.assertEquals((String)"Should have proper error message", (Object)"Invalid schema registry deployment: false", (Object)exception.getMessage());
    }

    @Test
    public void testPropertyConstantValue() {
        Assert.assertEquals((String)"Property constant should have correct value", (Object)"schema.registry.metadata.deployment.attributes", (Object)"schema.registry.metadata.deployment.attributes");
    }

    @Test
    public void testGetSchemaRegistryDeploymentWithMixedCaseStrings() {
        HashMap<String, List<String>> props = new HashMap<String, List<String>>();
        List<String> attributes = Arrays.asList("CONFLUENT", "Enterprise", "opensource");
        props.put("schema.registry.metadata.deployment.attributes", attributes);
        SchemaRegistryDeployment result = Props.getSchemaRegistryDeployment(props);
        Assert.assertNotNull((String)"Should return SchemaRegistryDeployment for mixed case strings", (Object)result);
        List<String> expected = Arrays.asList("CONFLUENT", "Enterprise", "opensource");
        Assert.assertEquals((String)"Should convert to lowercase", expected, (Object)result.getAttributes());
    }

    @Test
    public void testGetSchemaRegistryDeploymentWithEmptyStrings() {
        HashMap<String, List<String>> props = new HashMap<String, List<String>>();
        List<String> attributes = Arrays.asList("confluent", "", "enterprise");
        props.put("schema.registry.metadata.deployment.attributes", attributes);
        SchemaRegistryDeployment result = Props.getSchemaRegistryDeployment(props);
        Assert.assertNotNull((String)"Should return SchemaRegistryDeployment for list with empty strings", (Object)result);
        List<String> expected = Arrays.asList("confluent", "", "enterprise");
        Assert.assertEquals((String)"Should preserve empty strings after trimming and lowercasing", expected, (Object)result.getAttributes());
    }

    @Test
    public void testGetSchemaRegistryDeploymentWithWhitespaceStrings() {
        HashMap<String, List<String>> props = new HashMap<String, List<String>>();
        List<String> attributes = Arrays.asList("confluent", "   ", "enterprise");
        props.put("schema.registry.metadata.deployment.attributes", attributes);
        SchemaRegistryDeployment result = Props.getSchemaRegistryDeployment(props);
        Assert.assertNotNull((String)"Should return SchemaRegistryDeployment for list with whitespace strings", (Object)result);
        List<String> expected = Arrays.asList("confluent", "", "enterprise");
        Assert.assertEquals((String)"Should trim whitespace", expected, (Object)result.getAttributes());
    }

    @Test
    public void testGetSchemaRegistryDeploymentWithComplexObjects() {
        HashMap<String, List<Object>> props = new HashMap<String, List<Object>>();
        List<Object> attributes = Arrays.asList("confluent", 42, true, 3.14);
        props.put("schema.registry.metadata.deployment.attributes", attributes);
        SchemaRegistryDeployment result = Props.getSchemaRegistryDeployment(props);
        Assert.assertNotNull((String)"Should return SchemaRegistryDeployment for list with mixed types", (Object)result);
        List<String> expected = Arrays.asList("confluent", "42", "true", "3.14");
        Assert.assertEquals((String)"Should convert all types to lowercase strings", expected, (Object)result.getAttributes());
    }

    @Test
    public void testGetSchemaRegistryDeploymentTrims() {
        HashMap<String, List<String>> props = new HashMap<String, List<String>>();
        List<String> attributes = Arrays.asList("  CONFLUENT  ", "Enterprise ", " opensource");
        props.put("schema.registry.metadata.deployment.attributes", attributes);
        SchemaRegistryDeployment result = Props.getSchemaRegistryDeployment(props);
        Assert.assertNotNull((String)"Should return SchemaRegistryDeployment", (Object)result);
        List<String> expected = Arrays.asList("CONFLUENT", "Enterprise", "opensource");
        Assert.assertEquals((String)"Should trim whitespace and convert to lowercase", expected, (Object)result.getAttributes());
    }
}

