/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Collections;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Metadata {
    @JsonPropertyOrder(alphabetic=true)
    private final SortedMap<String, SortedSet<String>> tags;
    @JsonPropertyOrder(alphabetic=true)
    private final SortedMap<String, String> properties;
    private final SortedSet<String> sensitive;

    @JsonCreator
    public Metadata(@JsonProperty(value="tags") SortedMap<String, SortedSet<String>> tags, @JsonProperty(value="properties") SortedMap<String, String> properties, @JsonProperty(value="sensitive") SortedSet<String> sensitive) {
        this.tags = tags != null ? Collections.unmodifiableSortedMap(tags) : Collections.emptySortedMap();
        this.properties = properties != null ? Collections.unmodifiableSortedMap(properties) : Collections.emptySortedMap();
        this.sensitive = sensitive != null ? Collections.unmodifiableSortedSet(sensitive) : Collections.emptySortedSet();
    }

    public Metadata(io.confluent.kafka.schemaregistry.client.rest.entities.Metadata metadata) {
        this.tags = Collections.unmodifiableSortedMap(metadata.getTags());
        this.properties = Collections.unmodifiableSortedMap(metadata.getProperties());
        this.sensitive = Collections.unmodifiableSortedSet(metadata.getSensitive());
    }

    public SortedMap<String, SortedSet<String>> getTags() {
        return this.tags;
    }

    public SortedMap<String, String> getProperties() {
        return this.properties;
    }

    public SortedSet<String> getSensitive() {
        return this.sensitive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata metadata = (Metadata)o;
        return Objects.equals(this.tags, metadata.tags) && Objects.equals(this.properties, metadata.properties) && Objects.equals(this.sensitive, metadata.sensitive);
    }

    public int hashCode() {
        return Objects.hash(this.tags, this.properties, this.sensitive);
    }

    public String toString() {
        return "Metadata{tags=" + String.valueOf(this.tags) + ", properties=" + String.valueOf(this.properties) + ", sensitive=" + String.valueOf(this.sensitive) + "}";
    }

    public io.confluent.kafka.schemaregistry.client.rest.entities.Metadata toMetadataEntity() {
        return new io.confluent.kafka.schemaregistry.client.rest.entities.Metadata(this.getTags(), this.getProperties(), this.getSensitive());
    }
}

