/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import com.google.common.collect.ImmutableList;
import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.ExtendedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.rest.exceptions.RestIncompatibleSchemaException;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.RuleSetHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.avro.SchemaCompatibility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RestApiCompatibilityTest
extends ClusterTestHarness {
    public RestApiCompatibilityTest() {
        super(1, true, CompatibilityLevel.BACKWARD.name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ((KafkaSchemaRegistry)this.restApp.schemaRegistry()).setRuleSetHandler(new RuleSetHandler(){

            public void handle(String subject, ConfigUpdateRequest request) {
            }

            public void handle(String subject, boolean normalize, RegisterSchemaRequest request) {
            }

            public io.confluent.kafka.schemaregistry.storage.RuleSet transform(RuleSet ruleSet) {
                return ruleSet != null ? new io.confluent.kafka.schemaregistry.storage.RuleSet(ruleSet) : null;
            }
        });
    }

    @Test
    public void testCompatibility() throws Exception {
        String subject = "testSubject";
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(schemaString1, subject), (String)"Registering should succeed");
        String incompatibleSchemaString = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}").canonicalString();
        try {
            this.restApp.restClient.registerSchema(incompatibleSchemaString, subject);
            Assertions.fail((String)"Registering an incompatible schema should fail");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)RestIncompatibleSchemaException.DEFAULT_ERROR_CODE, (int)e.getStatus(), (String)"Should get a conflict status");
            Assertions.assertTrue((boolean)e.getMessage().contains(SchemaCompatibility.SchemaIncompatibilityType.READER_FIELD_MISSING_DEFAULT_VALUE.toString()), (String)"Verifying error message verbosity");
        }
        String nonAvroSchemaString = "non-avro schema string";
        try {
            this.restApp.restClient.registerSchema(nonAvroSchemaString, subject);
            Assertions.fail((String)"Registering a non-avro schema should fail");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)42201, (int)e.getErrorCode(), (String)"Should get a bad request status");
        }
        String schemaString2 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}]}").canonicalString();
        int expectedIdSchema2 = 2;
        Assertions.assertEquals((int)expectedIdSchema2, (int)this.restApp.restClient.registerSchema(schemaString2, subject), (String)"Registering a compatible schema should succeed");
    }

    @Test
    public void testCompatibilityLevelChangeToNone() throws Exception {
        String subject = "testSubject";
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(schemaString1, subject), (String)"Registering should succeed");
        String incompatibleSchemaString = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}").canonicalString();
        try {
            this.restApp.restClient.registerSchema(incompatibleSchemaString, subject);
            Assertions.fail((String)"Registering an incompatible schema should fail");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)RestIncompatibleSchemaException.DEFAULT_ERROR_CODE, (int)e.getStatus(), (String)"Should get a conflict status");
        }
        Assertions.assertEquals((Object)CompatibilityLevel.NONE.name, (Object)this.restApp.restClient.updateCompatibility(CompatibilityLevel.NONE.name, null).getCompatibilityLevel(), (String)"Changing compatibility level should succeed");
        try {
            this.restApp.restClient.registerSchema(incompatibleSchemaString, subject);
        }
        catch (RestClientException e) {
            Assertions.fail((String)"Registering an incompatible schema should succeed after bumping down the compatibility level to none");
        }
    }

    @Test
    public void testCompatibilityLevelChangeToBackward() throws Exception {
        String subject = "testSubject";
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(schemaString1, subject), (String)"Registering should succeed");
        Assertions.assertEquals((Object)new Config(CompatibilityLevel.BACKWARD.name), (Object)this.restApp.restClient.getConfig(null), (String)"Default compatibility level should be backward");
        Assertions.assertEquals((Object)CompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.updateCompatibility(CompatibilityLevel.FORWARD.name, null).getCompatibilityLevel(), (String)"Changing compatibility level should succeed");
        Assertions.assertEquals((Object)new Config(CompatibilityLevel.FORWARD.name), (Object)this.restApp.restClient.getConfig(null), (String)"New compatibility level should be forward");
        String schemaString2 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}").canonicalString();
        int expectedIdSchema2 = 2;
        Assertions.assertEquals((int)expectedIdSchema2, (int)this.restApp.restClient.registerSchema(schemaString2, subject), (String)"Registering should succeed");
        Assertions.assertEquals((Object)CompatibilityLevel.BACKWARD.name, (Object)this.restApp.restClient.updateCompatibility(CompatibilityLevel.BACKWARD.name, null).getCompatibilityLevel(), (String)"Changing compatibility level should succeed");
        Assertions.assertEquals((Object)new Config(CompatibilityLevel.BACKWARD.name), (Object)this.restApp.restClient.getConfig(null), (String)"Updated compatibility level should be backward");
        String schemaString3 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}, {\"type\":\"string\",\"name\":\"f3\"}]}").canonicalString();
        try {
            this.restApp.restClient.registerSchema(schemaString3, subject);
            Assertions.fail((String)"Registering a forward compatible schema should fail");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)RestIncompatibleSchemaException.DEFAULT_ERROR_CODE, (int)e.getStatus(), (String)"Should get a conflict status");
        }
        String schemaString4 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}, {\"type\":\"string\",\"name\":\"f3\", \"default\": \"foo\"}]}").canonicalString();
        int expectedIdSchema4 = 3;
        Assertions.assertEquals((int)expectedIdSchema4, (int)this.restApp.restClient.registerSchema(schemaString4, subject), (String)"Registering should succeed with backwards compatible schema");
    }

    @Test
    public void testCompatibilityGroup() throws Exception {
        String subject = "testSubject";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}");
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setCompatibilityGroup("application.version");
        config.setValidateFields(Boolean.valueOf(false));
        Assertions.assertEquals((Object)config, (Object)this.restApp.restClient.updateConfig(config, null), (String)"Adding compatibility group should succeed");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("application.version", "1");
        Metadata metadata1 = new Metadata(null, properties, null);
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)schema1);
        request1.setMetadata(metadata1);
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(request1, subject, false).getId(), (String)"Registering should succeed");
        Assertions.assertEquals((Object)CompatibilityLevel.BACKWARD.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel(), (String)"Default compatibility level should be backward");
        AvroSchema schema2 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}");
        RegisterSchemaRequest request2 = new RegisterSchemaRequest((ParsedSchema)schema2);
        try {
            this.restApp.restClient.registerSchema(request2, subject, false);
            Assertions.fail((String)"Registering a forward compatible schema should fail");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)RestIncompatibleSchemaException.DEFAULT_ERROR_CODE, (int)e.getStatus(), (String)"Should get a conflict status");
        }
        properties = new HashMap();
        properties.put("application.version", "2");
        Metadata metadata2 = new Metadata(null, properties, null);
        request2.setMetadata(metadata2);
        int expectedIdSchema2 = 2;
        Assertions.assertEquals((int)expectedIdSchema2, (int)this.restApp.restClient.registerSchema(request2, subject, false).getId(), (String)"Registering should succeed");
    }

    @Test
    public void testAddCompatibilityGroup() throws Exception {
        String subject = "testSubject";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}");
        HashMap<String, String> properties = new HashMap<String, String>();
        Metadata metadata1 = new Metadata(null, properties, null);
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)schema1);
        request1.setMetadata(metadata1);
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(request1, subject, false).getId(), (String)"Registering should succeed");
        Assertions.assertEquals((Object)CompatibilityLevel.BACKWARD.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel(), (String)"Default compatibility level should be backward");
        AvroSchema schema2 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}");
        RegisterSchemaRequest request2 = new RegisterSchemaRequest((ParsedSchema)schema2);
        try {
            this.restApp.restClient.registerSchema(request2, subject, false);
            Assertions.fail((String)"Registering a forward compatible schema should fail");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)RestIncompatibleSchemaException.DEFAULT_ERROR_CODE, (int)e.getStatus(), (String)"Should get a conflict status");
        }
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setCompatibilityGroup("application.version");
        config.setValidateFields(Boolean.valueOf(false));
        Assertions.assertEquals((Object)config, (Object)this.restApp.restClient.updateConfig(config, null), (String)"Adding compatibility group should succeed");
        properties = new HashMap();
        properties.put("application.version", "2");
        Metadata metadata2 = new Metadata(null, properties, null);
        request2.setMetadata(metadata2);
        int expectedIdSchema2 = 2;
        Assertions.assertEquals((int)expectedIdSchema2, (int)this.restApp.restClient.registerSchema(request2, subject, false).getId(), (String)"Registering should succeed");
        AvroSchema schema3 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":[\"null\", \"int\"],\"name\":\"f2\",\"default\":null}]}");
        properties = new HashMap();
        Metadata metadata3 = new Metadata(null, properties, null);
        RegisterSchemaRequest request3 = new RegisterSchemaRequest((ParsedSchema)schema3);
        request3.setMetadata(metadata3);
        int expectedIdSchema3 = 3;
        Assertions.assertEquals((int)expectedIdSchema3, (int)this.restApp.restClient.registerSchema(request3, subject, false).getId(), (String)"Registering should succeed");
    }

    @Test
    public void testClearCompatibilityGroup() throws Exception {
        String subject = "testSubject";
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setCompatibilityGroup("application.version");
        config.setValidateFields(Boolean.valueOf(true));
        Assertions.assertEquals((Object)config, (Object)this.restApp.restClient.updateConfig(config, null));
        ConfigUpdateRequest expectedConfig = new ConfigUpdateRequest();
        expectedConfig.setValidateFields(Boolean.valueOf(true));
        ConfigUpdateRequest newConfig = new ConfigUpdateRequest();
        newConfig.setCompatibilityGroup(Optional.empty());
        Assertions.assertEquals((Object)expectedConfig, (Object)this.restApp.restClient.updateConfig(newConfig, null));
    }

    @Test
    public void testConfigMetadata() throws Exception {
        String subject = "testSubject";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("configKey", "configValue");
        Metadata metadata = new Metadata(null, properties, null);
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setDefaultMetadata(metadata);
        config.setValidateFields(Boolean.valueOf(false));
        Assertions.assertEquals((Object)config, (Object)this.restApp.restClient.updateConfig(config, null), (String)"Adding config with initial metadata should succeed");
        properties = new HashMap();
        properties.put("subjectKey", "subjectValue");
        Metadata metadata1 = new Metadata(null, properties, null);
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)schema1);
        request1.setMetadata(metadata1);
        int expectedIdSchema1 = 1;
        RegisterSchemaResponse response = this.restApp.restClient.registerSchema(request1, subject, false);
        Assertions.assertEquals((int)expectedIdSchema1, (int)response.getId(), (String)"Registering should succeed");
        Metadata metadata2 = response.getMetadata();
        Assertions.assertEquals((Object)"configValue", metadata2.getProperties().get("configKey"));
        Assertions.assertEquals((Object)"subjectValue", metadata2.getProperties().get("subjectKey"));
        Assertions.assertEquals((Integer)response.getVersion(), (Integer)this.restApp.restClient.lookUpSubjectVersion(new RegisterSchemaRequest(new Schema(subject, response)), subject, false, false).getVersion(), (String)"Version should match");
        Assertions.assertEquals((Object)CompatibilityLevel.BACKWARD.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel(), (String)"Default compatibility level should be backward");
        Assertions.assertEquals((Object)CompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.updateCompatibility(CompatibilityLevel.FORWARD.name, null).getCompatibilityLevel(), (String)"Changing compatibility level should succeed");
        Assertions.assertEquals((Object)CompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel(), (String)"New compatibility level should be forward");
        AvroSchema schema2 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}");
        RegisterSchemaRequest request2 = new RegisterSchemaRequest((ParsedSchema)schema2);
        int expectedIdSchema2 = 2;
        response = this.restApp.restClient.registerSchema(request2, subject, false);
        Assertions.assertEquals((int)expectedIdSchema2, (int)response.getId(), (String)"Registering should succeed");
        metadata2 = response.getMetadata();
        Assertions.assertEquals((Object)"configValue", metadata2.getProperties().get("configKey"));
        Assertions.assertEquals((Object)"subjectValue", metadata2.getProperties().get("subjectKey"));
        Assertions.assertEquals((Integer)response.getVersion(), (Integer)this.restApp.restClient.lookUpSubjectVersion(new RegisterSchemaRequest(new Schema(subject, response)), subject, false, false).getVersion(), (String)"Version should match");
        SchemaString schemaString = this.restApp.restClient.getId(expectedIdSchema2, subject);
        metadata2 = schemaString.getMetadata();
        Assertions.assertEquals((Object)"configValue", metadata2.getProperties().get("configKey"));
        Assertions.assertEquals((Object)"subjectValue", metadata2.getProperties().get("subjectKey"));
        response = this.restApp.restClient.registerSchema(request2, subject, false);
        Assertions.assertEquals((int)expectedIdSchema2, (int)response.getId(), (String)"Registering should succeed");
        metadata2 = response.getMetadata();
        Assertions.assertEquals((Object)"configValue", metadata2.getProperties().get("configKey"));
        Assertions.assertEquals((Object)"subjectValue", metadata2.getProperties().get("subjectKey"));
        AvroSchema schema3 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}, {\"type\":\"string\",\"name\":\"f3\"}]}");
        properties = new HashMap();
        properties.put("newSubjectKey", "newSubjectValue");
        Metadata metadata3 = new Metadata(null, properties, null);
        RegisterSchemaRequest request3 = new RegisterSchemaRequest((ParsedSchema)schema3);
        request3.setMetadata(metadata3);
        int expectedIdSchema3 = 3;
        response = this.restApp.restClient.registerSchema(request3, subject, false);
        Assertions.assertEquals((int)expectedIdSchema3, (int)response.getId(), (String)"Registering should succeed");
        Metadata metadata4 = response.getMetadata();
        Assertions.assertEquals((Object)"configValue", metadata4.getProperties().get("configKey"));
        Assertions.assertNull(metadata4.getProperties().get("subjectKey"));
        Assertions.assertEquals((Object)"newSubjectValue", metadata4.getProperties().get("newSubjectKey"));
        Assertions.assertEquals((Integer)response.getVersion(), (Integer)this.restApp.restClient.lookUpSubjectVersion(new RegisterSchemaRequest(new Schema(subject, response)), subject, false, false).getVersion(), (String)"Version should match");
        schemaString = this.restApp.restClient.getId(expectedIdSchema3, subject);
        metadata4 = schemaString.getMetadata();
        Assertions.assertEquals((Object)"configValue", metadata4.getProperties().get("configKey"));
        Assertions.assertNull(metadata4.getProperties().get("subjectKey"));
        Assertions.assertEquals((Object)"newSubjectValue", metadata4.getProperties().get("newSubjectKey"));
    }

    @Test
    public void testConfigRuleSet() throws Exception {
        String subject = "testSubject";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}");
        Rule r1 = new Rule("foo", null, null, RuleMode.UPGRADE, "IGNORE", null, null, null, null, null, false);
        List<Rule> rules = Collections.singletonList(r1);
        RuleSet ruleSet = new RuleSet(rules, null);
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setDefaultRuleSet(ruleSet);
        config.setValidateFields(Boolean.valueOf(false));
        Assertions.assertEquals((Object)config, (Object)this.restApp.restClient.updateConfig(config, null), (String)"Adding config with initial ruleSet should succeed");
        Rule r2 = new Rule("bar", null, null, RuleMode.UPGRADE, "type1", null, null, null, null, null, false);
        rules = Collections.singletonList(r2);
        ruleSet = new RuleSet(rules, null);
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)schema1);
        request1.setRuleSet(ruleSet);
        int expectedIdSchema1 = 1;
        RegisterSchemaResponse response = this.restApp.restClient.registerSchema(request1, subject, false);
        Assertions.assertEquals((int)expectedIdSchema1, (int)response.getId(), (String)"Registering should succeed");
        RuleSet ruleSet2 = response.getRuleSet();
        Assertions.assertEquals((Object)"foo", (Object)((Rule)ruleSet2.getMigrationRules().get(0)).getName());
        Assertions.assertEquals((Object)"bar", (Object)((Rule)ruleSet2.getMigrationRules().get(1)).getName());
        Assertions.assertEquals((Integer)response.getVersion(), (Integer)this.restApp.restClient.lookUpSubjectVersion(new RegisterSchemaRequest(new Schema(subject, response)), subject, false, false).getVersion(), (String)"Version should match");
        List schemas = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, null, false, false, "type1", null, null);
        Assertions.assertEquals((int)1, (int)schemas.size());
        schemas = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, null, false, true, "type1", null, null);
        Assertions.assertEquals((int)1, (int)schemas.size());
        Assertions.assertEquals((Object)CompatibilityLevel.BACKWARD.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel(), (String)"Default compatibility level should be backward");
        Assertions.assertEquals((Object)CompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.updateCompatibility(CompatibilityLevel.FORWARD.name, null).getCompatibilityLevel(), (String)"Changing compatibility level should succeed");
        Assertions.assertEquals((Object)CompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel(), (String)"New compatibility level should be forward");
        AvroSchema schema2 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}");
        RegisterSchemaRequest request2 = new RegisterSchemaRequest((ParsedSchema)schema2);
        int expectedIdSchema2 = 2;
        response = this.restApp.restClient.registerSchema(request2, subject, false);
        Assertions.assertEquals((int)expectedIdSchema2, (int)response.getId(), (String)"Registering should succeed");
        ruleSet2 = response.getRuleSet();
        Assertions.assertEquals((Object)"foo", (Object)((Rule)ruleSet2.getMigrationRules().get(0)).getName());
        Assertions.assertEquals((Object)"bar", (Object)((Rule)ruleSet2.getMigrationRules().get(1)).getName());
        Assertions.assertEquals((Integer)response.getVersion(), (Integer)this.restApp.restClient.lookUpSubjectVersion(new RegisterSchemaRequest(new Schema(subject, response)), subject, false, false).getVersion(), (String)"Version should match");
        SchemaString schemaString = this.restApp.restClient.getId(expectedIdSchema2, subject);
        ruleSet2 = schemaString.getRuleSet();
        Assertions.assertEquals((Object)"foo", (Object)((Rule)ruleSet2.getMigrationRules().get(0)).getName());
        Assertions.assertEquals((Object)"bar", (Object)((Rule)ruleSet2.getMigrationRules().get(1)).getName());
        schemas = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, null, false, false, "type1", null, null);
        Assertions.assertEquals((int)2, (int)schemas.size());
        schemas = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, null, false, true, "type1", null, null);
        Assertions.assertEquals((int)1, (int)schemas.size());
        response = this.restApp.restClient.registerSchema(request2, subject, false);
        Assertions.assertEquals((int)expectedIdSchema2, (int)response.getId(), (String)"Registering should succeed");
        ruleSet2 = schemaString.getRuleSet();
        Assertions.assertEquals((Object)"foo", (Object)((Rule)ruleSet2.getMigrationRules().get(0)).getName());
        Assertions.assertEquals((Object)"bar", (Object)((Rule)ruleSet2.getMigrationRules().get(1)).getName());
        AvroSchema schema3 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}, {\"type\":\"string\",\"name\":\"f3\"}]}");
        Rule r3 = new Rule("zap", null, null, RuleMode.UPGRADE, "type2", null, null, null, null, null, false);
        rules = Collections.singletonList(r3);
        ruleSet = new RuleSet(rules, null);
        RegisterSchemaRequest request3 = new RegisterSchemaRequest((ParsedSchema)schema3);
        request3.setRuleSet(ruleSet);
        int expectedIdSchema3 = 3;
        response = this.restApp.restClient.registerSchema(request3, subject, false);
        Assertions.assertEquals((int)expectedIdSchema3, (int)response.getId(), (String)"Registering should succeed");
        RuleSet ruleSet3 = response.getRuleSet();
        Assertions.assertEquals((Object)"foo", (Object)((Rule)ruleSet3.getMigrationRules().get(0)).getName());
        Assertions.assertEquals((Object)"zap", (Object)((Rule)ruleSet3.getMigrationRules().get(1)).getName());
        Assertions.assertEquals((Integer)response.getVersion(), (Integer)this.restApp.restClient.lookUpSubjectVersion(new RegisterSchemaRequest(new Schema(subject, response)), subject, false, false).getVersion(), (String)"Version should match");
        schemaString = this.restApp.restClient.getId(expectedIdSchema3, subject);
        ruleSet3 = schemaString.getRuleSet();
        Assertions.assertEquals((Object)"foo", (Object)((Rule)ruleSet3.getMigrationRules().get(0)).getName());
        Assertions.assertEquals((Object)"zap", (Object)((Rule)ruleSet3.getMigrationRules().get(1)).getName());
        schemas = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, null, false, false, "type1", null, null);
        Assertions.assertEquals((int)2, (int)schemas.size());
        schemas = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, null, false, false, "type2", null, null);
        Assertions.assertEquals((int)1, (int)schemas.size());
        schemas = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, null, false, true, "type1", null, null);
        Assertions.assertEquals((int)0, (int)schemas.size());
        schemas = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, null, false, true, "type2", null, null);
        Assertions.assertEquals((int)1, (int)schemas.size());
    }

    @Test
    public void testSchemaMetadata() throws Exception {
        String subject = "testSubject";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}");
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)schema1);
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(request1, subject, false).getId(), (String)"Registering should succeed");
        RegisterSchemaRequest request2 = new RegisterSchemaRequest();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("subjectKey", "subjectValue");
        Metadata metadata = new Metadata(null, properties, null);
        request2.setMetadata(metadata);
        int expectedIdSchema2 = 2;
        Assertions.assertEquals((int)expectedIdSchema2, (int)this.restApp.restClient.registerSchema(request2, subject, false).getId(), (String)"Registering should succeed");
        SchemaString schemaString = this.restApp.restClient.getId(expectedIdSchema2, subject);
        Assertions.assertEquals((Object)schema1.canonicalString(), (Object)schemaString.getSchemaString());
        Assertions.assertEquals((Object)metadata, (Object)schemaString.getMetadata());
    }

    @Test
    public void testSchemaRuleSet() throws Exception {
        String subject = "testSubject";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}");
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)schema1);
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(request1, subject, false).getId(), (String)"Registering should succeed");
        RegisterSchemaRequest request2 = new RegisterSchemaRequest();
        Rule r1 = new Rule("foo", null, null, RuleMode.UPGRADE, "IGNORE", null, null, null, null, null, false);
        List<Rule> rules = Collections.singletonList(r1);
        RuleSet ruleSet = new RuleSet(rules, null);
        request2.setRuleSet(ruleSet);
        int expectedIdSchema2 = 2;
        Assertions.assertEquals((int)expectedIdSchema2, (int)this.restApp.restClient.registerSchema(request2, subject, false).getId(), (String)"Registering should succeed");
        SchemaString schemaString = this.restApp.restClient.getId(expectedIdSchema2, subject);
        Assertions.assertEquals((Object)schema1.canonicalString(), (Object)schemaString.getSchemaString());
        Assertions.assertEquals((Object)ruleSet, (Object)schemaString.getRuleSet());
    }

    @Test
    public void testCompareAndSetVersion() throws Exception {
        String subject = "testSubject";
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(schemaString1, subject), (String)"Registering should succeed");
        AvroSchema schema2 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}]}");
        RegisterSchemaRequest request2 = new RegisterSchemaRequest((ParsedSchema)schema2);
        request2.setVersion(Integer.valueOf(3));
        try {
            this.restApp.restClient.registerSchema(request2, subject, false);
            Assertions.fail((String)"Registering a wrong version should fail");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)42201, (int)e.getErrorCode(), (String)"Should get a bad request status");
        }
        request2.setVersion(Integer.valueOf(2));
        int expectedIdSchema2 = 2;
        Assertions.assertEquals((int)expectedIdSchema2, (int)this.restApp.restClient.registerSchema(request2, subject, false).getId(), (String)"Registering should succeed");
    }

    @Test
    public void testConfigInvalidRuleSet() throws Exception {
        Rule r1 = new Rule("foo", null, null, RuleMode.READ, "IGNORE", null, null, null, null, null, false);
        ImmutableList rules = Collections.singletonList(r1);
        RuleSet ruleSet = new RuleSet(rules, null);
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setDefaultRuleSet(ruleSet);
        try {
            this.restApp.restClient.updateConfig(config, null);
            Assertions.fail((String)"Registering an invalid ruleSet should fail");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)422, (int)e.getStatus(), (String)"Should get a bad request status");
        }
        Rule r2 = new Rule("foo", null, null, RuleMode.READ, "IGNORE", null, null, null, null, null, false);
        rules = ImmutableList.of((Object)r1, (Object)r2);
        ruleSet = new RuleSet(null, (List)rules);
        config = new ConfigUpdateRequest();
        config.setDefaultRuleSet(ruleSet);
        try {
            this.restApp.restClient.updateConfig(config, null);
            Assertions.fail((String)"Registering an invalid ruleSet should fail");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)422, (int)e.getStatus(), (String)"Should get a bad request status");
        }
    }

    @Test
    public void testRegisterInvalidRuleSet() throws Exception {
        String subject = "testSubject";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}");
        Rule r1 = new Rule("foo", null, null, RuleMode.READ, null, null, null, null, null, null, false);
        List<Rule> rules = Collections.singletonList(r1);
        RuleSet ruleSet = new RuleSet(rules, null);
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)schema1);
        request1.setRuleSet(ruleSet);
        try {
            this.restApp.restClient.registerSchema(request1, subject, false);
            Assertions.fail((String)"Registering an invalid ruleSet should fail");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)422, (int)e.getStatus(), (String)"Should get a bad request status");
        }
    }

    @Test
    public void testRegisterBadDefaultWithNormalizeConfig() throws Exception {
        String subject = "testSubject";
        String schemaString = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"int\",\"default\":\"foo\",\"name\":\"f\"}]}";
        String schema = AvroUtils.parseSchema((String)schemaString).canonicalString();
        List errors = this.restApp.restClient.testCompatibility(schema, subject, "latest");
        Assertions.assertTrue((boolean)errors.isEmpty());
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setNormalize(Boolean.valueOf(true));
        config.setValidateFields(Boolean.valueOf(false));
        Assertions.assertEquals((Object)config, (Object)this.restApp.restClient.updateConfig(config, null), (String)"Setting normalize config should succeed");
        try {
            this.restApp.restClient.testCompatibility(schema, subject, "latest");
            Assertions.fail((String)"Testing compatibility for schema with invalid default should fail with 42201 (invalid schema)");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42201, (int)rce.getErrorCode());
        }
        try {
            this.restApp.restClient.registerSchema(schema, subject);
            Assertions.fail((String)"Registering schema with invalid default should fail with 42201 (invalid schema)");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42201, (int)rce.getErrorCode());
        }
    }

    @Test
    public void testSubjectAlias() throws Exception {
        String subject = "testSubject";
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(schemaString1, subject), (String)"Registering should succeed");
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setAlias("testSubject");
        Assertions.assertEquals((Object)config, (Object)this.restApp.restClient.updateConfig(config, "testAlias"), (String)"Setting alias config should succeed");
        Schema schema = this.restApp.restClient.getVersion("testAlias", 1);
        Assertions.assertEquals((Object)schemaString1, (Object)schema.getSchema());
    }

    @Test
    public void testSubjectAliasWithSlash() throws Exception {
        String subject = "testSubject";
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(schemaString1, subject), (String)"Registering should succeed");
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setAlias("testSubject");
        Assertions.assertEquals((Object)config, (Object)this.restApp.restClient.updateConfig(config, "test/Alias"), (String)"Setting alias config should succeed");
        Schema schema = this.restApp.restClient.getVersion("test/Alias", 1);
        Assertions.assertEquals((Object)schemaString1, (Object)schema.getSchema());
    }

    @Test
    public void testSubjectAliasWithContext() throws Exception {
        RestService restClient1 = new RestService(this.restApp.restConnect + "/contexts/.mycontext");
        RestService restClient2 = new RestService(this.restApp.restConnect + "/contexts/.mycontext2");
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)restClient1.registerSchema(schemaString1, "testSubject"), (String)"Registering should succeed");
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setAlias(":.mycontext:testSubject");
        Assertions.assertEquals((Object)config, (Object)this.restApp.restClient.updateConfig(config, ":.mycontext2:testAlias"), (String)"Setting alias config should succeed");
        Schema schema = restClient2.getVersion("testAlias", 1);
        Assertions.assertEquals((Object)schemaString1, (Object)schema.getSchema());
    }

    @Test
    public void testGlobalAliasNotUsed() throws Exception {
        String subject = "testSubject";
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(schemaString1, subject), (String)"Registering should succeed");
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setAlias("badSubject");
        config.setValidateFields(Boolean.valueOf(false));
        Assertions.assertEquals((Object)config, (Object)this.restApp.restClient.updateConfig(config, null), (String)"Setting alias config should succeed");
        Schema schema = this.restApp.restClient.getVersion("testSubject", 1);
        Assertions.assertEquals((Object)schemaString1, (Object)schema.getSchema());
    }

    @Test
    public void testGetSchemasWithAliases() throws Exception {
        String subject = "testSubject";
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(schemaString1, subject), (String)"Registering should succeed");
        String schemaString2 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}]}").canonicalString();
        int expectedIdSchema2 = 2;
        Assertions.assertEquals((int)expectedIdSchema2, (int)this.restApp.restClient.registerSchema(schemaString2, subject), (String)"Registering a compatible schema should succeed");
        subject = "noTestSubject";
        String unrelated1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"x1\"}]}").canonicalString();
        int expectedIdUnrelated1 = 3;
        Assertions.assertEquals((int)expectedIdUnrelated1, (int)this.restApp.restClient.registerSchema(unrelated1, subject), (String)"Registering should succeed");
        String unrelated2 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"x1\"}, {\"type\":\"string\",\"name\":\"x2\", \"default\": \"foo\"}]}").canonicalString();
        int expectedIdUnrelated2 = 4;
        Assertions.assertEquals((int)expectedIdUnrelated2, (int)this.restApp.restClient.registerSchema(unrelated2, subject), (String)"Registering a compatible schema should succeed");
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setAlias("testSubject");
        Assertions.assertEquals((Object)config, (Object)this.restApp.restClient.updateConfig(config, "testAlias"), (String)"Setting alias config should succeed");
        List schemas = this.restApp.restClient.getSchemas("testAlias", true, false);
        Assertions.assertEquals((int)0, (int)schemas.size());
        List schemasWithAliases = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, "testAlias", true, false, false, null, null, null);
        Assertions.assertEquals((int)2, (int)schemasWithAliases.size());
        for (ExtendedSchema schema : schemasWithAliases) {
            if (schema.getSubject().equals("testSubject")) {
                Assertions.assertEquals((int)1, (int)schema.getAliases().size());
                Assertions.assertEquals((Object)"testAlias", schema.getAliases().get(0));
                continue;
            }
            Assertions.fail((String)("Unexpected subject: " + schema.getSubject()));
        }
        subject = "testAlligator";
        String schemaString3 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"a1\"}, {\"type\":\"string\",\"name\":\"a2\", \"default\": \"foo\"}]}").canonicalString();
        int expectedIdSchema3 = 5;
        Assertions.assertEquals((int)expectedIdSchema3, (int)this.restApp.restClient.registerSchema(schemaString3, subject), (String)"Registering a schema should succeed");
        schemasWithAliases = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, "testAl", true, false, false, null, null, null);
        Assertions.assertEquals((int)3, (int)schemasWithAliases.size());
        for (ExtendedSchema schema : schemasWithAliases) {
            if (schema.getSubject().endsWith("testAlligator")) {
                Assertions.assertNull((Object)schema.getAliases());
                continue;
            }
            if (schema.getSubject().equals("testSubject")) {
                Assertions.assertEquals((int)1, (int)schema.getAliases().size());
                Assertions.assertEquals((Object)"testAlias", schema.getAliases().get(0));
                continue;
            }
            Assertions.fail((String)("Unexpected subject: " + schema.getSubject()));
        }
        schemasWithAliases = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, "test", true, false, false, null, null, null);
        Assertions.assertEquals((int)3, (int)schemasWithAliases.size());
        for (ExtendedSchema schema : schemasWithAliases) {
            if (schema.getSubject().endsWith("testAlligator")) {
                Assertions.assertNull((Object)schema.getAliases());
                continue;
            }
            if (schema.getSubject().equals("testSubject")) {
                Assertions.assertEquals((int)1, (int)schema.getAliases().size());
                Assertions.assertEquals((Object)"testAlias", schema.getAliases().get(0));
                continue;
            }
            Assertions.fail((String)("Unexpected subject: " + schema.getSubject()));
        }
        config = new ConfigUpdateRequest();
        config.setAlias("testSubject");
        Assertions.assertEquals((Object)config, (Object)this.restApp.restClient.updateConfig(config, "testAlias2"), (String)"Setting alias config should succeed");
        schemasWithAliases = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, "testAl", true, false, false, null, null, null);
        Assertions.assertEquals((int)3, (int)schemasWithAliases.size());
        for (ExtendedSchema schema : schemasWithAliases) {
            if (schema.getSubject().endsWith("testAlligator")) {
                Assertions.assertNull((Object)schema.getAliases());
                continue;
            }
            if (schema.getSubject().equals("testSubject")) {
                Assertions.assertEquals((int)2, (int)schema.getAliases().size());
                Assertions.assertEquals((Object)"testAlias", schema.getAliases().get(0));
                Assertions.assertEquals((Object)"testAlias2", schema.getAliases().get(1));
                continue;
            }
            Assertions.fail((String)("Unexpected subject: " + schema.getSubject()));
        }
        schemasWithAliases = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, "test", true, false, false, null, null, null);
        Assertions.assertEquals((int)3, (int)schemasWithAliases.size());
        for (ExtendedSchema schema : schemasWithAliases) {
            if (schema.getSubject().endsWith("testAlligator")) {
                Assertions.assertNull((Object)schema.getAliases());
                continue;
            }
            if (schema.getSubject().equals("testSubject")) {
                Assertions.assertEquals((int)2, (int)schema.getAliases().size());
                Assertions.assertEquals((Object)"testAlias", schema.getAliases().get(0));
                Assertions.assertEquals((Object)"testAlias2", schema.getAliases().get(1));
                continue;
            }
            Assertions.fail((String)("Unexpected subject: " + schema.getSubject()));
        }
    }

    @Test
    public void testGetSchemasWithAliasesAndContextWildcard() throws Exception {
        String subject = "testSubject";
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(schemaString1, subject), (String)"Registering should succeed");
        String schemaString2 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}]}").canonicalString();
        int expectedIdSchema2 = 2;
        Assertions.assertEquals((int)expectedIdSchema2, (int)this.restApp.restClient.registerSchema(schemaString2, subject), (String)"Registering a compatible schema should succeed");
        subject = "noTestSubject";
        String unrelated1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"x1\"}]}").canonicalString();
        int expectedIdUnrelated1 = 3;
        Assertions.assertEquals((int)expectedIdUnrelated1, (int)this.restApp.restClient.registerSchema(unrelated1, subject), (String)"Registering should succeed");
        String unrelated2 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"x1\"}, {\"type\":\"string\",\"name\":\"x2\", \"default\": \"foo\"}]}").canonicalString();
        int expectedIdUnrelated2 = 4;
        Assertions.assertEquals((int)expectedIdUnrelated2, (int)this.restApp.restClient.registerSchema(unrelated2, subject), (String)"Registering a compatible schema should succeed");
        ConfigUpdateRequest config = new ConfigUpdateRequest();
        config.setAlias("testSubject");
        Assertions.assertEquals((Object)config, (Object)this.restApp.restClient.updateConfig(config, "testAlias"), (String)"Setting alias config should succeed");
        List schemas = this.restApp.restClient.getSchemas("testAlias", true, false);
        Assertions.assertEquals((int)0, (int)schemas.size());
        List schemasWithAliases = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, ":*:", true, false, false, null, null, null);
        Assertions.assertEquals((int)4, (int)schemasWithAliases.size());
        for (ExtendedSchema schema : schemasWithAliases) {
            if (schema.getSubject().equals("testSubject")) {
                Assertions.assertEquals((int)1, (int)schema.getAliases().size());
                Assertions.assertEquals((Object)"testAlias", schema.getAliases().get(0));
                continue;
            }
            Assertions.assertNull((Object)schema.getAliases());
        }
        subject = "testAlligator";
        String schemaString3 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"a1\"}, {\"type\":\"string\",\"name\":\"a2\", \"default\": \"foo\"}]}").canonicalString();
        int expectedIdSchema3 = 5;
        Assertions.assertEquals((int)expectedIdSchema3, (int)this.restApp.restClient.registerSchema(schemaString3, subject), (String)"Registering a schema should succeed");
        schemasWithAliases = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, ":*:", true, false, false, null, null, null);
        Assertions.assertEquals((int)5, (int)schemasWithAliases.size());
        for (ExtendedSchema schema : schemasWithAliases) {
            if (schema.getSubject().equals("testSubject")) {
                Assertions.assertEquals((int)1, (int)schema.getAliases().size());
                Assertions.assertEquals((Object)"testAlias", schema.getAliases().get(0));
                continue;
            }
            Assertions.assertNull((Object)schema.getAliases());
        }
        config = new ConfigUpdateRequest();
        config.setAlias("testSubject");
        Assertions.assertEquals((Object)config, (Object)this.restApp.restClient.updateConfig(config, "testAlias2"), (String)"Setting alias config should succeed");
        schemasWithAliases = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, ":*:", true, false, false, null, null, null);
        Assertions.assertEquals((int)5, (int)schemasWithAliases.size());
        for (ExtendedSchema schema : schemasWithAliases) {
            if (schema.getSubject().equals("testSubject")) {
                Assertions.assertEquals((int)2, (int)schema.getAliases().size());
                Assertions.assertEquals((Object)"testAlias", schema.getAliases().get(0));
                Assertions.assertEquals((Object)"testAlias2", schema.getAliases().get(1));
                continue;
            }
            Assertions.assertNull((Object)schema.getAliases());
        }
        subject = ":.myctx:testSubject";
        String schemaString4 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"b1\"}, {\"type\":\"string\",\"name\":\"b2\", \"default\": \"foo\"}]}").canonicalString();
        int expectedIdSchema4 = 1;
        Assertions.assertEquals((int)expectedIdSchema4, (int)this.restApp.restClient.registerSchema(schemaString4, subject), (String)"Registering a schema should succeed");
        config = new ConfigUpdateRequest();
        config.setAlias("testSubject");
        Assertions.assertEquals((Object)config, (Object)this.restApp.restClient.updateConfig(config, ":.myctx:testAlias3"), (String)"Setting alias config should succeed");
        schemasWithAliases = this.restApp.restClient.getSchemas(RestService.DEFAULT_REQUEST_PROPERTIES, ":*:", true, false, false, null, null, null);
        Assertions.assertEquals((int)6, (int)schemasWithAliases.size());
        for (ExtendedSchema schema : schemasWithAliases) {
            if (schema.getSubject().equals("testSubject")) {
                Assertions.assertEquals((int)2, (int)schema.getAliases().size());
                Assertions.assertEquals((Object)"testAlias", schema.getAliases().get(0));
                Assertions.assertEquals((Object)"testAlias2", schema.getAliases().get(1));
                continue;
            }
            if (schema.getSubject().equals(":.myctx:testSubject")) {
                Assertions.assertEquals((int)1, (int)schema.getAliases().size());
                Assertions.assertEquals((Object)":.myctx:testAlias3", schema.getAliases().get(0));
                continue;
            }
            Assertions.assertNull((Object)schema.getAliases());
        }
    }

    @Test
    public void testRegisterEmptyRuleSet() throws Exception {
        String subject = "testSubject";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}");
        ImmutableList rules = Collections.emptyList();
        RuleSet ruleSet = new RuleSet(null, rules);
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)schema1);
        request1.setRuleSet(ruleSet);
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(request1, subject, false).getId());
        request1.setRuleSet(null);
        Schema s = this.restApp.restClient.lookUpSubjectVersion(request1, subject, false, false);
        Assertions.assertEquals((int)expectedIdSchema1, (int)s.getId());
        Rule r1 = new Rule("foo", null, null, RuleMode.READ, "IGNORE", null, null, null, null, null, false);
        rules = ImmutableList.of((Object)r1);
        ruleSet = new RuleSet(null, (List)rules);
        RegisterSchemaRequest request2 = new RegisterSchemaRequest();
        request2.setRuleSet(ruleSet);
        int expectedIdSchema2 = 2;
        Assertions.assertEquals((int)expectedIdSchema2, (int)this.restApp.restClient.registerSchema(request2, subject, false).getId());
        s = this.restApp.restClient.lookUpSubjectVersion(request1, subject, false, false);
        Assertions.assertEquals((int)expectedIdSchema2, (int)s.getId());
    }

    @Test
    public void testGlobalContextWithNone() throws Exception {
        String subject = "testSubject";
        String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
        int expectedIdSchema1 = 1;
        Assertions.assertEquals((int)expectedIdSchema1, (int)this.restApp.restClient.registerSchema(schemaString1, subject), (String)"Registering should succeed");
        String incompatibleSchemaString = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}").canonicalString();
        try {
            this.restApp.restClient.registerSchema(incompatibleSchemaString, subject);
            Assertions.fail((String)"Registering an incompatible schema should fail");
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)RestIncompatibleSchemaException.DEFAULT_ERROR_CODE, (int)e.getStatus(), (String)"Should get a conflict status");
        }
        Assertions.assertEquals((Object)CompatibilityLevel.NONE.name, (Object)this.restApp.restClient.updateCompatibility(CompatibilityLevel.NONE.name, ":.__GLOBAL:").getCompatibilityLevel(), (String)"Changing compatibility level should succeed");
        Config config = this.restApp.restClient.getConfig(RestService.DEFAULT_REQUEST_PROPERTIES, null, true);
        Assertions.assertEquals((Object)"none", (Object)config.getCompatibilityLevel().toLowerCase());
        try {
            this.restApp.restClient.registerSchema(incompatibleSchemaString, subject);
        }
        catch (RestClientException e) {
            Assertions.fail((String)"Registering an incompatible schema should succeed after bumping down the compatibility level to none");
        }
    }
}

