/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.filters;

import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.rest.filters.AliasFilter;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class AliasNonDefaultTenantFilterTest {
    private AliasFilter aliasFilter;

    @Before
    public void setUp() throws Exception {
        KafkaSchemaRegistry schemaRegistry = (KafkaSchemaRegistry)Mockito.mock(KafkaSchemaRegistry.class);
        Mockito.when((Object)schemaRegistry.tenant()).thenReturn((Object)"myTenant");
        this.aliasFilter = new AliasFilter(schemaRegistry);
        Config config = new Config();
        config.setAlias("mySubject");
        Mockito.when((Object)schemaRegistry.getConfig("myTenant_myAlias")).thenReturn((Object)config);
        Config config2 = new Config();
        config2.setAlias("mySubject2");
        Mockito.when((Object)schemaRegistry.getConfig("myTenant_slash/in/middle")).thenReturn((Object)config2);
    }

    @Test
    public void testRoot() {
        String path = "/";
        Assert.assertEquals((String)"URI must not change", (Object)"/", (Object)this.aliasFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testSubjectPartOfUri() {
        String path = "/subjects/myTenant_myAlias/versions";
        Assert.assertEquals((String)"Subject must be replaced", (Object)"/subjects/myTenant_mySubject/versions", (Object)this.aliasFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testNoSubjectDefaultContext() {
        String path = "/subjects";
        Assert.assertEquals((String)"Subject must not change", (Object)"/subjects", (Object)this.aliasFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testUriEndsWithSubject() {
        String path = "/subjects/myTenant_myAlias/";
        Assert.assertEquals((String)"Subject must be replaced", (Object)"/subjects/myTenant_mySubject/", (Object)this.aliasFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testUriWithIds() {
        String path = "/schemas/ids/1";
        URI uri = this.aliasFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap());
        Assert.assertEquals((String)"URI must not change", (Object)"/schemas/ids/1", (Object)uri.getPath());
        Assert.assertEquals((String)"Query param must not change", (Object)"subject=", (Object)uri.getQuery());
    }

    @Test
    public void testUriWithIdsAndSubject() {
        String path = "/schemas/ids/1/";
        UriBuilder uriBuilder = UriBuilder.fromPath((String)path);
        uriBuilder.queryParam("subject", new Object[]{"myAlias"});
        MultivaluedHashMap queryParams = new MultivaluedHashMap();
        queryParams.put((Object)"subject", Collections.singletonList("myAlias"));
        URI uri = this.aliasFilter.modifyUri(uriBuilder, path, (MultivaluedMap)queryParams);
        Assert.assertEquals((String)"URI must not change", (Object)"/schemas/ids/1/", (Object)uri.getPath());
        Assert.assertEquals((String)"Query param must match", (Object)"subject=mySubject", (Object)uri.getQuery());
    }

    @Test
    public void testUriWithEncodedSlash() {
        String path = "/subjects/myTenant_slash%2Fin%2Fmiddle/";
        Assert.assertEquals((String)"Subject must be replaced", (Object)"/subjects/myTenant_mySubject2/", (Object)this.aliasFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testConfigUriWithSubject() {
        String path = "/config/myTenant_myAlias";
        Assert.assertEquals((String)"Subject must not change", (Object)"/config/myTenant_myAlias", (Object)this.aliasFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testUriWithoutModification() {
        String path = "/chc/live";
        Assert.assertEquals((String)"URI must not change", (Object)"/chc/live", (Object)this.aliasFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testModeUriWithSubject() {
        String path = "/mode/myTenant_myAlias";
        Assert.assertEquals((String)"Subject must not change", (Object)"/mode/myTenant_myAlias", (Object)this.aliasFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }

    @Test
    public void testDekPartOfUri() {
        String path = "/dek-registry/v1/keks/test-kek/deks/myAlias";
        Assert.assertEquals((String)"Subject must be replaced", (Object)"/dek-registry/v1/keks/test-kek/deks/mySubject", (Object)this.aliasFilter.modifyUri(UriBuilder.fromPath((String)path), path, (MultivaluedMap)new MultivaluedHashMap()).getPath());
    }
}

