/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.SASLClusterTestHarness;
import io.confluent.kafka.schemaregistry.storage.KafkaStore;
import io.confluent.kafka.schemaregistry.storage.StoreUtils;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreInitializationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KafkaStoreSASLTest
extends SASLClusterTestHarness {
    @Test
    public void testInitialization() throws Exception {
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitSASLStoreInstance(this.brokerList);
        kafkaStore.close();
    }

    @Test
    public void testDoubleInitialization() throws Exception {
        Assertions.assertThrows(StoreInitializationException.class, () -> {
            try (KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitSASLStoreInstance(this.brokerList);){
                kafkaStore.init();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimplePut() throws Exception {
        KafkaStore<String, String> kafkaStore = StoreUtils.createAndInitSASLStoreInstance(this.brokerList);
        String key = "Kafka";
        String value = "Rocks";
        try {
            kafkaStore.put((Object)key, (Object)value);
            String retrievedValue = (String)kafkaStore.get((Object)key);
            Assertions.assertEquals((Object)value, (Object)retrievedValue, (String)"Retrieved value should match entered value");
        }
        finally {
            kafkaStore.close();
        }
    }
}

