/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import com.google.common.collect.ImmutableList;
import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.utils.TestUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RestApiContextTest
extends ClusterTestHarness {
    public RestApiContextTest() {
        super(1, true);
    }

    @Test
    public void testQualifiedSubjects() throws Exception {
        int i;
        String subject1 = ":.ctx1:testTopic1";
        String subject2 = ":.ctx2:testTopic2";
        String subject3 = ":.ctx3:testTopic1";
        String subject4 = "testTopic1";
        int schemasInSubject1 = 10;
        ArrayList<Integer> allVersionsInSubject1 = new ArrayList<Integer>();
        List<String> allSchemasInSubject1 = TestUtils.getRandomCanonicalAvroString(schemasInSubject1);
        int schemasInSubject2 = 5;
        ArrayList<Integer> allVersionsInSubject2 = new ArrayList<Integer>();
        List<String> allSchemasInSubject2 = TestUtils.getRandomCanonicalAvroString(schemasInSubject2);
        int schemasInSubject3 = 2;
        ArrayList<Integer> allVersionsInSubject3 = new ArrayList<Integer>();
        List<String> allSchemasInSubject3 = TestUtils.getRandomCanonicalAvroString(schemasInSubject3);
        int schemasInSubject4 = 1;
        ArrayList<Integer> allVersionsInSubject4 = new ArrayList<Integer>();
        List<String> allSchemasInSubject4 = TestUtils.getRandomCanonicalAvroString(schemasInSubject4);
        try {
            this.restApp.restClient.getAllVersions(subject1);
            Assertions.fail((String)"Getting all versions from non-existing subject1 should fail with 40401 (subject not found)");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40401, (int)rce.getErrorCode(), (String)"Should get a 404 status for non-existing subject");
        }
        Assertions.assertEquals(Collections.singletonList("."), (Object)this.restApp.restClient.getAllContexts(), (String)"Getting all subjects should return default context");
        Assertions.assertEquals(Collections.emptyList(), (Object)this.restApp.restClient.getAllSubjects(), (String)"Getting all subjects should return empty");
        int schemaIdCounter = 1;
        for (i = 0; i < schemasInSubject1; ++i) {
            String schema = allSchemasInSubject1.get(i);
            int expectedVersion = i + 1;
            RestApiContextTest.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter, subject1);
            ++schemaIdCounter;
            allVersionsInSubject1.add(expectedVersion);
        }
        for (i = 0; i < schemasInSubject1; ++i) {
            int expectedId = i + 1;
            String schemaString = allSchemasInSubject1.get(i);
            int foundId = this.restApp.restClient.registerSchema(schemaString, subject1);
            Assertions.assertEquals((int)expectedId, (int)foundId, (String)"Re-registering an existing schema should return the existing version");
        }
        schemaIdCounter = 1;
        for (i = 0; i < schemasInSubject2; ++i) {
            String schema = allSchemasInSubject2.get(i);
            int expectedVersion = i + 1;
            RestApiContextTest.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter, subject2);
            ++schemaIdCounter;
            allVersionsInSubject2.add(expectedVersion);
        }
        schemaIdCounter = 1;
        for (i = 0; i < schemasInSubject3; ++i) {
            String schema = allSchemasInSubject3.get(i);
            int expectedVersion = i + 1;
            RestApiContextTest.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter, subject3);
            ++schemaIdCounter;
            allVersionsInSubject3.add(expectedVersion);
        }
        schemaIdCounter = 1;
        for (i = 0; i < schemasInSubject4; ++i) {
            String schema = allSchemasInSubject4.get(i);
            int expectedVersion = i + 1;
            RestApiContextTest.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter, subject4);
            ++schemaIdCounter;
            allVersionsInSubject4.add(expectedVersion);
        }
        Assertions.assertEquals(allVersionsInSubject1, (Object)this.restApp.restClient.getAllVersions(subject1), (String)"Getting all versions from subject1 should match all registered versions");
        Assertions.assertEquals(allVersionsInSubject2, (Object)this.restApp.restClient.getAllVersions(subject2), (String)"Getting all versions from subject2 should match all registered versions");
        Assertions.assertEquals((Object)ImmutableList.of((Object)".", (Object)".ctx1", (Object)".ctx2", (Object)".ctx3"), (Object)this.restApp.restClient.getAllContexts(), (String)"Getting all contexts should return all registered contexts");
        Assertions.assertEquals(Collections.singletonList(subject1), (Object)this.restApp.restClient.getAllSubjects(":.ctx1:", false), (String)"Getting all subjects should match all registered subjects");
        Assertions.assertEquals(Collections.singletonList(subject2), (Object)this.restApp.restClient.getAllSubjects(":.ctx2:", false), (String)"Getting all subjects should match all registered subjects");
        Assertions.assertEquals(Collections.singletonList(subject4), (Object)this.restApp.restClient.getAllSubjects("", false), (String)"Getting all subjects should match default subjects");
        Assertions.assertEquals((Object)ImmutableList.of((Object)subject1, (Object)subject2, (Object)subject3, (Object)subject4), (Object)this.restApp.restClient.getAllSubjects(":*:", false), (String)"Getting all subjects should match all registered subjects");
        Assertions.assertEquals((int)(schemasInSubject1 + schemasInSubject2 + schemasInSubject3 + schemasInSubject4), (int)this.restApp.restClient.getSchemas(":*:", false, false).size(), (String)"Getting all schemas should match all registered subjects");
        Assertions.assertEquals((int)(schemasInSubject1 + schemasInSubject3 + schemasInSubject4), (int)this.restApp.restClient.getSchemas(":*:testTopic1", false, false).size(), (String)"Getting all schemas should match registered subjects");
        Assertions.assertEquals((int)schemasInSubject2, (int)this.restApp.restClient.getSchemas(":*:testTopic2", false, false).size(), (String)"Getting all schemas should match registered subjects");
        Schema schema = this.restApp.restClient.getVersion("testTopic2", 1);
        Assertions.assertEquals((int)1, (int)schema.getVersion(), (String)"Getting schema by version w/o context should succeed");
        schema = this.restApp.restClient.lookUpSubjectVersion(schema.getSchema(), "testTopic2");
        Assertions.assertEquals((int)1, (int)schema.getVersion(), (String)"Getting schema by schema w/o context should succeed");
    }

    @Test
    public void testContextPaths() throws Exception {
        int i;
        RestService restClient1 = new RestService(this.restApp.restConnect + "/contexts/.ctx1");
        RestService restClient2 = new RestService(this.restApp.restConnect + "/contexts/.ctx2");
        RestService restClient3 = new RestService(this.restApp.restConnect + "/contexts/:.:");
        RestService noCtxRestClient3 = new RestService(this.restApp.restConnect);
        String subject1 = "testTopic1";
        String subject2A = "testTopic2A";
        String subject2B = "testTopic2B";
        String subject2C = "testTopic2C";
        String subject3 = "testTopic3";
        int schemasInSubject1 = 10;
        ArrayList<Integer> allVersionsInSubject1 = new ArrayList<Integer>();
        List<String> allSchemasInSubject1 = TestUtils.getRandomCanonicalAvroString(schemasInSubject1);
        int schemasInSubject2 = 5;
        ArrayList<Integer> allVersionsInSubject2 = new ArrayList<Integer>();
        List<String> allSchemasInSubject2 = TestUtils.getRandomCanonicalAvroString(schemasInSubject2);
        int schemasInSubject3 = 2;
        ArrayList<Integer> allVersionsInSubject3 = new ArrayList<Integer>();
        List<String> allSchemasInSubject3 = TestUtils.getRandomCanonicalAvroString(schemasInSubject3);
        try {
            restClient1.getAllVersions(subject1);
            Assertions.fail((String)"Getting all versions from non-existing subject1 should fail with 40401 (subject not found)");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40401, (int)rce.getErrorCode(), (String)"Should get a 404 status for non-existing subject");
        }
        int schemaIdCounter = 1;
        for (i = 0; i < schemasInSubject1; ++i) {
            String schema = allSchemasInSubject1.get(i);
            int expectedVersion = i + 1;
            RestApiContextTest.registerAndVerifySchema(restClient1, schema, schemaIdCounter, subject1);
            ++schemaIdCounter;
            allVersionsInSubject1.add(expectedVersion);
        }
        for (i = 0; i < schemasInSubject1; ++i) {
            int expectedId = i + 1;
            String schemaString = allSchemasInSubject1.get(i);
            int foundId = restClient1.registerSchema(schemaString, subject1);
            Assertions.assertEquals((int)expectedId, (int)foundId, (String)"Re-registering an existing schema should return the existing version");
        }
        schemaIdCounter = 1;
        for (i = 0; i < schemasInSubject2; ++i) {
            String schema = allSchemasInSubject2.get(i);
            int expectedVersion = i + 1;
            RestApiContextTest.registerAndVerifySchema(restClient2, schema, schemaIdCounter, subject2A);
            RestApiContextTest.registerAndVerifySchema(restClient2, schema, schemaIdCounter, subject2B);
            RestApiContextTest.registerAndVerifySchema(restClient2, schema, schemaIdCounter, subject2C);
            ++schemaIdCounter;
            allVersionsInSubject2.add(expectedVersion);
        }
        schemaIdCounter = 1;
        try {
            restClient3.getId(schemaIdCounter);
            Assertions.fail((String)"Registered schema should not be found in default context");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40403, (int)rce.getErrorCode(), (String)"Should get a 404 status for non-existing schema");
        }
        for (int i2 = 0; i2 < schemasInSubject3; ++i2) {
            String schema = allSchemasInSubject3.get(i2);
            int expectedVersion = i2 + 1;
            RestApiContextTest.registerAndVerifySchema(restClient3, schema, schemaIdCounter, subject3);
            ++schemaIdCounter;
            allVersionsInSubject3.add(expectedVersion);
        }
        Assertions.assertEquals(allVersionsInSubject1, (Object)restClient1.getAllVersions(subject1), (String)"Getting all versions from subject1 should match all registered versions");
        Assertions.assertEquals(allVersionsInSubject2, (Object)restClient2.getAllVersions(subject2A), (String)"Getting all versions from subject2A should match all registered versions");
        Assertions.assertEquals(allVersionsInSubject3, (Object)restClient3.getAllVersions(subject3), (String)"Getting all versions from subject3 should match all registered versions");
        Assertions.assertEquals(allVersionsInSubject3, (Object)noCtxRestClient3.getAllVersions(subject3), (String)"Getting all versions from subject3 should match all registered versions");
        Assertions.assertEquals(allVersionsInSubject3, (Object)noCtxRestClient3.getAllVersions(":.:" + subject3), (String)"Getting all versions from subject3 should match all registered versions");
        Assertions.assertEquals((Object)ImmutableList.of((Object)".", (Object)".ctx1", (Object)".ctx2"), (Object)restClient1.getAllContexts(), (String)"Getting all contexts should return all registered contexts");
        Assertions.assertEquals(Collections.singletonList(":.ctx1:" + subject1), (Object)restClient1.getAllSubjects(), (String)"Getting all subjects should match all registered subjects");
        Assertions.assertEquals((Object)ImmutableList.of((Object)(":.ctx2:" + subject2A), (Object)(":.ctx2:" + subject2B), (Object)(":.ctx2:" + subject2C)), (Object)restClient2.getAllSubjects(), (String)"Getting all subjects should match all registered subjects");
        Assertions.assertEquals(Collections.singletonList(subject3), (Object)restClient3.getAllSubjects(), (String)"Getting all subjects should match all registered subjects");
        Assertions.assertEquals(Collections.singletonList(subject3), (Object)noCtxRestClient3.getAllSubjects("", false), (String)"Getting all subjects should match all registered subjects");
        Assertions.assertEquals((Object)allSchemasInSubject3.get(0), (Object)noCtxRestClient3.getId(1, subject3).getSchemaString(), (String)"Registered schema should be found");
        Assertions.assertEquals((Object)allSchemasInSubject2.get(0), (Object)noCtxRestClient3.getId(1, subject2A).getSchemaString(), (String)"Registered schema should be found");
        restClient1.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject1, false);
        restClient1.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject1, true);
        try {
            restClient1.getAllVersions(subject1);
            Assertions.fail((String)"Getting all versions from non-existing subject1 should fail with 40401 (subject not found)");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)40401, (int)rce.getErrorCode(), (String)"Should get a 404 status for non-existing subject");
        }
        try {
            noCtxRestClient3.deleteContext(RestService.DEFAULT_REQUEST_PROPERTIES, ".ctx2");
            Assertions.fail((String)"Deleting context .ctx2 should fail with 42211 (context not empty)");
        }
        catch (RestClientException rce) {
            Assertions.assertEquals((int)42211, (int)rce.getErrorCode(), (String)"Should get a 422 status for non-empty context");
        }
        noCtxRestClient3.deleteContext(RestService.DEFAULT_REQUEST_PROPERTIES, ".ctx1");
        List contexts = restClient1.getAllContexts();
        Assertions.assertEquals((Object)ImmutableList.of((Object)".", (Object)".ctx2"), (Object)contexts, (String)"Getting all contexts should return all registered contexts after subject1 deletion");
    }

    static void registerAndVerifySchema(RestService restService, String schemaString, int expectedId, String subject) throws IOException, RestClientException {
        int registeredId = restService.registerSchema(schemaString, subject);
        Assertions.assertEquals((int)expectedId, (int)registeredId, (String)"Registering a new schema should succeed");
        Assertions.assertEquals((Object)schemaString, (Object)restService.getId(expectedId, subject).getSchemaString(), (String)"Registered schema should be found");
    }

    @Test
    public void testContextPrefixFilter() throws Exception {
        String subject1 = ":.prod:testSubject1";
        String subject2 = ":.prod-eu:testSubject2";
        String subject3 = ":.staging:testSubject3";
        String subject4 = ":.dev:testSubject4";
        String subject5 = "testSubject5";
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(5);
        this.restApp.restClient.registerSchema(schemas.get(0), subject1);
        this.restApp.restClient.registerSchema(schemas.get(1), subject2);
        this.restApp.restClient.registerSchema(schemas.get(2), subject3);
        this.restApp.restClient.registerSchema(schemas.get(3), subject4);
        this.restApp.restClient.registerSchema(schemas.get(4), subject5);
        List allContexts = this.restApp.restClient.getAllContexts();
        Assertions.assertEquals((Object)ImmutableList.of((Object)".", (Object)".dev", (Object)".prod", (Object)".prod-eu", (Object)".staging"), (Object)allContexts, (String)"Getting all contexts should return all registered contexts");
        List prodContexts = this.restApp.restClient.getAllContexts(0, -1, ".prod");
        Assertions.assertEquals((Object)ImmutableList.of((Object)".prod", (Object)".prod-eu"), (Object)prodContexts, (String)"Filtering by '.prod' should return contexts starting with '.prod'");
        List prodEuContexts = this.restApp.restClient.getAllContexts(0, -1, ".prod-eu");
        Assertions.assertEquals(Collections.singletonList(".prod-eu"), (Object)prodEuContexts, (String)"Filtering by '.prod-eu' should return only '.prod-eu' context");
        List dotPrefixContexts = this.restApp.restClient.getAllContexts(0, -1, ".");
        Assertions.assertEquals((Object)allContexts, (Object)dotPrefixContexts, (String)"Filtering by '.' should return all contexts as all contexts start with '.'");
        List stagingContexts = this.restApp.restClient.getAllContexts(0, -1, ".s");
        Assertions.assertEquals(Collections.singletonList(".staging"), (Object)stagingContexts, (String)"Filtering by '.s' should return '.staging' context");
        List noMatch = this.restApp.restClient.getAllContexts(0, -1, ".nonexistent");
        Assertions.assertEquals(Collections.emptyList(), (Object)noMatch, (String)"Filtering by non-matching prefix should return empty list");
        List emptyFilter = this.restApp.restClient.getAllContexts(0, -1, "");
        Assertions.assertEquals((Object)allContexts, (Object)emptyFilter, (String)"Filtering with empty string should return all contexts");
    }

    @Test
    public void testContextPrefixFilterWithPagination() throws Exception {
        String subject1 = ":.alpha:test";
        String subject2 = ":.beta:test";
        String subject3 = ":.gamma:test";
        String subject4 = ":.delta:test";
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(4);
        this.restApp.restClient.registerSchema(schemas.get(0), subject1);
        this.restApp.restClient.registerSchema(schemas.get(1), subject2);
        this.restApp.restClient.registerSchema(schemas.get(2), subject3);
        this.restApp.restClient.registerSchema(schemas.get(3), subject4);
        List allContexts = this.restApp.restClient.getAllContexts();
        Assertions.assertEquals((int)5, (int)allContexts.size(), (String)"Should have 5 total contexts");
        List page1 = this.restApp.restClient.getAllContexts(0, 2, ".");
        Assertions.assertEquals((int)2, (int)page1.size(), (String)"First page should have 2 contexts");
        Assertions.assertEquals((Object)ImmutableList.of((Object)".", (Object)".alpha"), (Object)page1, (String)"First page should contain default and .alpha");
        List page2 = this.restApp.restClient.getAllContexts(2, 2, ".");
        Assertions.assertEquals((int)2, (int)page2.size(), (String)"Second page should have 2 contexts");
        Assertions.assertEquals((Object)ImmutableList.of((Object)".beta", (Object)".delta"), (Object)page2, (String)"Second page should contain .beta and .delta");
        List page3 = this.restApp.restClient.getAllContexts(4, 2, ".");
        Assertions.assertEquals((int)1, (int)page3.size(), (String)"Third page should have 1 context");
        Assertions.assertEquals(Collections.singletonList(".gamma"), (Object)page3, (String)"Third page should contain .gamma");
        List alphaPage = this.restApp.restClient.getAllContexts(0, 1, ".a");
        Assertions.assertEquals(Collections.singletonList(".alpha"), (Object)alphaPage, (String)"Filtering by '.a' with limit 1 should return .alpha");
    }

    @Test
    public void testContextPrefixFilterEdgeCases() throws Exception {
        String subject = ":.test:subject";
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(1);
        this.restApp.restClient.registerSchema(schemas.get(0), subject);
        List nullFilter = this.restApp.restClient.getAllContexts(0, -1, null);
        Assertions.assertEquals((Object)ImmutableList.of((Object)".", (Object)".test"), (Object)nullFilter, (String)"Null contextPrefix should return all contexts");
        List longPrefix = this.restApp.restClient.getAllContexts(0, -1, ".thisIsAVeryLongPrefixThatWillNeverMatch");
        Assertions.assertEquals(Collections.emptyList(), (Object)longPrefix, (String)"Long non-matching prefix should return empty list");
        List dotPrefixCtx = this.restApp.restClient.getAllContexts(0, -1, ".");
        Assertions.assertEquals((Object)ImmutableList.of((Object)".", (Object)".test"), (Object)dotPrefixCtx, (String)"Prefix '.' should match all contexts as all contexts start with '.'");
        List upperCaseFilter = this.restApp.restClient.getAllContexts(0, -1, ".TEST");
        Assertions.assertEquals(Collections.emptyList(), (Object)upperCaseFilter, (String)"Context prefix filter should be case-sensitive");
    }
}

