/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.tools;

import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleKind;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.tools.CheckSchemaCompatibility;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class CheckSchemaCompatibilityTest {
    @Mock
    private SchemaRegistryClient sourceClient;
    @Mock
    private SchemaRegistryClient targetClient;
    private CheckSchemaCompatibility tool;
    private static final String SUBJECT_NAME = "test-subject";
    private static final String SCHEMA_STRING_1 = "{\"type\":\"record\",\"name\":\"User\",\"fields\":[{\"name\":\"id\",\"type\":\"int\"}]}";
    private static final String SCHEMA_STRING_2 = "{\"type\":\"record\",\"name\":\"User\",\"fields\":[{\"name\":\"id\",\"type\":\"int\"},{\"name\":\"name\",\"type\":\"string\"}]}";
    private static final String SCHEMA_STRING_TEMPLATE = "{\"type\":\"record\",\"name\":\"%s\",\"fields\":[{\"name\":\"id\",\"type\":\"int\"}]}";

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks((Object)this);
        this.tool = new CheckSchemaCompatibility();
        Mockito.when((Object)this.sourceClient.parseSchema((Schema)ArgumentMatchers.any(Schema.class))).thenAnswer(invocation -> {
            Schema schema = (Schema)invocation.getArgument(0);
            return Optional.of(new AvroSchema(schema.getSchema(), schema.getReferences(), new HashMap(), schema.getMetadata(), schema.getRuleSet(), schema.getVersion(), false));
        });
        Mockito.when((Object)this.targetClient.parseSchema((Schema)ArgumentMatchers.any(Schema.class))).thenAnswer(invocation -> {
            Schema schema = (Schema)invocation.getArgument(0);
            return Optional.of(new AvroSchema(schema.getSchema(), schema.getReferences(), new HashMap(), schema.getMetadata(), schema.getRuleSet(), schema.getVersion(), false));
        });
    }

    @Test
    void testCompareSubjects_PerfectMatch() throws Exception {
        List<String> sourceSubjects = Arrays.asList("subject1", "subject2");
        List<String> targetSubjects = Arrays.asList("subject1", "subject2");
        this.setupSuccessfulSubjectComparison("subject1");
        this.setupSuccessfulSubjectComparison("subject2");
        boolean result = this.tool.compareSubjects(sourceSubjects, targetSubjects, this.sourceClient, this.targetClient);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void testCompareSubjects_SourceHasMoreSubjects() throws Exception {
        List<String> sourceSubjects = Arrays.asList("subject1", "subject2");
        List<String> targetSubjects = Arrays.asList("subject1");
        Mockito.when((Object)this.sourceClient.getAllVersions("subject1")).thenReturn(Arrays.asList(1));
        Mockito.when((Object)this.targetClient.getAllVersions("subject1")).thenReturn(Arrays.asList(1));
        SchemaMetadata sourceMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata("subject1", 1)).thenReturn((Object)sourceMetadata);
        Mockito.when((Object)this.targetClient.getSchemaMetadata("subject1", 1)).thenReturn((Object)sourceMetadata);
        boolean result = this.tool.compareSubjects(sourceSubjects, targetSubjects, this.sourceClient, this.targetClient);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void testCompareSubjects_TargetHasMoreSubjects() throws Exception {
        List<String> sourceSubjects = Arrays.asList("subject1");
        List<String> targetSubjects = Arrays.asList("subject1", "subject2");
        boolean result = this.tool.compareSubjects(sourceSubjects, targetSubjects, this.sourceClient, this.targetClient);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void testCompareSubjects_EmptyRegistries() throws Exception {
        List sourceSubjects = Collections.emptyList();
        List targetSubjects = Collections.emptyList();
        boolean result = this.tool.compareSubjects(sourceSubjects, targetSubjects, this.sourceClient, this.targetClient);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void testCompareSubjects_OnlySourceEmpty() throws Exception {
        List sourceSubjects = Collections.emptyList();
        List<String> targetSubjects = Arrays.asList("subject1");
        boolean result = this.tool.compareSubjects(sourceSubjects, targetSubjects, this.sourceClient, this.targetClient);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void testCompareSubjects_OnlyTargetEmpty() throws Exception {
        List<String> sourceSubjects = Arrays.asList("subject1");
        List targetSubjects = Collections.emptyList();
        boolean result = this.tool.compareSubjects(sourceSubjects, targetSubjects, this.sourceClient, this.targetClient);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void testCompareSubjects_SubjectComparisonFails() throws Exception {
        List<String> sourceSubjects = Arrays.asList("subject1");
        List<String> targetSubjects = Arrays.asList("subject1");
        this.setupFailedSubjectComparison("subject1");
        boolean result = this.tool.compareSubjects(sourceSubjects, targetSubjects, this.sourceClient, this.targetClient);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void testCompareSubject_IdenticalSchemas() throws Exception {
        this.setupIdenticalSchemas();
        boolean result = this.tool.compareSubject(this.sourceClient, this.targetClient, SUBJECT_NAME);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void testCompareSubject_SourceHasMoreVersions() throws Exception {
        Mockito.when((Object)this.sourceClient.getAllVersions(SUBJECT_NAME)).thenReturn(Arrays.asList(1, 2, 3));
        Mockito.when((Object)this.targetClient.getAllVersions(SUBJECT_NAME)).thenReturn(Arrays.asList(1, 2));
        SchemaMetadata sourceMetadata1 = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        SchemaMetadata targetMetadata1 = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)sourceMetadata1);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)targetMetadata1);
        SchemaMetadata sourceMetadata2 = this.createSchemaMetadata(2, 100, SCHEMA_STRING_1);
        SchemaMetadata targetMetadata2 = this.createSchemaMetadata(2, 100, SCHEMA_STRING_1);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(SUBJECT_NAME, 2)).thenReturn((Object)sourceMetadata2);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(SUBJECT_NAME, 2)).thenReturn((Object)targetMetadata2);
        boolean result = this.tool.compareSubject(this.sourceClient, this.targetClient, SUBJECT_NAME);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void testCompareSubject_DifferentVersionNumbers() throws Exception {
        Mockito.when((Object)this.sourceClient.getAllVersions(SUBJECT_NAME)).thenReturn(Arrays.asList(1, 2));
        Mockito.when((Object)this.targetClient.getAllVersions(SUBJECT_NAME)).thenReturn(Arrays.asList(1, 3));
        SchemaMetadata sourceMetadata1 = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        SchemaMetadata targetMetadata1 = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)sourceMetadata1);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)targetMetadata1);
        boolean result = this.tool.compareSubject(this.sourceClient, this.targetClient, SUBJECT_NAME);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void testCompareSubject_NoCommonVersions() throws Exception {
        Mockito.when((Object)this.sourceClient.getAllVersions(SUBJECT_NAME)).thenReturn(Arrays.asList(1, 2));
        Mockito.when((Object)this.targetClient.getAllVersions(SUBJECT_NAME)).thenReturn(Arrays.asList(3, 4));
        boolean result = this.tool.compareSubject(this.sourceClient, this.targetClient, SUBJECT_NAME);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void testCompareSubject_TargetHasMoreVersions() throws Exception {
        Mockito.when((Object)this.sourceClient.getAllVersions(SUBJECT_NAME)).thenReturn(Arrays.asList(1));
        Mockito.when((Object)this.targetClient.getAllVersions(SUBJECT_NAME)).thenReturn(Arrays.asList(1, 2));
        boolean result = this.tool.compareSubject(this.sourceClient, this.targetClient, SUBJECT_NAME);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void testCompareSubject_SchemaMismatch() throws Exception {
        Mockito.when((Object)this.sourceClient.getAllVersions(SUBJECT_NAME)).thenReturn(Arrays.asList(1));
        Mockito.when((Object)this.targetClient.getAllVersions(SUBJECT_NAME)).thenReturn(Arrays.asList(1));
        SchemaMetadata sourceMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        SchemaMetadata targetMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_2);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)sourceMetadata);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)targetMetadata);
        boolean result = this.tool.compareSubject(this.sourceClient, this.targetClient, SUBJECT_NAME);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void testCompareSubject_VersionNumberMismatch() throws Exception {
        Mockito.when((Object)this.sourceClient.getAllVersions(SUBJECT_NAME)).thenReturn(Arrays.asList(1));
        Mockito.when((Object)this.targetClient.getAllVersions(SUBJECT_NAME)).thenReturn(Arrays.asList(1));
        SchemaMetadata sourceMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        SchemaMetadata targetMetadata = this.createSchemaMetadata(2, 100, SCHEMA_STRING_1);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)sourceMetadata);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)targetMetadata);
        boolean result = this.tool.compareSubject(this.sourceClient, this.targetClient, SUBJECT_NAME);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void testCompareSubject_ParseFailure() throws Exception {
        Mockito.when((Object)this.sourceClient.getAllVersions(SUBJECT_NAME)).thenReturn(Arrays.asList(1));
        Mockito.when((Object)this.targetClient.getAllVersions(SUBJECT_NAME)).thenReturn(Arrays.asList(1));
        SchemaMetadata sourceMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        SchemaMetadata targetMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)sourceMetadata);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)targetMetadata);
        Mockito.when((Object)this.sourceClient.parseSchema((Schema)ArgumentMatchers.any(Schema.class))).thenReturn(Optional.empty());
        boolean result = this.tool.compareSubject(this.sourceClient, this.targetClient, SUBJECT_NAME);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void testCompareSubject_MultipleVersionsSuccess() throws Exception {
        Mockito.when((Object)this.sourceClient.getAllVersions(SUBJECT_NAME)).thenReturn(Arrays.asList(1, 2));
        Mockito.when((Object)this.targetClient.getAllVersions(SUBJECT_NAME)).thenReturn(Arrays.asList(1, 2));
        SchemaMetadata sourceMetadata1 = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        SchemaMetadata targetMetadata1 = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)sourceMetadata1);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)targetMetadata1);
        SchemaMetadata sourceMetadata2 = this.createSchemaMetadata(2, 101, SCHEMA_STRING_2);
        SchemaMetadata targetMetadata2 = this.createSchemaMetadata(2, 101, SCHEMA_STRING_2);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(SUBJECT_NAME, 2)).thenReturn((Object)sourceMetadata2);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(SUBJECT_NAME, 2)).thenReturn((Object)targetMetadata2);
        boolean result = this.tool.compareSubject(this.sourceClient, this.targetClient, SUBJECT_NAME);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void testCompareSubject_MultipleVersionsOneFails() throws Exception {
        Mockito.when((Object)this.sourceClient.getAllVersions(SUBJECT_NAME)).thenReturn(Arrays.asList(1, 2));
        Mockito.when((Object)this.targetClient.getAllVersions(SUBJECT_NAME)).thenReturn(Arrays.asList(1, 2));
        SchemaMetadata sourceMetadata1 = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        SchemaMetadata targetMetadata1 = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)sourceMetadata1);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)targetMetadata1);
        SchemaMetadata sourceMetadata2 = this.createSchemaMetadata(2, 101, SCHEMA_STRING_1);
        SchemaMetadata targetMetadata2 = this.createSchemaMetadata(2, 101, SCHEMA_STRING_2);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(SUBJECT_NAME, 2)).thenReturn((Object)sourceMetadata2);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(SUBJECT_NAME, 2)).thenReturn((Object)targetMetadata2);
        boolean result = this.tool.compareSubject(this.sourceClient, this.targetClient, SUBJECT_NAME);
        Assertions.assertFalse((boolean)result);
    }

    private void setupIdenticalSchemas() throws IOException, RestClientException {
        Mockito.when((Object)this.sourceClient.getAllVersions(SUBJECT_NAME)).thenReturn(Arrays.asList(1));
        Mockito.when((Object)this.targetClient.getAllVersions(SUBJECT_NAME)).thenReturn(Arrays.asList(1));
        SchemaMetadata sourceMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        SchemaMetadata targetMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)sourceMetadata);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)targetMetadata);
    }

    private void setupSuccessfulSubjectComparison(String subject) throws IOException, RestClientException {
        Mockito.when((Object)this.sourceClient.getAllVersions(subject)).thenReturn(Arrays.asList(1));
        Mockito.when((Object)this.targetClient.getAllVersions(subject)).thenReturn(Arrays.asList(1));
        SchemaMetadata metadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(subject, 1)).thenReturn((Object)metadata);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(subject, 1)).thenReturn((Object)metadata);
    }

    private void setupFailedSubjectComparison(String subject) throws IOException, RestClientException {
        Mockito.when((Object)this.sourceClient.getAllVersions(subject)).thenReturn(Arrays.asList(1));
        Mockito.when((Object)this.targetClient.getAllVersions(subject)).thenReturn(Arrays.asList(2));
    }

    private SchemaMetadata createSchemaMetadata(int version, int id, String schemaString) {
        return new SchemaMetadata(id, version, "AVRO", Collections.emptyList(), schemaString);
    }

    @Test
    void testCompareVersion_IdenticalVersions() throws Exception {
        SchemaMetadata sourceMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        SchemaMetadata targetMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)sourceMetadata);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)targetMetadata);
        boolean result = this.tool.compareVersion(this.sourceClient, this.targetClient, SUBJECT_NAME, Integer.valueOf(1));
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void testCompareVersion_DifferentSchemas() throws Exception {
        SchemaMetadata sourceMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        SchemaMetadata targetMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_2);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)sourceMetadata);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)targetMetadata);
        boolean result = this.tool.compareVersion(this.sourceClient, this.targetClient, SUBJECT_NAME, Integer.valueOf(1));
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void testCompareVersion_SourceParseFailure() throws Exception {
        SchemaMetadata sourceMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        SchemaMetadata targetMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)sourceMetadata);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)targetMetadata);
        Mockito.when((Object)this.sourceClient.parseSchema((Schema)ArgumentMatchers.any(Schema.class))).thenReturn(Optional.empty());
        Mockito.when((Object)this.targetClient.parseSchema((Schema)ArgumentMatchers.any(Schema.class))).thenReturn(Optional.of(new AvroSchema(SCHEMA_STRING_1)));
        boolean result = this.tool.compareVersion(this.sourceClient, this.targetClient, SUBJECT_NAME, Integer.valueOf(1));
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void testCompareVersion_TargetParseFailure() throws Exception {
        SchemaMetadata sourceMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        SchemaMetadata targetMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)sourceMetadata);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)targetMetadata);
        Mockito.when((Object)this.targetClient.parseSchema((Schema)ArgumentMatchers.any(Schema.class))).thenReturn(Optional.empty());
        boolean result = this.tool.compareVersion(this.sourceClient, this.targetClient, SUBJECT_NAME, Integer.valueOf(1));
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void testCompareVersion_VersionNumberMismatch() throws Exception {
        SchemaMetadata sourceMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        SchemaMetadata targetMetadata = this.createSchemaMetadata(2, 100, SCHEMA_STRING_1);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)sourceMetadata);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)targetMetadata);
        boolean result = this.tool.compareVersion(this.sourceClient, this.targetClient, SUBJECT_NAME, Integer.valueOf(1));
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void testCompareVersion_DifferentSchemaIds() throws Exception {
        SchemaMetadata sourceMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        SchemaMetadata targetMetadata = this.createSchemaMetadata(1, 999, SCHEMA_STRING_1);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)sourceMetadata);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)targetMetadata);
        boolean result = this.tool.compareVersion(this.sourceClient, this.targetClient, SUBJECT_NAME, Integer.valueOf(1));
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void testCompareVersion_DifferentMetadata() throws Exception {
        SchemaMetadata sourceMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        SchemaMetadata targetMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)sourceMetadata);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)targetMetadata);
        HashMap<String, String> sourceProperties = new HashMap<String, String>();
        sourceProperties.put("env", "production");
        sourceProperties.put("owner", "team-a");
        Metadata sourceSchemaMetadata = new Metadata(null, sourceProperties, null);
        HashMap<String, String> targetProperties = new HashMap<String, String>();
        targetProperties.put("env", "staging");
        targetProperties.put("owner", "team-b");
        Metadata targetSchemaMetadata = new Metadata(null, targetProperties, null);
        AvroSchema sourceSchema = new AvroSchema(SCHEMA_STRING_1, Collections.emptyList(), Collections.emptyMap(), sourceSchemaMetadata, null, null, false);
        AvroSchema targetSchema = new AvroSchema(SCHEMA_STRING_1, Collections.emptyList(), Collections.emptyMap(), targetSchemaMetadata, null, null, false);
        Mockito.when((Object)this.sourceClient.parseSchema((Schema)ArgumentMatchers.any(Schema.class))).thenReturn(Optional.of(sourceSchema));
        Mockito.when((Object)this.targetClient.parseSchema((Schema)ArgumentMatchers.any(Schema.class))).thenReturn(Optional.of(targetSchema));
        boolean result = this.tool.compareVersion(this.sourceClient, this.targetClient, SUBJECT_NAME, Integer.valueOf(1));
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void testCompareVersion_DifferentRuleSet() throws Exception {
        SchemaMetadata sourceMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        SchemaMetadata targetMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)sourceMetadata);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)targetMetadata);
        Rule sourceRule = new Rule("encryption-rule", "Encrypt PII fields", RuleKind.TRANSFORM, RuleMode.WRITEREAD, "ENCRYPT", Collections.singleton("PII"), Collections.singletonMap("algorithm", "AES"), "encrypt($.ssn)", "NONE", "ERROR", false);
        Rule targetRule = new Rule("validation-rule", "Validate email format", RuleKind.CONDITION, RuleMode.WRITEREAD, "CEL", Collections.singleton("email"), Collections.emptyMap(), "size(value) > 0", "NONE", "ERROR", false);
        RuleSet sourceRuleSet = new RuleSet(null, Arrays.asList(sourceRule), null);
        RuleSet targetRuleSet = new RuleSet(null, Arrays.asList(targetRule), null);
        AvroSchema sourceSchema = new AvroSchema(SCHEMA_STRING_1, Collections.emptyList(), Collections.emptyMap(), null, sourceRuleSet, null, false);
        AvroSchema targetSchema = new AvroSchema(SCHEMA_STRING_1, Collections.emptyList(), Collections.emptyMap(), null, targetRuleSet, null, false);
        Mockito.when((Object)this.sourceClient.parseSchema((Schema)ArgumentMatchers.any(Schema.class))).thenReturn(Optional.of(sourceSchema));
        Mockito.when((Object)this.targetClient.parseSchema((Schema)ArgumentMatchers.any(Schema.class))).thenReturn(Optional.of(targetSchema));
        boolean result = this.tool.compareVersion(this.sourceClient, this.targetClient, SUBJECT_NAME, Integer.valueOf(1));
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void testCompareVersion_OneWithMetadataOneWithout() throws Exception {
        SchemaMetadata sourceMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        SchemaMetadata targetMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)sourceMetadata);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)targetMetadata);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("env", "production");
        Metadata metadata = new Metadata(null, properties, null);
        AvroSchema sourceSchema = new AvroSchema(SCHEMA_STRING_1, Collections.emptyList(), Collections.emptyMap(), metadata, null, null, false);
        AvroSchema targetSchema = new AvroSchema(SCHEMA_STRING_1, Collections.emptyList(), Collections.emptyMap(), null, null, null, false);
        Mockito.when((Object)this.sourceClient.parseSchema((Schema)ArgumentMatchers.any(Schema.class))).thenReturn(Optional.of(sourceSchema));
        Mockito.when((Object)this.targetClient.parseSchema((Schema)ArgumentMatchers.any(Schema.class))).thenReturn(Optional.of(targetSchema));
        boolean result = this.tool.compareVersion(this.sourceClient, this.targetClient, SUBJECT_NAME, Integer.valueOf(1));
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void testCompareVersion_OneWithRuleSetOneWithout() throws Exception {
        SchemaMetadata sourceMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        SchemaMetadata targetMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)sourceMetadata);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)targetMetadata);
        Rule rule = new Rule("validation-rule", "Validate field", RuleKind.CONDITION, RuleMode.WRITEREAD, "CEL", Collections.emptySet(), Collections.emptyMap(), "size(value) > 0", "NONE", "ERROR", false);
        RuleSet ruleSet = new RuleSet(null, Arrays.asList(rule), null);
        AvroSchema sourceSchema = new AvroSchema(SCHEMA_STRING_1, Collections.emptyList(), Collections.emptyMap(), null, ruleSet, null, false);
        AvroSchema targetSchema = new AvroSchema(SCHEMA_STRING_1, Collections.emptyList(), Collections.emptyMap(), null, null, null, false);
        Mockito.when((Object)this.sourceClient.parseSchema((Schema)ArgumentMatchers.any(Schema.class))).thenReturn(Optional.of(sourceSchema));
        Mockito.when((Object)this.targetClient.parseSchema((Schema)ArgumentMatchers.any(Schema.class))).thenReturn(Optional.of(targetSchema));
        boolean result = this.tool.compareVersion(this.sourceClient, this.targetClient, SUBJECT_NAME, Integer.valueOf(1));
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void testCompareVersion_IdenticalMetadataRuleSetReferences() throws Exception {
        SchemaMetadata sourceMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        SchemaMetadata targetMetadata = this.createSchemaMetadata(1, 100, SCHEMA_STRING_1);
        Mockito.when((Object)this.sourceClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)sourceMetadata);
        Mockito.when((Object)this.targetClient.getSchemaMetadata(SUBJECT_NAME, 1)).thenReturn((Object)targetMetadata);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("env", "production");
        Metadata metadata = new Metadata(null, properties, null);
        Rule rule = new Rule("validation-rule", "Validate field", RuleKind.CONDITION, RuleMode.WRITEREAD, "CEL", Collections.emptySet(), Collections.emptyMap(), "size(value) > 0", "NONE", "ERROR", false);
        RuleSet ruleSet = new RuleSet(null, Arrays.asList(rule), null);
        SchemaReference reference = new SchemaReference("io.confluent.kafka.example.User", "user-schema", Integer.valueOf(1));
        AvroSchema sourceSchema = new AvroSchema(SCHEMA_STRING_1, Arrays.asList(reference), Collections.emptyMap(), metadata, ruleSet, null, false);
        AvroSchema targetSchema = new AvroSchema(SCHEMA_STRING_1, Arrays.asList(reference), Collections.emptyMap(), metadata, ruleSet, null, false);
        Mockito.when((Object)this.sourceClient.parseSchema((Schema)ArgumentMatchers.any(Schema.class))).thenReturn(Optional.of(sourceSchema));
        Mockito.when((Object)this.targetClient.parseSchema((Schema)ArgumentMatchers.any(Schema.class))).thenReturn(Optional.of(targetSchema));
        boolean result = this.tool.compareVersion(this.sourceClient, this.targetClient, SUBJECT_NAME, Integer.valueOf(1));
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void testCompareSubjects_SourceHasExtraVersionWithDuplicateSchemaId() throws Exception {
        List<String> sourceSubjects = Arrays.asList("subject1", "subject2");
        List<String> targetSubjects = Arrays.asList("subject1", "subject2");
        Mockito.when((Object)this.targetClient.getAllVersions("subject1")).thenReturn(Arrays.asList(1, 2, 3));
        Mockito.when((Object)this.targetClient.getAllVersions("subject2")).thenReturn(Arrays.asList(1, 2, 3));
        Mockito.when((Object)this.sourceClient.getAllVersions("subject1")).thenReturn(Arrays.asList(1, 2, 3, 4));
        Mockito.when((Object)this.sourceClient.getAllVersions("subject2")).thenReturn(Arrays.asList(1, 2, 3));
        Mockito.when((Object)this.targetClient.getSchemaMetadata("subject1", 1)).thenReturn((Object)this.createSchemaMetadata(1, 1, SCHEMA_STRING_1));
        Mockito.when((Object)this.targetClient.getSchemaMetadata("subject1", 2)).thenReturn((Object)this.createSchemaMetadata(2, 3, SCHEMA_STRING_1));
        Mockito.when((Object)this.targetClient.getSchemaMetadata("subject1", 3)).thenReturn((Object)this.createSchemaMetadata(3, 5, SCHEMA_STRING_1));
        Mockito.when((Object)this.targetClient.getSchemaMetadata("subject2", 1)).thenReturn((Object)this.createSchemaMetadata(1, 2, SCHEMA_STRING_2));
        Mockito.when((Object)this.targetClient.getSchemaMetadata("subject2", 2)).thenReturn((Object)this.createSchemaMetadata(2, 4, SCHEMA_STRING_2));
        Mockito.when((Object)this.targetClient.getSchemaMetadata("subject2", 3)).thenReturn((Object)this.createSchemaMetadata(3, 6, SCHEMA_STRING_2));
        Mockito.when((Object)this.sourceClient.getSchemaMetadata("subject1", 1)).thenReturn((Object)this.createSchemaMetadata(1, 1, SCHEMA_STRING_1));
        Mockito.when((Object)this.sourceClient.getSchemaMetadata("subject1", 2)).thenReturn((Object)this.createSchemaMetadata(2, 3, SCHEMA_STRING_1));
        Mockito.when((Object)this.sourceClient.getSchemaMetadata("subject1", 3)).thenReturn((Object)this.createSchemaMetadata(3, 5, SCHEMA_STRING_1));
        Mockito.when((Object)this.sourceClient.getSchemaMetadata("subject1", 4)).thenReturn((Object)this.createSchemaMetadata(4, 7, SCHEMA_STRING_1));
        Mockito.when((Object)this.sourceClient.getSchemaMetadata("subject2", 1)).thenReturn((Object)this.createSchemaMetadata(1, 2, SCHEMA_STRING_2));
        Mockito.when((Object)this.sourceClient.getSchemaMetadata("subject2", 2)).thenReturn((Object)this.createSchemaMetadata(2, 4, SCHEMA_STRING_2));
        Mockito.when((Object)this.sourceClient.getSchemaMetadata("subject2", 3)).thenReturn((Object)this.createSchemaMetadata(3, 6, SCHEMA_STRING_1));
        boolean result = this.tool.compareSubjects(sourceSubjects, targetSubjects, this.sourceClient, this.targetClient);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void testCompareSubjects_withMismatchId() throws Exception {
        List<String> sourceSubjects = Arrays.asList("subject1", "subject2");
        List<String> targetSubjects = Arrays.asList("subject1", "subject2");
        Mockito.when((Object)this.targetClient.getAllVersions("subject1")).thenReturn(Arrays.asList(1, 2, 3));
        Mockito.when((Object)this.targetClient.getAllVersions("subject2")).thenReturn(Arrays.asList(1, 2));
        Mockito.when((Object)this.sourceClient.getAllVersions("subject1")).thenReturn(Arrays.asList(1, 2));
        Mockito.when((Object)this.sourceClient.getAllVersions("subject2")).thenReturn(Arrays.asList(1, 2, 3));
        Mockito.when((Object)this.targetClient.getSchemaMetadata("subject1", 1)).thenReturn((Object)this.createSchemaMetadata(1, 1, SCHEMA_STRING_1));
        Mockito.when((Object)this.targetClient.getSchemaMetadata("subject1", 2)).thenReturn((Object)this.createSchemaMetadata(2, 3, SCHEMA_STRING_1));
        Mockito.when((Object)this.targetClient.getSchemaMetadata("subject1", 2)).thenReturn((Object)this.createSchemaMetadata(3, 5, SCHEMA_STRING_1));
        Mockito.when((Object)this.targetClient.getSchemaMetadata("subject2", 1)).thenReturn((Object)this.createSchemaMetadata(1, 2, SCHEMA_STRING_2));
        Mockito.when((Object)this.targetClient.getSchemaMetadata("subject2", 2)).thenReturn((Object)this.createSchemaMetadata(2, 4, SCHEMA_STRING_2));
        Mockito.when((Object)this.sourceClient.getSchemaMetadata("subject1", 1)).thenReturn((Object)this.createSchemaMetadata(1, 1, SCHEMA_STRING_1));
        Mockito.when((Object)this.sourceClient.getSchemaMetadata("subject1", 2)).thenReturn((Object)this.createSchemaMetadata(2, 3, SCHEMA_STRING_1));
        Mockito.when((Object)this.sourceClient.getSchemaMetadata("subject2", 1)).thenReturn((Object)this.createSchemaMetadata(1, 2, SCHEMA_STRING_2));
        Mockito.when((Object)this.sourceClient.getSchemaMetadata("subject2", 2)).thenReturn((Object)this.createSchemaMetadata(2, 4, SCHEMA_STRING_2));
        Mockito.when((Object)this.sourceClient.getSchemaMetadata("subject2", 3)).thenReturn((Object)this.createSchemaMetadata(3, 5, String.format(SCHEMA_STRING_TEMPLATE, "user5")));
        boolean result = this.tool.compareSubjects(sourceSubjects, targetSubjects, this.sourceClient, this.targetClient);
        Assertions.assertFalse((boolean)result);
    }
}

