/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.ParsedSchemaHolder;
import io.confluent.kafka.schemaregistry.client.SchemaVersionFetcher;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.TagSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.client.rest.utils.UrlList;
import io.confluent.kafka.schemaregistry.exceptions.IdGenerationException;
import io.confluent.kafka.schemaregistry.exceptions.IncompatibleSchemaException;
import io.confluent.kafka.schemaregistry.exceptions.InvalidSchemaException;
import io.confluent.kafka.schemaregistry.exceptions.OperationNotPermittedException;
import io.confluent.kafka.schemaregistry.exceptions.ReferenceExistsException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryInitializationException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryRequestForwardingException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryTimeoutException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaTooLargeException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaVersionNotSoftDeletedException;
import io.confluent.kafka.schemaregistry.exceptions.SubjectNotSoftDeletedException;
import io.confluent.kafka.schemaregistry.exceptions.UnknownLeaderException;
import io.confluent.kafka.schemaregistry.id.IdGenerator;
import io.confluent.kafka.schemaregistry.id.IncrementalIdGenerator;
import io.confluent.kafka.schemaregistry.leaderelector.kafka.KafkaGroupLeaderElector;
import io.confluent.kafka.schemaregistry.metrics.MetricsContainer;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.extensions.SchemaRegistryResourceExtension;
import io.confluent.kafka.schemaregistry.storage.AbstractSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.ClearSubjectKey;
import io.confluent.kafka.schemaregistry.storage.ClearSubjectValue;
import io.confluent.kafka.schemaregistry.storage.CloseableIterator;
import io.confluent.kafka.schemaregistry.storage.CompositeSchemaUpdateHandler;
import io.confluent.kafka.schemaregistry.storage.ConfigKey;
import io.confluent.kafka.schemaregistry.storage.ConfigValue;
import io.confluent.kafka.schemaregistry.storage.ContextKey;
import io.confluent.kafka.schemaregistry.storage.ContextValue;
import io.confluent.kafka.schemaregistry.storage.DeleteSubjectKey;
import io.confluent.kafka.schemaregistry.storage.DeleteSubjectValue;
import io.confluent.kafka.schemaregistry.storage.InMemoryCache;
import io.confluent.kafka.schemaregistry.storage.KafkaStore;
import io.confluent.kafka.schemaregistry.storage.KafkaStoreMessageHandler;
import io.confluent.kafka.schemaregistry.storage.LazyParsedSchemaHolder;
import io.confluent.kafka.schemaregistry.storage.LeaderAwareSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.LeaderElector;
import io.confluent.kafka.schemaregistry.storage.LookupCache;
import io.confluent.kafka.schemaregistry.storage.LookupFilter;
import io.confluent.kafka.schemaregistry.storage.MD5;
import io.confluent.kafka.schemaregistry.storage.Mode;
import io.confluent.kafka.schemaregistry.storage.ModeKey;
import io.confluent.kafka.schemaregistry.storage.ModeValue;
import io.confluent.kafka.schemaregistry.storage.NoopKey;
import io.confluent.kafka.schemaregistry.storage.SchemaIdAndSubjects;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryIdentity;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryValue;
import io.confluent.kafka.schemaregistry.storage.SchemaUpdateHandler;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.SubjectKey;
import io.confluent.kafka.schemaregistry.storage.encoder.MetadataEncoderService;
import io.confluent.kafka.schemaregistry.storage.exceptions.EntryTooLargeException;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreException;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreInitializationException;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreTimeoutException;
import io.confluent.kafka.schemaregistry.storage.serialization.Serializer;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.confluent.rest.NamedURI;
import io.confluent.rest.exceptions.RestException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.apache.avro.reflect.Nullable;
import org.apache.kafka.clients.admin.AdminClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSchemaRegistry
extends AbstractSchemaRegistry
implements LeaderAwareSchemaRegistry {
    private static final Logger log = LoggerFactory.getLogger(KafkaSchemaRegistry.class);
    final KafkaStore<SchemaRegistryKey, SchemaRegistryValue> kafkaStore;
    private final Serializer<SchemaRegistryKey, SchemaRegistryValue> serializer;
    private final SchemaRegistryIdentity myIdentity;
    private final int kafkaStoreTimeoutMs;
    private final int initTimeout;
    private final boolean initWaitForReader;
    private final int kafkaStoreMaxRetries;
    private final boolean delayLeaderElection;
    private final boolean enableStoreHealthCheck;
    private SchemaRegistryIdentity leaderIdentity;
    private RestService leaderRestService;
    private final int leaderConnectTimeoutMs;
    private final int leaderReadTimeoutMs;
    private final IdGenerator idGenerator;
    private LeaderElector leaderElector = null;
    private final String kafkaClusterId;
    private final String groupId;
    private final List<Consumer<Boolean>> leaderChangeListeners = new CopyOnWriteArrayList<Consumer<Boolean>>();

    public KafkaSchemaRegistry(SchemaRegistryConfig config, Serializer<SchemaRegistryKey, SchemaRegistryValue> serializer) throws SchemaRegistryException {
        super(config, KafkaSchemaRegistry.initMetricsContainer(config, KafkaSchemaRegistry.kafkaClusterId(config)));
        Boolean leaderEligibility = config.getBoolean("master.eligibility");
        if (leaderEligibility == null) {
            leaderEligibility = config.getBoolean("leader.eligibility");
        }
        this.delayLeaderElection = config.getBoolean("leader.election.delay");
        this.enableStoreHealthCheck = config.getBoolean("enable.store.health.check");
        String interInstanceListenerNameConfig = config.interInstanceListenerName();
        NamedURI internalListener = KafkaSchemaRegistry.getInterInstanceListener(config.getListeners(), interInstanceListenerNameConfig, config.interInstanceProtocol());
        log.info("Found internal listener: {}", (Object)internalListener);
        boolean isEligibleForLeaderElector = leaderEligibility;
        this.myIdentity = KafkaSchemaRegistry.getMyIdentity(internalListener, isEligibleForLeaderElector, config);
        log.info("Setting my identity to {}", (Object)this.myIdentity);
        this.leaderConnectTimeoutMs = config.getInt("leader.connect.timeout.ms");
        this.leaderReadTimeoutMs = config.getInt("leader.read.timeout.ms");
        this.kafkaStoreTimeoutMs = config.getInt("kafkastore.timeout.ms");
        this.initTimeout = config.getInt("kafkastore.init.timeout.ms");
        this.initWaitForReader = config.getBoolean("kafkastore.init.wait.for.reader");
        this.kafkaStoreMaxRetries = config.getInt("kafkastore.write.max.retries");
        this.serializer = serializer;
        this.kafkaClusterId = KafkaSchemaRegistry.kafkaClusterId(config);
        this.groupId = config.getString("schema.registry.group.id");
        this.lookupCache = this.lookupCache();
        this.idGenerator = this.identityGenerator(config);
        this.store = this.kafkaStore = this.kafkaStore(config);
        this.metadataEncoder = new MetadataEncoderService(this);
    }

    private static MetricsContainer initMetricsContainer(SchemaRegistryConfig config, String kafkaClusterId) {
        return new MetricsContainer(config, kafkaClusterId);
    }

    @VisibleForTesting
    static SchemaRegistryIdentity getMyIdentity(NamedURI internalListener, boolean isEligibleForLeaderElector, SchemaRegistryConfig config) {
        AbstractSchemaRegistry.SchemeAndPort schemeAndPort = new AbstractSchemaRegistry.SchemeAndPort(internalListener.getUri().getScheme(), config.originals().containsKey("host.port") ? config.getInt("host.port").intValue() : internalListener.getUri().getPort());
        String host = config.getString("host.name");
        return new SchemaRegistryIdentity(host, schemeAndPort.port, isEligibleForLeaderElector, schemeAndPort.scheme);
    }

    protected KafkaStore<SchemaRegistryKey, SchemaRegistryValue> kafkaStore(SchemaRegistryConfig config) throws SchemaRegistryException {
        return new KafkaStore<SchemaRegistryKey, SchemaRegistryValue>(config, this.getSchemaUpdateHandler(config), this.serializer, this.lookupCache, new NoopKey());
    }

    protected SchemaUpdateHandler getSchemaUpdateHandler(SchemaRegistryConfig config) {
        Map handlerConfigs = config.originalsWithPrefix("kafkastore.update.handlers.");
        handlerConfigs.put("schemaRegistry", this);
        List customSchemaHandlers = config.getConfiguredInstances("kafkastore.update.handlers", SchemaUpdateHandler.class, handlerConfigs);
        KafkaStoreMessageHandler storeHandler = new KafkaStoreMessageHandler(this, this.getLookupCache(), this.getIdentityGenerator());
        for (SchemaUpdateHandler customSchemaHandler : customSchemaHandlers) {
            log.info("Registering custom schema handler: {}", (Object)customSchemaHandler.getClass().getName());
        }
        customSchemaHandlers.add(storeHandler);
        return new CompositeSchemaUpdateHandler(customSchemaHandlers);
    }

    protected LookupCache<SchemaRegistryKey, SchemaRegistryValue> lookupCache() {
        return new InMemoryCache<SchemaRegistryKey, SchemaRegistryValue>(this.serializer);
    }

    public Serializer<SchemaRegistryKey, SchemaRegistryValue> getSerializer() {
        return this.serializer;
    }

    protected IdGenerator identityGenerator(SchemaRegistryConfig config) {
        config.checkBootstrapServers();
        IncrementalIdGenerator idGenerator = new IncrementalIdGenerator(this);
        idGenerator.configure(config);
        return idGenerator;
    }

    public IdGenerator getIdentityGenerator() {
        return this.idGenerator;
    }

    @Override
    public void init() throws SchemaRegistryException {
        try {
            this.kafkaStore.init();
        }
        catch (StoreInitializationException e) {
            throw new SchemaRegistryInitializationException("Error initializing kafka store while initializing schema registry", e);
        }
        try {
            this.metadataEncoder.init();
        }
        catch (Exception e) {
            throw new SchemaRegistryInitializationException("Error initializing metadata encoder while initializing schema registry", e);
        }
        this.config.checkBootstrapServers();
        if (!this.delayLeaderElection) {
            this.electLeader();
        }
    }

    @Override
    public void postInit() throws SchemaRegistryException {
        if (this.delayLeaderElection) {
            this.electLeader();
        }
        this.initialized.set(true);
    }

    private void electLeader() throws SchemaRegistryException {
        log.info("Joining schema registry with Kafka-based coordination");
        this.leaderElector = new KafkaGroupLeaderElector(this.config, this.myIdentity, this);
        try {
            this.leaderElector.init();
        }
        catch (SchemaRegistryStoreException e) {
            throw new SchemaRegistryInitializationException("Error electing leader while initializing schema registry", e);
        }
        catch (SchemaRegistryTimeoutException e) {
            throw new SchemaRegistryInitializationException(e);
        }
    }

    public void waitForInit() throws InterruptedException {
        this.kafkaStore.waitForInit();
    }

    @Override
    public boolean initialized() {
        return this.kafkaStore.initialized() && this.initialized.get();
    }

    @Override
    public boolean healthy() {
        if (this.enableStoreHealthCheck) {
            try {
                this.kafkaStore.get(new ContextKey(this.tenant(), "dummy"));
            }
            catch (Throwable t) {
                return false;
            }
        }
        return this.initialized() && this.getResourceExtensions().stream().allMatch(SchemaRegistryResourceExtension::healthy);
    }

    @Override
    public void addLeaderChangeListener(Consumer<Boolean> listener) {
        this.leaderChangeListeners.add(listener);
    }

    @Override
    public boolean isLeader() {
        this.kafkaStore.leaderLock().lock();
        try {
            boolean bl = this.leaderIdentity != null && this.leaderIdentity.equals(this.myIdentity);
            return bl;
        }
        finally {
            this.kafkaStore.leaderLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLeader(@Nullable SchemaRegistryIdentity newLeader) throws SchemaRegistryTimeoutException, SchemaRegistryStoreException, IdGenerationException {
        boolean leaderChanged;
        boolean isLeader;
        long started = this.time.hiResClockMs();
        log.info("Setting the leader to {}", (Object)newLeader);
        if (newLeader != null && !newLeader.getLeaderEligibility()) {
            throw new IllegalStateException("Tried to set an ineligible node to leader: " + String.valueOf(newLeader));
        }
        this.kafkaStore.leaderLock().lock();
        try {
            SchemaRegistryIdentity previousLeader = this.leaderIdentity;
            this.leaderIdentity = newLeader;
            if (this.leaderIdentity == null) {
                this.leaderRestService = null;
            } else {
                this.leaderRestService = new RestService(this.leaderIdentity.getUrl(), true);
                this.leaderRestService.setHttpConnectTimeoutMs(this.leaderConnectTimeoutMs);
                this.leaderRestService.setHttpReadTimeoutMs(this.leaderReadTimeoutMs);
                if (this.sslFactory != null && this.sslFactory.sslContext() != null) {
                    this.leaderRestService.setSslSocketFactory(this.sslFactory.sslContext().getSocketFactory());
                    this.leaderRestService.setHostnameVerifier(this.getHostnameVerifier());
                }
            }
            isLeader = this.isLeader();
            boolean bl = leaderChanged = this.leaderIdentity != null && !this.leaderIdentity.equals(previousLeader);
            if (leaderChanged) {
                log.info("Leader changed from {} to {}", (Object)previousLeader, (Object)this.leaderIdentity);
                if (isLeader) {
                    this.kafkaStore.markLastWrittenOffsetInvalid();
                    if (this.initWaitForReader) {
                        try {
                            this.kafkaStore.waitUntilKafkaReaderReachesLastOffset(this.initTimeout);
                        }
                        catch (StoreException storeException) {
                            throw new SchemaRegistryStoreException("Exception getting latest offset ", storeException);
                        }
                    }
                    this.idGenerator.init();
                }
            }
            this.metricsContainer.getLeaderNode().record(this.isLeader() ? 1.0 : 0.0);
        }
        finally {
            this.kafkaStore.leaderLock().unlock();
        }
        if (leaderChanged) {
            for (Consumer consumer : this.leaderChangeListeners) {
                try {
                    consumer.accept(isLeader);
                }
                catch (Exception e) {
                    log.error("Could not invoke leader change listener", (Throwable)e);
                }
            }
        }
        long elapsed = this.time.hiResClockMs() - started;
        this.metricsContainer.getLeaderInitializationLatencyMetric().record(elapsed);
    }

    @Override
    public SchemaRegistryIdentity myIdentity() {
        return this.myIdentity;
    }

    @Override
    public SchemaRegistryIdentity leaderIdentity() {
        this.kafkaStore.leaderLock().lock();
        try {
            SchemaRegistryIdentity schemaRegistryIdentity = this.leaderIdentity;
            return schemaRegistryIdentity;
        }
        finally {
            this.kafkaStore.leaderLock().unlock();
        }
    }

    @Override
    public RestService leaderRestService() {
        return this.leaderRestService;
    }

    @Override
    public Schema register(String subject, Schema schema, boolean normalize, boolean propagateSchemaTags) throws SchemaRegistryException {
        try {
            Object schemaIdAndSubjects;
            int schemaId;
            boolean doValidation;
            ParsedSchema parsedSchema;
            this.checkRegisterMode(subject, schema);
            this.kafkaStore.waitUntilKafkaReaderReachesLastOffset(subject, this.kafkaStoreTimeoutMs);
            List<SchemaKey> allVersions = this.getAllSchemaKeysDescending(subject);
            ArrayList<Schema> deletedVersions = new ArrayList<Schema>();
            ArrayList<ParsedSchemaHolder> undeletedVersions = new ArrayList<ParsedSchemaHolder>();
            int newVersion = 1;
            for (SchemaKey schemaKey : allVersions) {
                LazyParsedSchemaHolder schemaHolder = new LazyParsedSchemaHolder(this, schemaKey);
                SchemaValue schemaValue = schemaHolder.schemaValue();
                newVersion = Math.max(newVersion, schemaValue.getVersion() + 1);
                if (schemaValue.isDeleted()) {
                    deletedVersions.add(new Schema(schemaValue.getSubject(), schemaValue.getVersion(), schemaValue.getId()));
                    continue;
                }
                if (!undeletedVersions.isEmpty()) {
                    schemaHolder.clear();
                }
                undeletedVersions.add(schemaHolder);
            }
            Config config = this.getConfigInScope(subject);
            Mode mode = this.getModeInScope(subject);
            if (!mode.isImportOrForwardMode()) {
                this.maybePopulateFromPrevious(config, schema, undeletedVersions, newVersion, propagateSchemaTags);
            }
            if ((parsedSchema = this.canonicalizeSchema(schema, config, doValidation = (schemaId = schema.getId().intValue()) < 0 && this.isSchemaNameValidationEnabled(config), normalize)) != null && (schemaIdAndSubjects = this.lookupCache.schemaIdAndSubjects(schema)) != null && (schemaId < 0 || schemaId == ((SchemaIdAndSubjects)schemaIdAndSubjects).getSchemaId())) {
                if (schema.getVersion() == 0 && ((SchemaIdAndSubjects)schemaIdAndSubjects).hasSubject(subject) && !this.isSubjectVersionDeleted(subject, ((SchemaIdAndSubjects)schemaIdAndSubjects).getVersion(subject))) {
                    return schema.copy(Integer.valueOf(((SchemaIdAndSubjects)schemaIdAndSubjects).getVersion(subject)), Integer.valueOf(((SchemaIdAndSubjects)schemaIdAndSubjects).getSchemaId()));
                }
                schemaId = ((SchemaIdAndSubjects)schemaIdAndSubjects).getSchemaId();
            }
            if (schema.getVersion() == 0) {
                for (ParsedSchemaHolder schemaHolder : undeletedVersions) {
                    SchemaValue schemaValue = ((LazyParsedSchemaHolder)schemaHolder).schemaValue();
                    ParsedSchema undeletedSchema = schemaHolder.schema();
                    if (parsedSchema == null || schemaId >= 0 && schemaId != schemaValue.getId() || !parsedSchema.canLookup(undeletedSchema, (SchemaVersionFetcher)this)) continue;
                    return schema.copy(schemaValue.getVersion(), schemaValue.getId());
                }
            }
            boolean isCompatible = true;
            ArrayList<String> compatibilityErrorLogs = new ArrayList<String>();
            if (!mode.isImportOrForwardMode()) {
                Collections.reverse(undeletedVersions);
                compatibilityErrorLogs.addAll(this.isCompatibleWithPrevious(config, parsedSchema, undeletedVersions));
                isCompatible = compatibilityErrorLogs.isEmpty();
            }
            if (isCompatible) {
                ContextKey contextKey;
                QualifiedSubject qs = QualifiedSubject.create((String)this.tenant(), (String)subject);
                if (qs != null && !".".equals(qs.getContext()) && this.kafkaStore.get(contextKey = new ContextKey(qs.getTenant(), qs.getContext())) == null) {
                    ContextValue contextValue = new ContextValue(qs.getTenant(), qs.getContext());
                    this.kafkaStore.put(contextKey, contextValue);
                }
                if (schema.getVersion() <= 0) {
                    schema.setVersion(Integer.valueOf(newVersion));
                } else if (newVersion != schema.getVersion() && !mode.isImportOrForwardMode()) {
                    throw new InvalidSchemaException("Version is not one more than previous version");
                }
                SchemaKey schemaKey = new SchemaKey(subject, schema.getVersion());
                SchemaValue schemaValue = new SchemaValue(schema, this.ruleSetHandler);
                this.metadataEncoder.encodeMetadata(schemaValue);
                if (schemaId >= 0) {
                    this.checkIfSchemaWithIdExist(schemaId, schema);
                    schema.setId(Integer.valueOf(schemaId));
                    schemaValue.setId(schemaId);
                } else {
                    String qctx = QualifiedSubject.qualifiedContextFor((String)this.tenant(), (String)subject);
                    int retries = 0;
                    while (retries++ < this.kafkaStoreMaxRetries) {
                        int newId = this.idGenerator.id(schemaValue);
                        if (this.lookupCache.schemaKeyById(newId, qctx) != null) continue;
                        schema.setId(Integer.valueOf(newId));
                        schemaValue.setId(newId);
                        if (retries <= 1) break;
                        log.warn("Retrying to register the schema with ID {}", (Object)newId);
                        break;
                    }
                    if (retries >= this.kafkaStoreMaxRetries) {
                        throw new SchemaRegistryStoreException("Error while registering the schema due to generating an ID that is already in use.");
                    }
                }
                for (Schema deleted : deletedVersions) {
                    if (!deleted.getId().equals(schema.getId()) || deleted.getVersion().compareTo(schema.getVersion()) >= 0) continue;
                    SchemaKey key = new SchemaKey(deleted.getSubject(), deleted.getVersion());
                    this.kafkaStore.put(key, null);
                }
                this.kafkaStore.put(schemaKey, schemaValue);
                this.logSchemaOp(schema, "REGISTER");
                return schema;
            }
            throw new IncompatibleSchemaException(((Object)compatibilityErrorLogs).toString());
        }
        catch (EntryTooLargeException e) {
            throw new SchemaTooLargeException("Write failed because schema is too large", e);
        }
        catch (StoreTimeoutException te) {
            throw new SchemaRegistryTimeoutException("Write to the Kafka store timed out while", te);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error while registering the schema in the backend Kafka store", e);
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof SchemaRegistryException) {
                throw (SchemaRegistryException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Schema registerOrForward(String subject, RegisterSchemaRequest request, boolean normalize, Map<String, String> headerProperties) throws SchemaRegistryException {
        Schema existingSchema;
        boolean isLatestVersion;
        Schema schema = new Schema(subject, request);
        Config config = this.getConfigInScope(subject);
        boolean bl = isLatestVersion = schema.getVersion() == -1;
        if (!(request.hasSchemaTagsToAddOrRemove() || request.doPropagateSchemaTags() || config.hasDefaultsOrOverrides() || (existingSchema = this.lookUpSchemaUnderSubject(config, subject, schema, normalize, false, isLatestVersion)) == null)) {
            if (schema.getVersion() == 0 || isLatestVersion) {
                if (schema.getId() == null || schema.getId() < 0 || schema.getId().equals(existingSchema.getId())) {
                    return existingSchema;
                }
            } else if (existingSchema.getId().equals(schema.getId())) {
                if (existingSchema.getVersion().equals(schema.getVersion())) {
                    return existingSchema;
                }
                Schema olderVersionSchema = this.get(subject, schema.getVersion(), false);
                if (olderVersionSchema != null && olderVersionSchema.getId().equals(existingSchema.getId()) && MD5.ofSchema(olderVersionSchema).equals(MD5.ofSchema(existingSchema))) {
                    return olderVersionSchema;
                }
            }
        }
        this.kafkaStore.lockFor(subject).lock();
        try {
            Schema schema2;
            if (this.isLeader()) {
                schema2 = this.register(subject, request, normalize);
                return schema2;
            }
            if (this.leaderIdentity != null) {
                schema2 = this.forwardRegisterRequestToLeader(subject, request, normalize, headerProperties);
                return schema2;
            }
            throw new UnknownLeaderException("Register schema request failed since leader is unknown");
        }
        finally {
            this.kafkaStore.lockFor(subject).unlock();
        }
    }

    @Override
    public Schema modifySchemaTagsOrForward(String subject, Schema schema, TagSchemaRequest request, Map<String, String> headerProperties) throws SchemaRegistryException {
        this.kafkaStore.lockFor(subject).lock();
        try {
            if (this.isLeader()) {
                Schema schema2 = this.modifySchemaTags(subject, schema, request);
                return schema2;
            }
            if (this.leaderIdentity != null) {
                Schema schema3 = this.forwardModifySchemaTagsRequestToLeader(subject, schema, request, headerProperties);
                return schema3;
            }
            throw new UnknownLeaderException("Request failed since leader is unknown");
        }
        finally {
            this.kafkaStore.lockFor(subject).unlock();
        }
    }

    @Override
    public void deleteSchemaVersion(String subject, Schema schema, boolean permanentDelete) throws SchemaRegistryException {
        try {
            if (this.isReadOnlyMode(subject)) {
                String context = QualifiedSubject.qualifiedContextFor((String)this.tenant(), (String)subject);
                throw new OperationNotPermittedException("Subject " + subject + " in context " + context + " is in read-only mode");
            }
            SchemaKey key = new SchemaKey(subject, schema.getVersion());
            if (!this.lookupCache.referencesSchema(key).isEmpty()) {
                throw new ReferenceExistsException(key.toString());
            }
            SchemaValue schemaValue = (SchemaValue)this.lookupCache.get(key);
            if (permanentDelete && schemaValue != null && !schemaValue.isDeleted()) {
                throw new SchemaVersionNotSoftDeletedException(subject, schema.getVersion().toString());
            }
            this.kafkaStore.waitUntilKafkaReaderReachesLastOffset(subject, this.kafkaStoreTimeoutMs);
            if (!permanentDelete) {
                schemaValue = new SchemaValue(schema);
                schemaValue.setDeleted(true);
                this.metadataEncoder.encodeMetadata(schemaValue);
                this.kafkaStore.put(key, schemaValue);
                this.logSchemaOp(schema, "DELETE");
            } else {
                this.kafkaStore.put(key, null);
                if (!this.getAllVersions(subject, LookupFilter.INCLUDE_DELETED).hasNext()) {
                    if (this.getMode(subject) != null) {
                        this.deleteMode(subject);
                    }
                    if (this.getConfig(subject) != null) {
                        this.deleteConfig(subject);
                    }
                }
            }
        }
        catch (StoreTimeoutException te) {
            throw new SchemaRegistryTimeoutException("Write to the Kafka store timed out while", te);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error while deleting the schema for subject '" + subject + "' in the backend Kafka store", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSchemaVersionOrForward(Map<String, String> headerProperties, String subject, Schema schema, boolean permanentDelete) throws SchemaRegistryException {
        block5: {
            this.kafkaStore.lockFor(subject).lock();
            try {
                if (this.isLeader()) {
                    this.deleteSchemaVersion(subject, schema, permanentDelete);
                    break block5;
                }
                if (this.leaderIdentity != null) {
                    this.forwardDeleteSchemaVersionRequestToLeader(headerProperties, subject, schema.getVersion(), permanentDelete);
                    break block5;
                }
                throw new UnknownLeaderException("Register schema request failed since leader is unknown");
            }
            finally {
                this.kafkaStore.lockFor(subject).unlock();
            }
        }
    }

    @Override
    public List<Integer> deleteSubject(String subject, boolean permanentDelete) throws SchemaRegistryException {
        try {
            SubjectKey key;
            if (this.isReadOnlyMode(subject)) {
                String context = QualifiedSubject.qualifiedContextFor((String)this.tenant(), (String)subject);
                throw new OperationNotPermittedException("Subject " + subject + " in context " + context + " is in read-only mode");
            }
            this.kafkaStore.waitUntilKafkaReaderReachesLastOffset(subject, this.kafkaStoreTimeoutMs);
            ArrayList<Integer> deletedVersions = new ArrayList<Integer>();
            int deleteWatermarkVersion = 0;
            Iterator<SchemaKey> schemasToBeDeleted = this.getAllVersions(subject, permanentDelete ? LookupFilter.INCLUDE_DELETED : LookupFilter.DEFAULT);
            while (schemasToBeDeleted.hasNext()) {
                SchemaValue schemaValue;
                deleteWatermarkVersion = schemasToBeDeleted.next().getVersion();
                key = new SchemaKey(subject, deleteWatermarkVersion);
                if (!this.lookupCache.referencesSchema((SchemaKey)key).isEmpty()) {
                    throw new ReferenceExistsException(((SchemaKey)key).toString());
                }
                if (permanentDelete && (schemaValue = (SchemaValue)this.lookupCache.get(key)) != null && !schemaValue.isDeleted()) {
                    throw new SubjectNotSoftDeletedException(subject);
                }
                deletedVersions.add(deleteWatermarkVersion);
            }
            if (!permanentDelete) {
                key = new DeleteSubjectKey(subject);
                DeleteSubjectValue value = new DeleteSubjectValue(subject, deleteWatermarkVersion);
                this.kafkaStore.put(key, value);
            } else {
                for (Integer version : deletedVersions) {
                    this.kafkaStore.put(new SchemaKey(subject, version), null);
                }
                if (this.getMode(subject) != null) {
                    this.deleteMode(subject);
                }
                if (this.getConfig(subject) != null) {
                    this.deleteConfig(subject);
                }
            }
            return deletedVersions;
        }
        catch (StoreTimeoutException te) {
            throw new SchemaRegistryTimeoutException("Write to the Kafka store timed out while", te);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error while deleting the subject in the backend Kafka store", e);
        }
    }

    @Override
    public List<Integer> deleteSubjectOrForward(Map<String, String> requestProperties, String subject, boolean permanentDelete) throws SchemaRegistryException {
        this.kafkaStore.lockFor(subject).lock();
        try {
            if (this.isLeader()) {
                List<Integer> list = this.deleteSubject(subject, permanentDelete);
                return list;
            }
            if (this.leaderIdentity != null) {
                List<Integer> list = this.forwardDeleteSubjectRequestToLeader(requestProperties, subject, permanentDelete);
                return list;
            }
            throw new UnknownLeaderException("Register schema request failed since leader is unknown");
        }
        finally {
            this.kafkaStore.lockFor(subject).unlock();
        }
    }

    @Override
    public void deleteContext(String delimitedContext) throws SchemaRegistryException {
        try {
            String rawContext = QualifiedSubject.contextFor((String)this.tenant(), (String)delimitedContext);
            ContextKey contextKey = new ContextKey(this.tenant(), rawContext);
            this.kafkaStore.delete(contextKey);
        }
        catch (StoreTimeoutException te) {
            throw new SchemaRegistryTimeoutException("Write to the Kafka store timed out while", te);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error while deleting the context in the backend Kafka store", e);
        }
    }

    @Override
    public void deleteContextOrForward(Map<String, String> requestProperties, String delimitedContext) throws SchemaRegistryException {
        block5: {
            this.kafkaStore.lockFor(delimitedContext).lock();
            try {
                if (this.isLeader()) {
                    this.deleteContext(delimitedContext);
                    break block5;
                }
                if (this.leaderIdentity != null) {
                    this.forwardDeleteContextRequestToLeader(requestProperties, delimitedContext);
                    break block5;
                }
                throw new UnknownLeaderException("Register schema request failed since leader is unknown");
            }
            finally {
                this.kafkaStore.lockFor(delimitedContext).unlock();
            }
        }
    }

    private Schema forwardRegisterRequestToLeader(String subject, RegisterSchemaRequest registerSchemaRequest, boolean normalize, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        UrlList baseUrl = this.leaderRestService.getBaseUrls();
        log.debug("Forwarding registering schema request to {}", (Object)baseUrl);
        try {
            RegisterSchemaResponse response = this.leaderRestService.registerSchema(headerProperties, registerSchemaRequest, subject, normalize);
            return new Schema(subject, response);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the registering schema request to %s", baseUrl), e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    public Schema forwardModifySchemaTagsRequestToLeader(String subject, Schema schema, TagSchemaRequest request, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        UrlList baseUrl = this.leaderRestService.getBaseUrls();
        log.debug("Forwarding register schema tags request to {}", (Object)baseUrl);
        try {
            RegisterSchemaResponse response = this.leaderRestService.modifySchemaTags(headerProperties, request, subject, String.valueOf(schema.getVersion()));
            return new Schema(subject, response);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the register schema tags request to %s", baseUrl), e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private Config forwardUpdateConfigRequestToLeader(String subject, ConfigUpdateRequest configUpdateRequest, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        UrlList baseUrl = this.leaderRestService.getBaseUrls();
        log.debug("Forwarding update config request {} to {}", (Object)configUpdateRequest, (Object)baseUrl);
        try {
            return new Config(this.leaderRestService.updateConfig(headerProperties, configUpdateRequest, subject));
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the update config request %s to %s", configUpdateRequest, baseUrl), e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private void forwardDeleteSchemaVersionRequestToLeader(Map<String, String> headerProperties, String subject, Integer version, boolean permanentDelete) throws SchemaRegistryRequestForwardingException {
        UrlList baseUrl = this.leaderRestService.getBaseUrls();
        log.debug("Forwarding deleteSchemaVersion schema version request {}-{} to {}", new Object[]{subject, version, baseUrl});
        try {
            this.leaderRestService.deleteSchemaVersion(headerProperties, subject, String.valueOf(version), permanentDelete);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding deleteSchemaVersion schema version request %s-%s to %s", subject, version, baseUrl), e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private List<Integer> forwardDeleteSubjectRequestToLeader(Map<String, String> requestProperties, String subject, boolean permanentDelete) throws SchemaRegistryRequestForwardingException {
        UrlList baseUrl = this.leaderRestService.getBaseUrls();
        log.debug("Forwarding delete subject request for {} to {}", (Object)subject, (Object)baseUrl);
        try {
            return this.leaderRestService.deleteSubject(requestProperties, subject, permanentDelete);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding delete subject request %s to %s", subject, baseUrl), e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private void forwardDeleteContextRequestToLeader(Map<String, String> requestProperties, String delimitedContext) throws SchemaRegistryRequestForwardingException {
        UrlList baseUrl = this.leaderRestService.getBaseUrls();
        log.debug("Forwarding delete context request for {} to {}", (Object)delimitedContext, (Object)baseUrl);
        try {
            this.leaderRestService.deleteContext(requestProperties, delimitedContext);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding delete context request %s to %s", delimitedContext, baseUrl), e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private void forwardDeleteConfigToLeader(Map<String, String> requestProperties, String subject) throws SchemaRegistryRequestForwardingException {
        UrlList baseUrl = this.leaderRestService.getBaseUrls();
        log.debug("Forwarding delete subject compatibility config request {} to {}", (Object)subject, (Object)baseUrl);
        try {
            this.leaderRestService.deleteConfig(requestProperties, subject);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding delete subject compatibility configrequest %s to %s", subject, baseUrl), e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private void forwardSetModeRequestToLeader(String subject, ModeUpdateRequest modeUpdateRequest, boolean force, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        UrlList baseUrl = this.leaderRestService.getBaseUrls();
        log.debug("Forwarding update mode request {} to {}", (Object)modeUpdateRequest, (Object)baseUrl);
        try {
            this.leaderRestService.setMode(headerProperties, modeUpdateRequest, subject, force);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding the update mode request %s to %s", modeUpdateRequest, baseUrl), e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private void forwardDeleteSubjectModeRequestToLeader(String subject, boolean recursive, Map<String, String> headerProperties) throws SchemaRegistryRequestForwardingException {
        UrlList baseUrl = this.leaderRestService.getBaseUrls();
        log.debug("Forwarding delete subject mode request {} to {} with recursive={}", new Object[]{subject, baseUrl, recursive});
        try {
            this.leaderRestService.deleteSubjectMode(headerProperties, subject, recursive);
        }
        catch (IOException e) {
            throw new SchemaRegistryRequestForwardingException(String.format("Unexpected error while forwarding delete subject moderequest %s to %s", subject, baseUrl), e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    @Override
    public SchemaString get(int id, String subject, String format, boolean fetchMaxId) throws SchemaRegistryException {
        SchemaString schemaString;
        SchemaValue schema;
        try {
            SchemaKey subjectVersionKey = this.getSchemaKeyUsingContexts(id, subject);
            if (subjectVersionKey == null) {
                return null;
            }
            schema = (SchemaValue)this.kafkaStore.get(subjectVersionKey);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error while retrieving schema with id " + id + " from the backend Kafka store", e);
        }
        Schema schemaEntity = this.toSchemaEntity(schema);
        this.logSchemaOp(schemaEntity, "READ");
        SchemaString schemaString2 = schemaString = subject != null ? new SchemaString(schemaEntity) : new SchemaString(null, null, schemaEntity);
        if (format != null && !format.trim().isEmpty()) {
            ParsedSchema parsedSchema = this.parseSchema(schemaEntity, false, false);
            schemaString.setSchemaString(parsedSchema.formattedString(format));
        } else {
            schemaString.setSchemaString(schema.getSchema());
        }
        if (fetchMaxId) {
            schemaString.setMaxId(Integer.valueOf(this.idGenerator.getMaxId(schema)));
        }
        return schemaString;
    }

    @Override
    public void close() throws IOException {
        log.info("Shutting down schema registry");
        if (this.leaderElector != null) {
            this.leaderElector.close();
        }
        if (this.leaderRestService != null) {
            this.leaderRestService.close();
        }
        this.kafkaStore.close();
        this.metadataEncoder.close();
    }

    @Override
    public Config updateConfig(String subject, ConfigUpdateRequest config) throws SchemaRegistryStoreException, OperationNotPermittedException, UnknownLeaderException {
        if (this.isReadOnlyMode(subject)) {
            String context = QualifiedSubject.qualifiedContextFor((String)this.tenant(), (String)subject);
            throw new OperationNotPermittedException("Subject " + subject + " in context " + context + " is in read-only mode");
        }
        ConfigKey configKey = new ConfigKey(subject);
        try {
            this.kafkaStore.waitUntilKafkaReaderReachesLastOffset(subject, this.kafkaStoreTimeoutMs);
            ConfigValue oldConfig = (ConfigValue)this.kafkaStore.get(configKey);
            ConfigValue newConfig = ConfigValue.update(subject, oldConfig, config, this.ruleSetHandler);
            this.kafkaStore.put(configKey, newConfig);
            log.debug("Wrote new config: {} to the Kafka data store with key {}", (Object)config, (Object)configKey);
            return newConfig.toConfigEntity();
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Failed to write new config value to the store", e);
        }
    }

    @Override
    public Config updateConfigOrForward(String subject, ConfigUpdateRequest newConfig, Map<String, String> headerProperties) throws SchemaRegistryStoreException, SchemaRegistryRequestForwardingException, UnknownLeaderException, OperationNotPermittedException {
        this.kafkaStore.lockFor(subject).lock();
        try {
            if (this.isLeader()) {
                Config config = this.updateConfig(subject, newConfig);
                return config;
            }
            if (this.leaderIdentity != null) {
                Config config = this.forwardUpdateConfigRequestToLeader(subject, newConfig, headerProperties);
                return config;
            }
            throw new UnknownLeaderException("Update config request failed since leader is unknown");
        }
        finally {
            this.kafkaStore.lockFor(subject).unlock();
        }
    }

    @Override
    public void deleteSubjectConfig(String subject) throws SchemaRegistryStoreException, OperationNotPermittedException {
        if (this.isReadOnlyMode(subject)) {
            String context = QualifiedSubject.qualifiedContextFor((String)this.tenant(), (String)subject);
            throw new OperationNotPermittedException("Subject " + subject + " in context " + context + " is in read-only mode");
        }
        try {
            this.kafkaStore.waitUntilKafkaReaderReachesLastOffset(subject, this.kafkaStoreTimeoutMs);
            this.deleteConfig(subject);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Failed to delete subject config value from store", e);
        }
    }

    @Override
    public void deleteConfigOrForward(String subject, Map<String, String> headerProperties) throws SchemaRegistryStoreException, SchemaRegistryRequestForwardingException, OperationNotPermittedException, UnknownLeaderException {
        block5: {
            this.kafkaStore.lockFor(subject).lock();
            try {
                if (this.isLeader()) {
                    this.deleteSubjectConfig(subject);
                    break block5;
                }
                if (this.leaderIdentity != null) {
                    this.forwardDeleteConfigToLeader(headerProperties, subject);
                    break block5;
                }
                throw new UnknownLeaderException("Delete config request failed since leader is unknown");
            }
            finally {
                this.kafkaStore.lockFor(subject).unlock();
            }
        }
    }

    private static String kafkaClusterId(SchemaRegistryConfig config) throws SchemaRegistryException {
        String string;
        block8: {
            int initTimeout = config.getInt("kafkastore.init.timeout.ms");
            Properties adminClientProps = new Properties();
            KafkaStore.addSchemaRegistryConfigsToClientProperties(config, adminClientProps);
            adminClientProps.put("bootstrap.servers", config.bootstrapBrokers());
            AdminClient adminClient = AdminClient.create((Properties)adminClientProps);
            try {
                string = (String)adminClient.describeCluster().clusterId().get((long)initTimeout, TimeUnit.MILLISECONDS);
                if (adminClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (adminClient != null) {
                        try {
                            adminClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    throw new SchemaRegistryException("Failed to get Kafka cluster ID", e);
                }
            }
            adminClient.close();
        }
        return string;
    }

    @Override
    public String getKafkaClusterId() {
        return this.kafkaClusterId;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    private void deleteMode(String subject) throws StoreException {
        ModeKey modeKey = new ModeKey(subject);
        this.kafkaStore.delete(modeKey);
    }

    private void deleteConfig(String subject) throws StoreException {
        ConfigKey configKey = new ConfigKey(subject);
        this.kafkaStore.delete(configKey);
    }

    @Override
    public void setMode(String subject, ModeUpdateRequest request, boolean force) throws SchemaRegistryException {
        if (!this.allowModeChanges) {
            throw new OperationNotPermittedException("Mode changes are not allowed");
        }
        Mode mode = null;
        if (request.getOptionalMode().isPresent()) {
            mode = Enum.valueOf(Mode.class, request.getMode().toUpperCase(Locale.ROOT));
        }
        ModeKey modeKey = new ModeKey(subject);
        try {
            this.kafkaStore.waitUntilKafkaReaderReachesLastOffset(subject, this.kafkaStoreTimeoutMs);
            if (mode == Mode.IMPORT && this.getModeInScope(subject) != Mode.IMPORT && !force) {
                if (this.hasSubjects(subject, false)) {
                    throw new OperationNotPermittedException("Cannot import since found existing subjects");
                }
                ArrayList<SchemaKey> deletedVersions = new ArrayList<SchemaKey>();
                Set<String> allSubjects = this.subjects(subject, true);
                for (String s : allSubjects) {
                    Iterator<SchemaKey> schemasToBeDeleted = this.getAllVersions(s, LookupFilter.INCLUDE_DELETED);
                    while (schemasToBeDeleted.hasNext()) {
                        SchemaKey key = schemasToBeDeleted.next();
                        if (!this.lookupCache.referencesSchema(key).isEmpty()) {
                            throw new ReferenceExistsException(key.toString());
                        }
                        deletedVersions.add(key);
                    }
                }
                for (SchemaKey key : deletedVersions) {
                    this.kafkaStore.put(key, null);
                }
                this.kafkaStore.put(new ClearSubjectKey(subject), new ClearSubjectValue(subject));
            }
            this.kafkaStore.put(modeKey, mode != null ? new ModeValue(subject, mode) : null);
            log.debug("Wrote new mode: {} to the Kafka data store with key {}", (Object)mode, (Object)modeKey);
        }
        catch (StoreTimeoutException te) {
            throw new SchemaRegistryTimeoutException("Write to the Kafka store timed out while", te);
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Failed to write new mode to the store", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setModeOrForward(String subject, ModeUpdateRequest mode, boolean force, Map<String, String> headerProperties) throws SchemaRegistryException {
        block5: {
            this.kafkaStore.lockFor(subject).lock();
            try {
                if (this.isLeader()) {
                    this.setMode(subject, mode, force);
                    break block5;
                }
                if (this.leaderIdentity != null) {
                    this.forwardSetModeRequestToLeader(subject, mode, force, headerProperties);
                    break block5;
                }
                throw new UnknownLeaderException("Update mode request failed since leader is unknown");
            }
            finally {
                this.kafkaStore.lockFor(subject).unlock();
            }
        }
    }

    @Override
    public void deleteSubjectMode(String subject) throws SchemaRegistryStoreException, OperationNotPermittedException {
        this.deleteSubjectMode(subject, false);
    }

    @Override
    public void deleteSubjectMode(String subject, boolean recursive) throws SchemaRegistryStoreException, OperationNotPermittedException {
        block5: {
            if (!this.allowModeChanges) {
                throw new OperationNotPermittedException("Mode changes are not allowed");
            }
            try {
                this.kafkaStore.waitUntilKafkaReaderReachesLastOffset(subject, this.kafkaStoreTimeoutMs);
                this.deleteMode(subject);
                if (!recursive || !QualifiedSubject.isContext((String)this.tenant(), (String)subject)) break block5;
                log.info("Recursively deleting mode for all subjects under context: {}", (Object)subject);
                try {
                    this.deleteModesForSubjectsUnderContext(subject);
                }
                catch (SchemaRegistryException e) {
                    throw new SchemaRegistryStoreException("Failed to recursively delete modes for subjects under context", e);
                }
            }
            catch (StoreException e) {
                throw new SchemaRegistryStoreException("Failed to delete subject config value from store", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSubjectModeOrForward(String subject, boolean recursive, Map<String, String> headerProperties) throws SchemaRegistryStoreException, SchemaRegistryRequestForwardingException, OperationNotPermittedException, UnknownLeaderException {
        block5: {
            this.kafkaStore.lockFor(subject).lock();
            try {
                if (this.isLeader()) {
                    this.deleteSubjectMode(subject, recursive);
                    break block5;
                }
                if (this.leaderIdentity != null) {
                    this.forwardDeleteSubjectModeRequestToLeader(subject, recursive, headerProperties);
                    break block5;
                }
                throw new UnknownLeaderException("Delete mode request failed since leader is unknown");
            }
            finally {
                this.kafkaStore.lockFor(subject).unlock();
            }
        }
    }

    private Set<String> listSubjectsWithModePrefix(String prefix) throws SchemaRegistryException {
        try {
            ModeKey startKey = new ModeKey(prefix + "\u0000");
            ModeKey endKey = new ModeKey(prefix + "\uffff");
            LinkedHashSet<String> subjects = new LinkedHashSet<String>();
            try (CloseableIterator<SchemaRegistryValue> iterator = this.kafkaStore.getAll(startKey, endKey);){
                while (iterator.hasNext()) {
                    ModeValue modeValue;
                    String subject;
                    SchemaRegistryValue value = (SchemaRegistryValue)iterator.next();
                    if (!(value instanceof ModeValue) || (subject = (modeValue = (ModeValue)value).getSubject()) == null || !subject.startsWith(prefix)) continue;
                    subjects.add(subject);
                }
            }
            return subjects;
        }
        catch (StoreException e) {
            throw new SchemaRegistryStoreException("Error while retrieving subjects with modes under prefix: " + prefix, e);
        }
    }

    private void deleteModesForSubjectsUnderContext(String context) throws SchemaRegistryException {
        String subjectPrefix = context != null ? context : QualifiedSubject.normalize((String)this.tenant(), (String)":.:");
        Set<String> subjects = this.listSubjectsWithModePrefix(subjectPrefix);
        log.info("Found {} subjects with modes under context '{}' for recursive mode deletion with subjectPrefix={}", new Object[]{subjects.size(), context, subjectPrefix});
        int successCount = 0;
        for (String subjectName : subjects) {
            log.debug("Deleting mode for subject: {}", (Object)subjectName);
            this.deleteSubjectMode(subjectName);
            ++successCount;
        }
        log.info("Recursive mode deletion completed successfully for {} subjects", (Object)successCount);
    }

    @Override
    public KafkaStore<SchemaRegistryKey, SchemaRegistryValue> getKafkaStore() {
        return this.kafkaStore;
    }
}

