/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.testutil.MockSchemaRegistry;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDeConfig;
import io.confluent.kafka.serializers.subject.SubjectNameStrategy;
import io.confluent.kafka.serializers.subject.TopicNameStrategy;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.cache.Cache;
import org.apache.kafka.common.cache.LRUCache;
import org.apache.kafka.common.cache.SynchronizedCache;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.SerializationException;

public abstract class AbstractKafkaSchemaSerDe {
    protected static final byte MAGIC_BYTE = 0;
    protected static final int idSize = 4;
    private static int DEFAULT_CACHE_CAPACITY = 1000;
    protected SchemaRegistryClient schemaRegistry;
    protected Object keySubjectNameStrategy = new TopicNameStrategy();
    protected Object valueSubjectNameStrategy = new TopicNameStrategy();
    protected Cache<SubjectSchema, ParsedSchema> latestVersions = new SynchronizedCache((Cache)new LRUCache(DEFAULT_CACHE_CAPACITY));
    protected boolean useSchemaReflection;

    protected void configureClientProperties(AbstractKafkaSchemaSerDeConfig config, SchemaProvider provider) {
        List<String> urls = config.getSchemaRegistryUrls();
        int maxSchemaObject = config.getMaxSchemasPerSubject();
        Map originals = config.originalsWithPrefix("");
        if (null == this.schemaRegistry) {
            String mockScope = MockSchemaRegistry.validateAndMaybeGetMockScope(urls);
            List<SchemaProvider> providers = Collections.singletonList(provider);
            this.schemaRegistry = mockScope != null ? MockSchemaRegistry.getClientForScope((String)mockScope, providers) : new CachedSchemaRegistryClient(urls, maxSchemaObject, providers, originals, config.requestHeaders());
        }
        this.keySubjectNameStrategy = config.keySubjectNameStrategy();
        this.valueSubjectNameStrategy = config.valueSubjectNameStrategy();
        this.useSchemaReflection = config.useSchemaReflection();
    }

    protected String getSubjectName(String topic, boolean isKey, Object value, ParsedSchema schema) {
        Object subjectNameStrategy = this.subjectNameStrategy(isKey);
        if (subjectNameStrategy instanceof io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy) {
            return ((io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy)subjectNameStrategy).subjectName(topic, isKey, schema);
        }
        return ((SubjectNameStrategy)subjectNameStrategy).getSubjectName(topic, isKey, value);
    }

    protected boolean isDeprecatedSubjectNameStrategy(boolean isKey) {
        Object subjectNameStrategy = this.subjectNameStrategy(isKey);
        return !(subjectNameStrategy instanceof io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy);
    }

    private Object subjectNameStrategy(boolean isKey) {
        return isKey ? this.keySubjectNameStrategy : this.valueSubjectNameStrategy;
    }

    protected String getOldSubjectName(Object value) {
        if (value instanceof GenericContainer) {
            return ((GenericContainer)value).getSchema().getName() + "-value";
        }
        throw new SerializationException("Primitive types are not supported yet");
    }

    @Deprecated
    public int register(String subject, Schema schema) throws IOException, RestClientException {
        return this.schemaRegistry.register(subject, schema);
    }

    public int register(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.schemaRegistry.register(subject, schema);
    }

    @Deprecated
    public Schema getById(int id) throws IOException, RestClientException {
        return this.schemaRegistry.getById(id);
    }

    public ParsedSchema getSchemaById(int id) throws IOException, RestClientException {
        return this.schemaRegistry.getSchemaById(id);
    }

    @Deprecated
    public Schema getBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        return this.schemaRegistry.getBySubjectAndId(subject, id);
    }

    public ParsedSchema getSchemaBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        return this.schemaRegistry.getSchemaBySubjectAndId(subject, id);
    }

    protected ParsedSchema lookupLatestVersion(String subject, ParsedSchema schema, boolean latestCompatStrict) throws IOException, RestClientException {
        return AbstractKafkaSchemaSerDe.lookupLatestVersion(this.schemaRegistry, subject, schema, this.latestVersions, latestCompatStrict);
    }

    protected static ParsedSchema lookupLatestVersion(SchemaRegistryClient schemaRegistry, String subject, ParsedSchema schema, Cache<SubjectSchema, ParsedSchema> cache, boolean latestCompatStrict) throws IOException, RestClientException {
        SubjectSchema ss = new SubjectSchema(subject, schema);
        ParsedSchema latestVersion = null;
        if (cache != null) {
            latestVersion = (ParsedSchema)cache.get((Object)ss);
        }
        if (latestVersion == null) {
            SchemaMetadata schemaMetadata = schemaRegistry.getLatestSchemaMetadata(subject);
            Optional optSchema = schemaRegistry.parseSchema(schemaMetadata.getSchemaType(), schemaMetadata.getSchema(), schemaMetadata.getReferences());
            latestVersion = (ParsedSchema)optSchema.orElseThrow(() -> new IOException("Invalid schema " + schemaMetadata.getSchema() + " with refs " + schemaMetadata.getReferences() + " of type " + schemaMetadata.getSchemaType()));
            if (latestCompatStrict && !latestVersion.isBackwardCompatible(schema).isEmpty()) {
                throw new IOException("Incompatible schema " + schemaMetadata.getSchema() + " with refs " + schemaMetadata.getReferences() + " of type " + schemaMetadata.getSchemaType() + " for schema " + schema.canonicalString());
            }
            if (cache != null) {
                cache.put((Object)ss, (Object)latestVersion);
            }
        }
        return latestVersion;
    }

    protected ByteBuffer getByteBuffer(byte[] payload) {
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        if (buffer.get() != 0) {
            throw new SerializationException("Unknown magic byte!");
        }
        return buffer;
    }

    protected static KafkaException toKafkaException(RestClientException e, String errorMessage) {
        if (e.getErrorCode() / 100 == 4) {
            return new InvalidConfigurationException(e.getMessage());
        }
        return new SerializationException(errorMessage, (Throwable)e);
    }

    protected static class SubjectSchema {
        private String subject;
        private ParsedSchema schema;

        public SubjectSchema(String subject, ParsedSchema schema) {
            this.subject = subject;
            this.schema = schema;
        }

        public String getSubject() {
            return this.subject;
        }

        public ParsedSchema getSchema() {
            return this.schema;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubjectSchema that = (SubjectSchema)o;
            return this.subject.equals(that.subject) && this.schema.equals(that.schema);
        }

        public int hashCode() {
            return Objects.hash(this.subject, this.schema);
        }
    }
}

