/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.streams.serdes.avro;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.streams.serdes.avro.ReflectionAvroDeserializer;
import io.confluent.kafka.streams.serdes.avro.ReflectionAvroSerializer;
import java.util.Map;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;

@InterfaceStability.Unstable
public class ReflectionAvroSerde<T>
implements Serde<T> {
    private final Serde<T> inner;

    public ReflectionAvroSerde(Class<T> type) {
        this.inner = Serdes.serdeFrom(new ReflectionAvroSerializer(), new ReflectionAvroDeserializer<T>(type));
    }

    public ReflectionAvroSerde(SchemaRegistryClient client, Class<T> type) {
        if (client == null) {
            throw new IllegalArgumentException("schema registry client must not be null");
        }
        this.inner = Serdes.serdeFrom(new ReflectionAvroSerializer(client), new ReflectionAvroDeserializer<T>(client, type));
    }

    public Serializer<T> serializer() {
        return this.inner.serializer();
    }

    public Deserializer<T> deserializer() {
        return this.inner.deserializer();
    }

    public void configure(Map<String, ?> serdeConfig, boolean isSerdeForRecordKeys) {
        this.inner.serializer().configure(serdeConfig, isSerdeForRecordKeys);
        this.inner.deserializer().configure(serdeConfig, isSerdeForRecordKeys);
    }

    public void close() {
        this.inner.serializer().close();
        this.inner.deserializer().close();
    }
}

