/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.streams.serdes.avro;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.streams.serdes.avro.ConfigurationUtils;
import java.util.Map;
import org.apache.avro.specific.SpecificRecord;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.serialization.Deserializer;

@InterfaceStability.Unstable
public class SpecificAvroDeserializer<T extends SpecificRecord>
implements Deserializer<T> {
    private final KafkaAvroDeserializer inner;

    public SpecificAvroDeserializer() {
        this.inner = new KafkaAvroDeserializer();
    }

    SpecificAvroDeserializer(SchemaRegistryClient client) {
        this.inner = new KafkaAvroDeserializer(client);
    }

    public void configure(Map<String, ?> deserializerConfig, boolean isDeserializerForRecordKeys) {
        this.inner.configure(ConfigurationUtils.withSpecificAvroEnabled(deserializerConfig), isDeserializerForRecordKeys);
    }

    public T deserialize(String topic, byte[] bytes) {
        return (T)((SpecificRecord)this.inner.deserialize(topic, bytes));
    }

    public void close() {
        this.inner.close();
    }
}

