/**
 * Copyright © 2016 Jeremy Custenborder (jcustenborder@gmail.com)
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.confluent.kafka.connect.utils.data.type;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTypeParser extends BaseDateTypeParser {
  public DateTypeParser() {
    super(TimeZone.getTimeZone("UTC"), new SimpleDateFormat("yyyy-MM-dd"));
  }

  public DateTypeParser(TimeZone timeZone, SimpleDateFormat... dateFormats) {
    super(timeZone, dateFormats);
  }

  @Override
  Date process(Date date) {
    Calendar calendar = Calendar.getInstance(this.timeZone);
    calendar.setTime(date);
    calendar.set(11, 0);
    calendar.set(12, 0);
    calendar.set(13, 0);
    calendar.set(14, 0);
    return calendar.getTime();
  }
}
