/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.connect.utils.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;

public class MarkdownFormatter {
    private static List<ConfigDef.ConfigKey> getSortedList(Map<String, ConfigDef.ConfigKey> configKeys) {
        ArrayList<ConfigDef.ConfigKey> configs = new ArrayList<ConfigDef.ConfigKey>(configKeys.values());
        Collections.sort(configs, new Comparator<ConfigDef.ConfigKey>(){

            @Override
            public int compare(ConfigDef.ConfigKey k1, ConfigDef.ConfigKey k2) {
                if (!k1.hasDefault() && k2.hasDefault()) {
                    return -1;
                }
                if (!k2.hasDefault() && k1.hasDefault()) {
                    return 1;
                }
                int cmp = k1.importance.compareTo((Enum)k2.importance);
                if (cmp == 0) {
                    return k1.name.compareTo(k2.name);
                }
                return cmp;
            }
        });
        return configs;
    }

    static String getDefaultValue(ConfigDef.ConfigKey def) {
        if (def.hasDefault()) {
            if (def.defaultValue == null) {
                return "null";
            }
            if (def.type == ConfigDef.Type.STRING && def.defaultValue.toString().isEmpty()) {
                return "\"\"";
            }
            return def.defaultValue.toString();
        }
        return "";
    }

    public static String toMarkdown(ConfigDef configDef) {
        int i;
        StringBuilder b = new StringBuilder();
        List<ConfigDef.ConfigKey> configs = MarkdownFormatter.getSortedList(configDef.configKeys());
        String[] headers = new String[]{"Name", "Description", "Type", "Default", "Valid Values", "Importance"};
        int[] lengths = new int[headers.length];
        for (int i2 = 0; i2 < headers.length; ++i2) {
            lengths[i2] = headers[i2].length();
        }
        for (ConfigDef.ConfigKey def : configs) {
            for (int i3 = 0; i3 < headers.length; ++i3) {
                int length = 0;
                switch (i3) {
                    case 0: {
                        length = null == def.name ? 0 : def.name.length();
                        break;
                    }
                    case 1: {
                        length = null == def.documentation ? 0 : def.documentation.length();
                        break;
                    }
                    case 2: {
                        length = null == def.type ? 0 : def.type.toString().length();
                        break;
                    }
                    case 3: {
                        String defaultValue = MarkdownFormatter.getDefaultValue(def);
                        length = null == defaultValue ? 0 : defaultValue.length();
                        break;
                    }
                    case 4: {
                        String validValues = def.validator != null ? def.validator.toString() : "";
                        length = null == validValues ? 0 : validValues.length();
                        break;
                    }
                    case 5: {
                        length = null == def.importance ? 0 : def.importance.toString().length();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("There are more headers than columns.");
                    }
                }
                if (length <= lengths[i3]) continue;
                lengths[i3] = length;
            }
        }
        for (i = 0; i < headers.length; ++i) {
            String header = headers[i];
            String format = " %-" + lengths[i] + "s ";
            String value = String.format(format, header);
            if (i == 0) {
                b.append("|");
            }
            b.append(value);
            b.append("|");
            if (i != headers.length - 1) continue;
            b.append("\n");
        }
        for (i = 0; i < headers.length; ++i) {
            String format = " %-" + lengths[i] + "s ";
            String value = String.format(format, "").replace(" ", "-");
            if (i == 0) {
                b.append("|");
            }
            b.append(value);
            b.append("|");
            if (i != headers.length - 1) continue;
            b.append("\n");
        }
        for (ConfigDef.ConfigKey def : configs) {
            for (int i4 = 0; i4 < headers.length; ++i4) {
                String value;
                int length = lengths[i4];
                String format = " %-" + lengths[i4] + "s ";
                switch (i4) {
                    case 0: {
                        value = def.name;
                        break;
                    }
                    case 1: {
                        value = null == def.documentation ? "" : def.documentation;
                        break;
                    }
                    case 2: {
                        value = def.type.toString().toLowerCase();
                        break;
                    }
                    case 3: {
                        String defaultValue = MarkdownFormatter.getDefaultValue(def);
                        value = null == defaultValue ? "" : defaultValue;
                        break;
                    }
                    case 4: {
                        String validValues = def.validator != null ? def.validator.toString() : "";
                        value = null == validValues ? "" : validValues;
                        break;
                    }
                    case 5: {
                        value = def.importance.toString().toLowerCase();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("There are more headers than columns.");
                    }
                }
                if (i4 == 0) {
                    b.append("|");
                }
                b.append(String.format(format, value));
                b.append("|");
                if (i4 != headers.length - 1) continue;
                b.append("\n");
            }
        }
        return b.toString();
    }
}

