/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.connect.utils.data;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import io.confluent.kafka.connect.utils.data.ParserKey;
import io.confluent.kafka.connect.utils.data.type.BooleanParser;
import io.confluent.kafka.connect.utils.data.type.DateTypeParser;
import io.confluent.kafka.connect.utils.data.type.DecimalTypeParser;
import io.confluent.kafka.connect.utils.data.type.Float32TypeParser;
import io.confluent.kafka.connect.utils.data.type.Float64TypeParser;
import io.confluent.kafka.connect.utils.data.type.Int16TypeParser;
import io.confluent.kafka.connect.utils.data.type.Int32TypeParser;
import io.confluent.kafka.connect.utils.data.type.Int64TypeParser;
import io.confluent.kafka.connect.utils.data.type.Int8TypeParser;
import io.confluent.kafka.connect.utils.data.type.StringTypeParser;
import io.confluent.kafka.connect.utils.data.type.TimeTypeParser;
import io.confluent.kafka.connect.utils.data.type.TimestampTypeParser;
import io.confluent.kafka.connect.utils.data.type.TypeParser;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.DataException;

public class Parser {
    final Map<ParserKey, TypeParser> typeParsers = new HashMap<ParserKey, TypeParser>();

    public Parser() {
        this.registerTypeParser(Schema.BOOLEAN_SCHEMA, new BooleanParser());
        this.registerTypeParser(Schema.BOOLEAN_SCHEMA, new BooleanParser());
        this.registerTypeParser(Schema.FLOAT32_SCHEMA, new Float32TypeParser());
        this.registerTypeParser(Schema.FLOAT64_SCHEMA, new Float64TypeParser());
        this.registerTypeParser(Schema.INT8_SCHEMA, new Int8TypeParser());
        this.registerTypeParser(Schema.INT16_SCHEMA, new Int16TypeParser());
        this.registerTypeParser(Schema.INT32_SCHEMA, new Int32TypeParser());
        this.registerTypeParser(Schema.INT64_SCHEMA, new Int64TypeParser());
        this.registerTypeParser(Schema.STRING_SCHEMA, new StringTypeParser());
        this.registerTypeParser(Decimal.schema((int)1), new DecimalTypeParser());
        this.registerTypeParser(Date.SCHEMA, new DateTypeParser());
        this.registerTypeParser(Time.SCHEMA, new TimeTypeParser());
        this.registerTypeParser(Timestamp.SCHEMA, new TimestampTypeParser());
    }

    public final void registerTypeParser(Schema schema, TypeParser typeParser) {
        Preconditions.checkNotNull((Object)schema, (Object)"schema cannot be null.");
        Preconditions.checkNotNull((Object)typeParser, (Object)"typeParser cannot be null.");
        this.typeParsers.put(new ParserKey(schema), typeParser);
    }

    public Object parseString(Schema schema, String input) {
        this.checkSchemaAndInput(schema, input);
        if (null == input) {
            return null;
        }
        TypeParser parser = this.findParser(schema);
        try {
            Object result = parser.parseString(input, schema);
            return result;
        }
        catch (Exception ex) {
            String message = String.format("Could not parse '%s' to '%s'", input, parser.expectedClass().getSimpleName());
            throw new DataException(message, (Throwable)ex);
        }
    }

    void checkSchemaAndInput(Schema schema, Object input) {
        Preconditions.checkNotNull((Object)schema, (Object)"schema cannot be null");
        if (!schema.isOptional()) {
            Preconditions.checkNotNull((Object)input, (Object)"schema is not optional so input cannot be null.");
        }
    }

    TypeParser findParser(Schema schema) {
        ParserKey parserKey = new ParserKey(schema);
        TypeParser parser = this.typeParsers.get(parserKey);
        if (null == parser) {
            throw new UnsupportedOperationException(String.format("Schema %s(%s) is not supported", schema.type(), schema.name()));
        }
        return parser;
    }

    public Object parseJsonNode(Schema schema, JsonNode input) {
        this.checkSchemaAndInput(schema, input);
        if (null == input || input.isNull()) {
            return null;
        }
        TypeParser parser = this.findParser(schema);
        try {
            Object result = parser.parseJsonNode(input, schema);
            return result;
        }
        catch (Exception ex) {
            String message = String.format("Could not parse '%s' to '%s'", input, parser.expectedClass().getSimpleName());
            throw new DataException(message, (Throwable)ex);
        }
    }
}

