/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.connect.utils.data.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.confluent.kafka.connect.utils.data.type.TypeParser;
import java.math.BigDecimal;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.DataException;

public class DecimalTypeParser
implements TypeParser {
    final Cache<Schema, Integer> schemaCache = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.SECONDS).build();

    private static int scale(Schema schema) {
        String scaleString = (String)schema.parameters().get("scale");
        if (scaleString == null) {
            throw new DataException("Invalid Decimal schema: scale parameter not found.");
        }
        try {
            return Integer.parseInt(scaleString);
        }
        catch (NumberFormatException var3) {
            throw new DataException("Invalid scale parameter found in Decimal schema: ", (Throwable)var3);
        }
    }

    int getScale(final Schema schema) {
        int scale;
        try {
            scale = (Integer)this.schemaCache.get((Object)schema, (Callable)new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return DecimalTypeParser.scale(schema);
                }
            });
        }
        catch (ExecutionException e) {
            throw new DataException((Throwable)e);
        }
        return scale;
    }

    @Override
    public Object parseString(String s, Schema schema) {
        int scale = this.getScale(schema);
        return new BigDecimal(s).setScale(scale);
    }

    @Override
    public Class<?> expectedClass() {
        return BigDecimal.class;
    }

    @Override
    public Object parseJsonNode(JsonNode input, Schema schema) {
        Preconditions.checkState((boolean)input.isBigDecimal(), (String)"'%s' is not a '%s'", (Object[])new Object[]{input.textValue(), this.expectedClass().getSimpleName()});
        int scale = this.getScale(schema);
        return input.decimalValue().setScale(scale);
    }
}

