/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.connect.utils.data.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import io.confluent.kafka.connect.utils.data.type.TypeParser;
import org.apache.kafka.connect.data.Schema;

public class Float32TypeParser
implements TypeParser {
    @Override
    public Object parseString(String s, Schema schema) {
        return Float.valueOf(Float.parseFloat(s));
    }

    @Override
    public Class<?> expectedClass() {
        return Float.class;
    }

    @Override
    public Object parseJsonNode(JsonNode input, Schema schema) {
        Preconditions.checkState((input.isFloat() || input.isDouble() ? 1 : 0) != 0, (String)"'%s' is not a '%s'", (Object[])new Object[]{input.asText(), this.expectedClass().getSimpleName()});
        return Float.valueOf(input.decimalValue().floatValue());
    }
}

