/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.connect.utils.data.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import io.confluent.kafka.connect.utils.data.type.TypeParser;
import org.apache.kafka.connect.data.Schema;

public class Int8TypeParser
implements TypeParser {
    @Override
    public Object parseString(String s, Schema schema) {
        return Byte.parseByte(s);
    }

    @Override
    public Class<?> expectedClass() {
        return Byte.class;
    }

    @Override
    public Object parseJsonNode(JsonNode input, Schema schema) {
        Preconditions.checkState((boolean)input.isInt(), (String)"'%s' is not a '%s'", (Object[])new Object[]{input.textValue(), this.expectedClass().getSimpleName()});
        return input.bigIntegerValue().byteValue();
    }
}

