/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.connect.utils.template;

import com.google.common.base.Preconditions;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.InvalidReferenceException;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import io.confluent.kafka.connect.utils.template.ConnectObjectWrapper;
import io.confluent.kafka.connect.utils.template.ConnectTemplateHashModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.DataException;

public class StructTemplate {
    final Configuration configuration = new Configuration(Configuration.getVersion());
    final StringTemplateLoader loader = new StringTemplateLoader();

    public StructTemplate() {
        this.configuration.setTemplateLoader((TemplateLoader)this.loader);
        this.configuration.setDefaultEncoding("UTF-8");
        this.configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.configuration.setLogTemplateExceptions(false);
        this.configuration.setObjectWrapper((ObjectWrapper)new ConnectObjectWrapper());
    }

    public void addTemplate(String templateName, String template) {
        this.loader.putTemplate(templateName, template);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String executeInternal(String templateName, Object value) {
        Template template;
        Preconditions.checkNotNull((Object)templateName, (Object)"templateName cannot be null.");
        Preconditions.checkNotNull((Object)value, (Object)"values cannot be null.");
        try {
            template = this.configuration.getTemplate(templateName);
        }
        catch (IOException ex) {
            throw new DataException(String.format("Exception thrown while loading template '%s'", templateName), (Throwable)ex);
        }
        try (StringWriter writer = new StringWriter();){
            template.process(value, (Writer)writer);
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            throw new ConnectException("Exception while processing template", (Throwable)e);
        }
        catch (InvalidReferenceException e) {
            throw new DataException(String.format("Exception thrown while processing template. Offending expression '%s'", e.getBlamedExpressionString()), (Throwable)e);
        }
        catch (TemplateException e) {
            throw new ConnectException("Exception while processing template", (Throwable)e);
        }
    }

    public String execute(String templateName, Map<String, ?> values) {
        return this.executeInternal(templateName, values);
    }

    public String execute(String templateName, ConnectRecord record, Struct struct, Map<String, ?> additionalValues) {
        ConnectTemplateHashModel connectTemplateHashModel = new ConnectTemplateHashModel(record, struct);
        return this.executeInternal(templateName, (Object)connectTemplateHashModel);
    }
}

