/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import io.confluent.ksql.util.KsqlException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AggregateFunctionInitArguments {
    private final int udafIndex;
    private final List<Object> initArgs;
    public static final AggregateFunctionInitArguments EMPTY_ARGS = new AggregateFunctionInitArguments();

    public AggregateFunctionInitArguments(int index, Object ... initArgs) {
        this(index, Arrays.asList(initArgs));
    }

    public AggregateFunctionInitArguments(int index, List<Object> initArgs) {
        this.udafIndex = index;
        this.initArgs = Objects.requireNonNull(initArgs);
        if (index < 0) {
            throw new IllegalArgumentException("index is negative: " + index);
        }
    }

    private AggregateFunctionInitArguments() {
        this.udafIndex = 0;
        this.initArgs = Collections.emptyList();
    }

    public int udafIndex() {
        return this.udafIndex;
    }

    public Object arg(int i) {
        return this.initArgs.get(i);
    }

    public List<Object> args() {
        return this.initArgs;
    }

    public void ensureArgCount(int expectedCount, String functionName) {
        if (this.initArgs.size() != expectedCount) {
            throw new KsqlException(String.format("Invalid parameter count for %s. Need %d args, got %d arg(s)", functionName, expectedCount, this.initArgs.size()));
        }
    }

    public int argsSize() {
        return this.initArgs.size();
    }
}

