/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.confluent.ksql.function.types.ArrayType;
import io.confluent.ksql.function.types.BooleanType;
import io.confluent.ksql.function.types.DecimalType;
import io.confluent.ksql.function.types.DoubleType;
import io.confluent.ksql.function.types.GenericType;
import io.confluent.ksql.function.types.IntegerType;
import io.confluent.ksql.function.types.LongType;
import io.confluent.ksql.function.types.MapType;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.types.StringType;
import io.confluent.ksql.function.types.StructType;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlMap;
import io.confluent.ksql.schema.ksql.types.SqlStruct;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlPreconditions;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class GenericsUtil {
    private GenericsUtil() {
    }

    public static boolean isGeneric(ParamType type) {
        return type instanceof GenericType;
    }

    public static Set<ParamType> constituentGenerics(ParamType type) {
        if (type instanceof ArrayType) {
            return GenericsUtil.constituentGenerics(((ArrayType)type).element());
        }
        if (type instanceof MapType) {
            return Sets.union(GenericsUtil.constituentGenerics(((MapType)type).key()), GenericsUtil.constituentGenerics(((MapType)type).value()));
        }
        if (type instanceof StructType) {
            return ((StructType)type).getSchema().values().stream().map(GenericsUtil::constituentGenerics).flatMap(Collection::stream).collect(Collectors.toSet());
        }
        if (type instanceof GenericType) {
            return ImmutableSet.of((Object)type);
        }
        return ImmutableSet.of();
    }

    public static boolean hasGenerics(ParamType type) {
        return !GenericsUtil.constituentGenerics(type).isEmpty();
    }

    public static SqlType applyResolved(ParamType schema, Map<GenericType, SqlType> resolved) {
        if (schema instanceof ArrayType) {
            return SqlTypes.array((SqlType)GenericsUtil.applyResolved(((ArrayType)schema).element(), resolved));
        }
        if (schema instanceof MapType) {
            return SqlTypes.map((SqlType)GenericsUtil.applyResolved(((MapType)schema).value(), resolved));
        }
        if (schema instanceof StructType) {
            SqlStruct.Builder struct = SqlTypes.struct();
            ((StructType)schema).getSchema().forEach((fieldName, type) -> struct.field(fieldName, GenericsUtil.applyResolved(type, resolved)));
            return struct.build();
        }
        if (schema instanceof GenericType) {
            SqlType instance = resolved.get(schema);
            if (instance == null) {
                throw new KsqlException("Could not find mapping for generic type: " + schema);
            }
            return instance;
        }
        return SchemaConverters.functionToSqlConverter().toSqlType(schema);
    }

    public static Map<GenericType, SqlType> resolveGenerics(ParamType schema, SqlType instance) {
        ArrayList<Map.Entry<GenericType, SqlType>> genericMapping = new ArrayList<Map.Entry<GenericType, SqlType>>();
        boolean success = GenericsUtil.resolveGenerics(genericMapping, schema, instance);
        if (!success) {
            throw new KsqlException(String.format("Cannot infer generics for %s from %s because they do not have the same schema structure.", schema, instance));
        }
        HashMap mapping = new HashMap();
        for (Map.Entry entry : genericMapping) {
            SqlType old = (SqlType)mapping.putIfAbsent(entry.getKey(), entry.getValue());
            if (old == null || old.equals(entry.getValue())) continue;
            throw new KsqlException(String.format("Found invalid instance of generic schema. Cannot map %s to both %s and %s", schema, old, instance));
        }
        return ImmutableMap.copyOf(mapping);
    }

    private static boolean resolveGenerics(List<Map.Entry<GenericType, SqlType>> mapping, ParamType schema, SqlType instance) {
        if (!GenericsUtil.isGeneric(schema) && !GenericsUtil.matches(schema, instance)) {
            return false;
        }
        if (!GenericsUtil.hasGenerics(schema)) {
            return true;
        }
        KsqlPreconditions.checkArgument(GenericsUtil.isGeneric(schema) || GenericsUtil.matches(schema, instance), "Cannot resolve generics if the schema and instance have differing types: " + schema + " vs. " + instance);
        if (GenericsUtil.isGeneric(schema)) {
            mapping.add(new AbstractMap.SimpleEntry<GenericType, SqlType>((GenericType)schema, instance));
        }
        if (schema instanceof ArrayType) {
            return GenericsUtil.resolveGenerics(mapping, ((ArrayType)schema).element(), ((SqlArray)instance).getItemType());
        }
        if (schema instanceof MapType) {
            return GenericsUtil.resolveGenerics(mapping, ((MapType)schema).value(), ((SqlMap)instance).getValueType());
        }
        if (schema instanceof StructType) {
            throw new KsqlException("Generic STRUCT is not yet supported");
        }
        return true;
    }

    private static boolean matches(ParamType schema, SqlType instance) {
        switch (instance.baseType()) {
            case BOOLEAN: {
                return schema instanceof BooleanType;
            }
            case INTEGER: {
                return schema instanceof IntegerType;
            }
            case BIGINT: {
                return schema instanceof LongType;
            }
            case DECIMAL: {
                return schema instanceof DecimalType;
            }
            case DOUBLE: {
                return schema instanceof DoubleType;
            }
            case STRING: {
                return schema instanceof StringType;
            }
            case ARRAY: {
                return schema instanceof ArrayType;
            }
            case MAP: {
                return schema instanceof MapType;
            }
            case STRUCT: {
                return schema instanceof StructType;
            }
        }
        return false;
    }

    public static boolean instanceOf(ParamType schema, SqlType instance) {
        ArrayList<Map.Entry<GenericType, SqlType>> mappings = new ArrayList<Map.Entry<GenericType, SqlType>>();
        if (!GenericsUtil.resolveGenerics(mappings, schema, instance)) {
            return false;
        }
        HashMap asMap = new HashMap();
        for (Map.Entry entry : mappings) {
            SqlType old = (SqlType)asMap.putIfAbsent(entry.getKey(), entry.getValue());
            if (old == null || old.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }
}

